/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.util.List;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.GitDateFormatter;

public class SquashMessageFormatter {
    private GitDateFormatter dateFormatter = new GitDateFormatter(GitDateFormatter.Format.DEFAULT);

    public String format(List<RevCommit> squashedCommits, Ref target) {
        StringBuilder sb = new StringBuilder();
        sb.append("Squashed commit of the following:\n");
        for (RevCommit c2 : squashedCommits) {
            sb.append("\ncommit ");
            sb.append(c2.getName());
            sb.append("\n");
            sb.append(this.toString(c2.getAuthorIdent()));
            sb.append("\n\t");
            sb.append(c2.getShortMessage());
            sb.append("\n");
        }
        return sb.toString();
    }

    private String toString(PersonIdent author) {
        StringBuilder a2 = new StringBuilder();
        a2.append("Author: ");
        a2.append(author.getName());
        a2.append(" <");
        a2.append(author.getEmailAddress());
        a2.append(">\n");
        a2.append("Date:   ");
        a2.append(this.dateFormatter.formatDate(author));
        a2.append("\n");
        return a2.toString();
    }
}

