/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.nls;

import java.lang.reflect.Field;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jgit.errors.TranslationBundleLoadingException;
import org.eclipse.jgit.errors.TranslationStringMissingException;

public abstract class TranslationBundle {
    private Locale effectiveLocale;
    private ResourceBundle resourceBundle;

    public Locale effectiveLocale() {
        return this.effectiveLocale;
    }

    public ResourceBundle resourceBundle() {
        return this.resourceBundle;
    }

    void load(Locale locale) throws TranslationBundleLoadingException {
        Class<?> bundleClass = this.getClass();
        try {
            this.resourceBundle = ResourceBundle.getBundle(bundleClass.getName(), locale, bundleClass.getClassLoader());
        }
        catch (MissingResourceException e2) {
            throw new TranslationBundleLoadingException(bundleClass, locale, e2);
        }
        this.effectiveLocale = this.resourceBundle.getLocale();
        Field[] fieldArray = bundleClass.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getType().equals(String.class)) {
                try {
                    String translatedText = this.resourceBundle.getString(field.getName());
                    field.set(this, translatedText);
                }
                catch (MissingResourceException e3) {
                    throw new TranslationStringMissingException(bundleClass, locale, field.getName(), (Exception)e3);
                }
                catch (IllegalAccessException | IllegalArgumentException e4) {
                    throw new Error(e4);
                }
            }
            ++n2;
        }
    }
}

