/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.notes;

import java.io.IOException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.Merger;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.notes.DefaultNoteMerger;
import org.eclipse.jgit.notes.FanoutBucket;
import org.eclipse.jgit.notes.InMemoryNoteBucket;
import org.eclipse.jgit.notes.LeafBucket;
import org.eclipse.jgit.notes.NonNoteEntry;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteBucket;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.notes.NoteMerger;
import org.eclipse.jgit.notes.NoteParser;
import org.eclipse.jgit.notes.NotesMergeConflictException;

public class NoteMapMerger {
    private static final FanoutBucket EMPTY_FANOUT = new FanoutBucket(0);
    private static final LeafBucket EMPTY_LEAF = new LeafBucket(0);
    private final Repository db;
    private final NoteMerger noteMerger;
    private final MergeStrategy nonNotesMergeStrategy;
    private final ObjectReader reader;
    private final ObjectInserter inserter;
    private final MutableObjectId objectIdPrefix;

    public NoteMapMerger(Repository db, NoteMerger noteMerger, MergeStrategy nonNotesMergeStrategy) {
        this.db = db;
        this.reader = db.newObjectReader();
        this.inserter = db.newObjectInserter();
        this.noteMerger = noteMerger;
        this.nonNotesMergeStrategy = nonNotesMergeStrategy;
        this.objectIdPrefix = new MutableObjectId();
    }

    public NoteMapMerger(Repository db) {
        this(db, new DefaultNoteMerger(), MergeStrategy.RESOLVE);
    }

    public NoteMap merge(NoteMap base, NoteMap ours, NoteMap theirs) throws IOException {
        try {
            InMemoryNoteBucket mergedBucket = this.merge(0, base.getRoot(), ours.getRoot(), theirs.getRoot());
            this.inserter.flush();
            NoteMap noteMap = NoteMap.newMap(mergedBucket, this.reader);
            return noteMap;
        }
        finally {
            this.reader.close();
            this.inserter.close();
        }
    }

    private InMemoryNoteBucket merge(int treeDepth, InMemoryNoteBucket base, InMemoryNoteBucket ours, InMemoryNoteBucket theirs) throws IOException {
        InMemoryNoteBucket result2 = base instanceof FanoutBucket || ours instanceof FanoutBucket || theirs instanceof FanoutBucket ? this.mergeFanoutBucket(treeDepth, this.asFanout(base), this.asFanout(ours), this.asFanout(theirs)) : this.mergeLeafBucket(treeDepth, (LeafBucket)base, (LeafBucket)ours, (LeafBucket)theirs);
        result2.nonNotes = this.mergeNonNotes(NoteMapMerger.nonNotes(base), NoteMapMerger.nonNotes(ours), NoteMapMerger.nonNotes(theirs));
        return result2;
    }

    private FanoutBucket asFanout(InMemoryNoteBucket bucket) {
        if (bucket == null) {
            return EMPTY_FANOUT;
        }
        if (bucket instanceof FanoutBucket) {
            return (FanoutBucket)bucket;
        }
        return ((LeafBucket)bucket).split();
    }

    private static NonNoteEntry nonNotes(InMemoryNoteBucket b2) {
        return b2 == null ? null : b2.nonNotes;
    }

    private InMemoryNoteBucket mergeFanoutBucket(int treeDepth, FanoutBucket base, FanoutBucket ours, FanoutBucket theirs) throws IOException {
        FanoutBucket result2 = new FanoutBucket(treeDepth * 2);
        int i2 = 0;
        while (i2 < 256) {
            NoteBucket t2;
            NoteBucket b2 = base.getBucket(i2);
            NoteBucket o = ours.getBucket(i2);
            if (NoteMapMerger.equals(o, t2 = theirs.getBucket(i2))) {
                this.addIfNotNull(result2, i2, o);
            } else if (NoteMapMerger.equals(b2, o)) {
                this.addIfNotNull(result2, i2, t2);
            } else if (NoteMapMerger.equals(b2, t2)) {
                this.addIfNotNull(result2, i2, o);
            } else {
                this.objectIdPrefix.setByte(treeDepth, i2);
                InMemoryNoteBucket mergedBucket = this.merge(treeDepth + 1, FanoutBucket.loadIfLazy(b2, this.objectIdPrefix, this.reader), FanoutBucket.loadIfLazy(o, this.objectIdPrefix, this.reader), FanoutBucket.loadIfLazy(t2, this.objectIdPrefix, this.reader));
                result2.setBucket(i2, mergedBucket);
            }
            ++i2;
        }
        return result2.contractIfTooSmall(this.objectIdPrefix, this.reader);
    }

    private static boolean equals(NoteBucket a2, NoteBucket b2) {
        if (a2 == null && b2 == null) {
            return true;
        }
        return a2 != null && b2 != null && a2.getTreeId().equals(b2.getTreeId());
    }

    private void addIfNotNull(FanoutBucket b2, int cell, NoteBucket child) throws IOException {
        if (child == null) {
            return;
        }
        if (child instanceof InMemoryNoteBucket) {
            b2.setBucket(cell, child.writeTree(this.inserter));
        } else {
            b2.setBucket(cell, child.getTreeId());
        }
    }

    private InMemoryNoteBucket mergeLeafBucket(int treeDepth, LeafBucket bb, LeafBucket ob, LeafBucket tb) throws MissingObjectException, IOException {
        bb = NoteMapMerger.notNullOrEmpty(bb);
        ob = NoteMapMerger.notNullOrEmpty(ob);
        tb = NoteMapMerger.notNullOrEmpty(tb);
        InMemoryNoteBucket result2 = new LeafBucket(treeDepth * 2);
        int bi = 0;
        int oi = 0;
        int ti = 0;
        while (bi < bb.size() || oi < ob.size() || ti < tb.size()) {
            Note b2 = NoteMapMerger.get(bb, bi);
            Note o = NoteMapMerger.get(ob, oi);
            Note t2 = NoteMapMerger.get(tb, ti);
            Note min2 = NoteMapMerger.min(b2, o, t2);
            b2 = NoteMapMerger.sameNoteOrNull(min2, b2);
            result2 = NoteMapMerger.sameContent(o = NoteMapMerger.sameNoteOrNull(min2, o), t2 = NoteMapMerger.sameNoteOrNull(min2, t2)) ? NoteMapMerger.addIfNotNull(result2, o) : (NoteMapMerger.sameContent(b2, o) ? NoteMapMerger.addIfNotNull(result2, t2) : (NoteMapMerger.sameContent(b2, t2) ? NoteMapMerger.addIfNotNull(result2, o) : NoteMapMerger.addIfNotNull(result2, this.noteMerger.merge(b2, o, t2, this.reader, this.inserter))));
            if (b2 != null) {
                ++bi;
            }
            if (o != null) {
                ++oi;
            }
            if (t2 == null) continue;
            ++ti;
        }
        return result2;
    }

    private static LeafBucket notNullOrEmpty(LeafBucket b2) {
        return b2 != null ? b2 : EMPTY_LEAF;
    }

    private static Note get(LeafBucket b2, int i2) {
        return i2 < b2.size() ? b2.get(i2) : null;
    }

    private static Note min(Note b2, Note o, Note t2) {
        Note min2 = b2;
        if (min2 == null || o != null && o.compareTo(min2) < 0) {
            min2 = o;
        }
        if (min2 == null || t2 != null && t2.compareTo(min2) < 0) {
            min2 = t2;
        }
        return min2;
    }

    private static Note sameNoteOrNull(Note min2, Note other) {
        return NoteMapMerger.sameNote(min2, other) ? other : null;
    }

    private static boolean sameNote(Note a2, Note b2) {
        if (a2 == null && b2 == null) {
            return true;
        }
        return a2 != null && b2 != null && AnyObjectId.isEqual(a2, b2);
    }

    private static boolean sameContent(Note a2, Note b2) {
        if (a2 == null && b2 == null) {
            return true;
        }
        return a2 != null && b2 != null && AnyObjectId.isEqual(a2.getData(), b2.getData());
    }

    private static InMemoryNoteBucket addIfNotNull(InMemoryNoteBucket result2, Note note) {
        if (note != null) {
            return result2.append(note);
        }
        return result2;
    }

    private NonNoteEntry mergeNonNotes(NonNoteEntry baseList, NonNoteEntry oursList, NonNoteEntry theirsList) throws IOException {
        if (baseList == null && oursList == null && theirsList == null) {
            return null;
        }
        ObjectId baseId = this.write(baseList);
        ObjectId oursId = this.write(oursList);
        ObjectId theirsId = this.write(theirsList);
        this.inserter.flush();
        Merger m4 = this.nonNotesMergeStrategy.newMerger(this.db, true);
        if (m4 instanceof ThreeWayMerger) {
            ((ThreeWayMerger)m4).setBase(baseId);
        }
        if (!m4.merge(oursId, theirsId)) {
            throw new NotesMergeConflictException(baseList, oursList, theirsList);
        }
        ObjectId resultTreeId = m4.getResultTreeId();
        AbbreviatedObjectId none2 = AbbreviatedObjectId.fromString("");
        return NoteParser.parse((AbbreviatedObjectId)none2, (ObjectId)resultTreeId, (ObjectReader)this.reader).nonNotes;
    }

    private ObjectId write(NonNoteEntry list) throws IOException {
        LeafBucket b2 = new LeafBucket(0);
        b2.nonNotes = list;
        return b2.writeTree(this.inserter);
    }
}

