/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.patch;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.patch.BinaryHunk;
import org.eclipse.jgit.patch.CombinedFileHeader;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.patch.FormatError;
import org.eclipse.jgit.patch.HunkHeader;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.TemporaryBuffer;

public class Patch {
    static final byte[] DIFF_GIT = Constants.encodeASCII("diff --git ");
    private static final byte[] DIFF_CC = Constants.encodeASCII("diff --cc ");
    private static final byte[] DIFF_COMBINED = Constants.encodeASCII("diff --combined ");
    private static final byte[][] BIN_HEADERS = new byte[][]{Constants.encodeASCII("Binary files "), Constants.encodeASCII("Files ")};
    private static final byte[] BIN_TRAILER = Constants.encodeASCII(" differ\n");
    private static final byte[] GIT_BINARY = Constants.encodeASCII("GIT binary patch\n");
    static final byte[] SIG_FOOTER = Constants.encodeASCII("-- \n");
    private final List<FileHeader> files = new ArrayList<FileHeader>();
    private final List<FormatError> errors = new ArrayList<FormatError>(0);

    public void addFile(FileHeader fh) {
        this.files.add(fh);
    }

    public List<? extends FileHeader> getFiles() {
        return this.files;
    }

    public void addError(FormatError err) {
        this.errors.add(err);
    }

    public List<FormatError> getErrors() {
        return this.errors;
    }

    public void parse(InputStream is) throws IOException {
        byte[] buf = Patch.readFully(is);
        this.parse(buf, 0, buf.length);
    }

    private static byte[] readFully(InputStream is) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TemporaryBuffer.Heap b2 = new TemporaryBuffer.Heap(Integer.MAX_VALUE);){
            b2.copy(is);
            return b2.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void parse(byte[] buf, int ptr, int end2) {
        while (ptr < end2) {
            ptr = this.parseFile(buf, ptr, end2);
        }
    }

    private int parseFile(byte[] buf, int c2, int end2) {
        while (c2 < end2) {
            if (FileHeader.isHunkHdr(buf, c2, end2) >= 1) {
                this.error(buf, c2, JGitText.get().hunkDisconnectedFromFile);
                c2 = RawParseUtils.nextLF(buf, c2);
                continue;
            }
            if (RawParseUtils.match(buf, c2, DIFF_GIT) >= 0) {
                return this.parseDiffGit(buf, c2, end2);
            }
            if (RawParseUtils.match(buf, c2, DIFF_CC) >= 0) {
                return this.parseDiffCombined(DIFF_CC, buf, c2, end2);
            }
            if (RawParseUtils.match(buf, c2, DIFF_COMBINED) >= 0) {
                return this.parseDiffCombined(DIFF_COMBINED, buf, c2, end2);
            }
            int n = RawParseUtils.nextLF(buf, c2);
            if (n >= end2) {
                return end2;
            }
            if (n - c2 < 6) {
                c2 = n;
                continue;
            }
            if (RawParseUtils.match(buf, c2, FileHeader.OLD_NAME) >= 0 && RawParseUtils.match(buf, n, FileHeader.NEW_NAME) >= 0) {
                int f2 = RawParseUtils.nextLF(buf, n);
                if (f2 >= end2) {
                    return end2;
                }
                if (FileHeader.isHunkHdr(buf, f2, end2) == 1) {
                    return this.parseTraditionalPatch(buf, c2, end2);
                }
            }
            c2 = n;
        }
        return c2;
    }

    private int parseDiffGit(byte[] buf, int start2, int end2) {
        FileHeader fh = new FileHeader(buf, start2);
        int ptr = fh.parseGitFileName(start2 + DIFF_GIT.length, end2);
        if (ptr < 0) {
            return Patch.skipFile(buf, start2);
        }
        ptr = fh.parseGitHeaders(ptr, end2);
        fh.endOffset = ptr = this.parseHunks(fh, ptr, end2);
        this.addFile(fh);
        return ptr;
    }

    private int parseDiffCombined(byte[] hdr, byte[] buf, int start2, int end2) {
        CombinedFileHeader fh = new CombinedFileHeader(buf, start2);
        int ptr = fh.parseGitFileName(start2 + hdr.length, end2);
        if (ptr < 0) {
            return Patch.skipFile(buf, start2);
        }
        ptr = fh.parseGitHeaders(ptr, end2);
        fh.endOffset = ptr = this.parseHunks(fh, ptr, end2);
        this.addFile(fh);
        return ptr;
    }

    private int parseTraditionalPatch(byte[] buf, int start2, int end2) {
        FileHeader fh = new FileHeader(buf, start2);
        int ptr = fh.parseTraditionalHeaders(start2, end2);
        fh.endOffset = ptr = this.parseHunks(fh, ptr, end2);
        this.addFile(fh);
        return ptr;
    }

    private static int skipFile(byte[] buf, int ptr) {
        if (RawParseUtils.match(buf, ptr = RawParseUtils.nextLF(buf, ptr), FileHeader.OLD_NAME) >= 0) {
            ptr = RawParseUtils.nextLF(buf, ptr);
        }
        return ptr;
    }

    private int parseHunks(FileHeader fh, int c2, int end2) {
        byte[] buf = fh.buf;
        block3: while (c2 < end2) {
            if (RawParseUtils.match(buf, c2, DIFF_GIT) >= 0 || RawParseUtils.match(buf, c2, DIFF_CC) >= 0 || RawParseUtils.match(buf, c2, DIFF_COMBINED) >= 0 || RawParseUtils.match(buf, c2, FileHeader.OLD_NAME) >= 0 || RawParseUtils.match(buf, c2, FileHeader.NEW_NAME) >= 0) break;
            if (FileHeader.isHunkHdr(buf, c2, end2) == fh.getParentCount()) {
                HunkHeader h2 = fh.newHunkHeader(c2);
                h2.parseHeader();
                h2.endOffset = c2 = h2.parseBody(this, end2);
                fh.addHunk(h2);
                if (c2 >= end2) continue;
                switch (buf[c2]) {
                    case 10: 
                    case 64: 
                    case 100: {
                        break;
                    }
                    default: {
                        if (RawParseUtils.match(buf, c2, SIG_FOOTER) >= 0) continue block3;
                        this.warn(buf, c2, JGitText.get().unexpectedHunkTrailer);
                        break;
                    }
                }
                continue;
            }
            int eol = RawParseUtils.nextLF(buf, c2);
            if (fh.getHunks().isEmpty() && RawParseUtils.match(buf, c2, GIT_BINARY) >= 0) {
                fh.patchType = FileHeader.PatchType.GIT_BINARY;
                return this.parseGitBinary(fh, eol, end2);
            }
            if (fh.getHunks().isEmpty() && BIN_TRAILER.length < eol - c2 && RawParseUtils.match(buf, eol - BIN_TRAILER.length, BIN_TRAILER) >= 0 && Patch.matchAny(buf, c2, BIN_HEADERS)) {
                fh.patchType = FileHeader.PatchType.BINARY;
                return eol;
            }
            c2 = eol;
        }
        if (fh.getHunks().isEmpty() && fh.getPatchType() == FileHeader.PatchType.UNIFIED && !fh.hasMetaDataChanges()) {
            fh.patchType = FileHeader.PatchType.BINARY;
        }
        return c2;
    }

    private int parseGitBinary(FileHeader fh, int c2, int end2) {
        BinaryHunk postImage = new BinaryHunk(fh, c2);
        int nEnd = postImage.parseHunk(c2, end2);
        if (nEnd < 0) {
            this.error(fh.buf, c2, JGitText.get().missingForwardImageInGITBinaryPatch);
            return c2;
        }
        postImage.endOffset = c2 = nEnd;
        fh.forwardBinaryHunk = postImage;
        BinaryHunk preImage = new BinaryHunk(fh, c2);
        int oEnd = preImage.parseHunk(c2, end2);
        if (oEnd >= 0) {
            preImage.endOffset = c2 = oEnd;
            fh.reverseBinaryHunk = preImage;
        }
        return c2;
    }

    void warn(byte[] buf, int ptr, String msg) {
        this.addError(new FormatError(buf, ptr, FormatError.Severity.WARNING, msg));
    }

    void error(byte[] buf, int ptr, String msg) {
        this.addError(new FormatError(buf, ptr, FormatError.Severity.ERROR, msg));
    }

    private static boolean matchAny(byte[] buf, int c2, byte[][] srcs) {
        byte[][] byArray = srcs;
        int n = srcs.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] s2 = byArray[n2];
            if (RawParseUtils.match(buf, c2, s2) >= 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

