/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;

abstract class AbstractRevQueue
extends Generator {
    static final AbstractRevQueue EMPTY_QUEUE = new AlwaysEmptyQueue();
    int outputType;

    AbstractRevQueue(boolean firstParent) {
        super(firstParent);
    }

    public abstract void add(RevCommit var1);

    public final void add(RevCommit c2, RevFlag queueControl) {
        if (!c2.has(queueControl)) {
            c2.add(queueControl);
            this.add(c2);
        }
    }

    public final void addParents(RevCommit c2, RevFlag queueControl) {
        RevCommit[] pList = c2.getParents();
        if (pList == null) {
            return;
        }
        int i2 = 0;
        while (i2 < pList.length) {
            if (this.firstParent && i2 > 0) break;
            this.add(pList[i2], queueControl);
            ++i2;
        }
    }

    @Override
    public abstract RevCommit next();

    public abstract void clear();

    abstract boolean everbodyHasFlag(int var1);

    abstract boolean anybodyHasFlag(int var1);

    @Override
    int outputType() {
        return this.outputType;
    }

    protected static void describe(StringBuilder s2, RevCommit c2) {
        s2.append(c2.toString());
        s2.append('\n');
    }

    private static class AlwaysEmptyQueue
    extends AbstractRevQueue {
        private AlwaysEmptyQueue() {
            super(false);
        }

        @Override
        public void add(RevCommit c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RevCommit next() {
            return null;
        }

        @Override
        boolean anybodyHasFlag(int f2) {
            return false;
        }

        @Override
        boolean everbodyHasFlag(int f2) {
            return true;
        }

        @Override
        public void clear() {
        }
    }
}

