/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import org.eclipse.jgit.revwalk.RevObject;

class BlockObjQueue {
    private BlockFreeList free = new BlockFreeList();
    private Block head;
    private Block tail;

    BlockObjQueue() {
    }

    void add(RevObject c2) {
        Block b2 = this.tail;
        if (b2 == null) {
            b2 = this.free.newBlock();
            b2.add(c2);
            this.head = b2;
            this.tail = b2;
            return;
        }
        if (b2.isFull()) {
            this.tail.next = b2 = this.free.newBlock();
            this.tail = b2;
        }
        b2.add(c2);
    }

    RevObject next() {
        Block b2 = this.head;
        if (b2 == null) {
            return null;
        }
        RevObject c2 = b2.pop();
        if (b2.isEmpty()) {
            this.head = b2.next;
            if (this.head == null) {
                this.tail = null;
            }
            this.free.freeBlock(b2);
        }
        return c2;
    }

    static final class Block {
        private static final int BLOCK_SIZE = 256;
        Block next;
        final RevObject[] objects = new RevObject[256];
        int headIndex;
        int tailIndex;

        Block() {
        }

        boolean isFull() {
            return this.tailIndex == 256;
        }

        boolean isEmpty() {
            return this.headIndex == this.tailIndex;
        }

        void add(RevObject c2) {
            this.objects[this.tailIndex++] = c2;
        }

        RevObject pop() {
            return this.objects[this.headIndex++];
        }

        void clear() {
            this.next = null;
            this.headIndex = 0;
            this.tailIndex = 0;
        }
    }

    static final class BlockFreeList {
        private Block next;

        BlockFreeList() {
        }

        Block newBlock() {
            Block b2 = this.next;
            if (b2 == null) {
                return new Block();
            }
            this.next = b2.next;
            b2.clear();
            return b2;
        }

        void freeBlock(Block b2) {
            b2.next = this.next;
            this.next = b2;
        }
    }
}

