/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.AbstractRevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

abstract class BlockRevQueue
extends AbstractRevQueue {
    protected BlockFreeList free = new BlockFreeList();

    protected BlockRevQueue(boolean firstParent) {
        super(firstParent);
    }

    BlockRevQueue(Generator s2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        super(s2.firstParent);
        RevCommit c2;
        this.outputType = s2.outputType();
        s2.shareFreeList(this);
        while ((c2 = s2.next()) != null) {
            this.add(c2);
        }
    }

    @Override
    public void shareFreeList(BlockRevQueue q) {
        this.free = q.free;
    }

    static final class Block {
        static final int BLOCK_SIZE = 256;
        Block next;
        final RevCommit[] commits = new RevCommit[256];
        int headIndex;
        int tailIndex;

        Block() {
        }

        boolean isFull() {
            return this.tailIndex == 256;
        }

        boolean isEmpty() {
            return this.headIndex == this.tailIndex;
        }

        boolean canUnpop() {
            return this.headIndex > 0;
        }

        void add(RevCommit c2) {
            this.commits[this.tailIndex++] = c2;
        }

        void unpop(RevCommit c2) {
            this.commits[--this.headIndex] = c2;
        }

        RevCommit pop() {
            return this.commits[this.headIndex++];
        }

        RevCommit peek() {
            return this.commits[this.headIndex];
        }

        void clear() {
            this.next = null;
            this.headIndex = 0;
            this.tailIndex = 0;
        }

        void resetToMiddle() {
            this.tailIndex = 128;
            this.headIndex = 128;
        }

        void resetToEnd() {
            this.tailIndex = 256;
            this.headIndex = 256;
        }
    }

    static final class BlockFreeList {
        private Block next;

        BlockFreeList() {
        }

        Block newBlock() {
            Block b2 = this.next;
            if (b2 == null) {
                return new Block();
            }
            this.next = b2.next;
            b2.clear();
            return b2;
        }

        void freeBlock(Block b2) {
            b2.next = this.next;
            this.next = b2;
        }

        void clear() {
            this.next = null;
        }
    }
}

