/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

class BoundaryGenerator
extends Generator {
    static final int UNINTERESTING = 4;
    Generator g;

    BoundaryGenerator(RevWalk w, Generator s2) {
        super(s2.firstParent);
        this.g = new InitialGenerator(w, s2);
    }

    @Override
    int outputType() {
        return this.g.outputType() | 0x10;
    }

    @Override
    void shareFreeList(BlockRevQueue q) {
        this.g.shareFreeList(q);
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.g.next();
    }

    private class InitialGenerator
    extends Generator {
        private static final int PARSED = 1;
        private static final int DUPLICATE = 16;
        private final RevWalk walk;
        private final FIFORevQueue held;
        private final Generator source;

        InitialGenerator(RevWalk w, Generator s2) {
            super(s2.firstParent);
            this.walk = w;
            this.held = new FIFORevQueue(this.firstParent);
            this.source = s2;
            this.source.shareFreeList(this.held);
        }

        @Override
        int outputType() {
            return this.source.outputType();
        }

        @Override
        void shareFreeList(BlockRevQueue q) {
            q.shareFreeList(this.held);
        }

        @Override
        RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
            RevCommit c2 = this.source.next();
            if (c2 != null) {
                int n = c2.getParentCount();
                int i2 = 0;
                while (i2 < n) {
                    if (this.firstParent && i2 > 0) break;
                    RevCommit p = c2.getParent(i2);
                    if ((p.flags & 4) != 0) {
                        this.held.add(p);
                    }
                    ++i2;
                }
                return c2;
            }
            FIFORevQueue boundary = new FIFORevQueue(this.firstParent);
            boundary.shareFreeList(this.held);
            while ((c2 = this.held.next()) != null) {
                if ((c2.flags & 0x10) != 0) continue;
                if ((c2.flags & 1) == 0) {
                    c2.parseHeaders(this.walk);
                }
                c2.flags |= 0x10;
                boundary.add(c2);
            }
            boundary.removeFlag(16);
            BoundaryGenerator.this.g = boundary;
            return boundary.next();
        }
    }
}

