/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.DateRevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

class DateRevPriorityQueue
extends DateRevQueue {
    private PriorityQueue<RevCommitEntry> queue;
    private final AtomicInteger sequence = new AtomicInteger(1);

    public DateRevPriorityQueue() {
        this(false);
    }

    DateRevPriorityQueue(boolean firstParent) {
        super(firstParent);
        this.initPriorityQueue();
    }

    private void initPriorityQueue() {
        this.sequence.set(1);
        this.queue = new PriorityQueue<RevCommitEntry>(Comparator.comparingInt(ent -> ent.getEntry().getCommitTime()).reversed().thenComparingInt(RevCommitEntry::getInsertSequenceNumber));
    }

    DateRevPriorityQueue(Generator s2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this(s2.firstParent);
        RevCommit c2;
        while ((c2 = s2.next()) != null) {
            this.add(c2);
        }
    }

    @Override
    public void add(RevCommit c2) {
        if (c2 == null) {
            throw new NullPointerException(JGitText.get().nullRevCommit);
        }
        this.queue.add(new RevCommitEntry(this.sequence.getAndIncrement(), c2));
    }

    @Override
    public RevCommit next() {
        RevCommitEntry entry = this.queue.poll();
        return entry == null ? null : entry.getEntry();
    }

    @Override
    @Nullable
    public RevCommit peek() {
        RevCommitEntry entry = this.queue.peek();
        return entry == null ? null : entry.getEntry();
    }

    @Override
    public void clear() {
        this.sequence.set(1);
        this.queue.clear();
    }

    @Override
    boolean everbodyHasFlag(int f2) {
        return this.queue.stream().map(RevCommitEntry::getEntry).noneMatch(c2 -> (c2.flags & f2) == 0);
    }

    @Override
    boolean anybodyHasFlag(int f2) {
        return this.queue.stream().map(RevCommitEntry::getEntry).anyMatch(c2 -> (c2.flags & f2) != 0);
    }

    @Override
    int outputType() {
        return this.outputType | 1;
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        for (RevCommitEntry e2 : this.queue) {
            DateRevPriorityQueue.describe(s2, e2.getEntry());
        }
        return s2.toString();
    }

    private static class RevCommitEntry {
        private final int insertSequenceNumber;
        private final RevCommit entry;

        public RevCommitEntry(int insertSequenceNumber, RevCommit entry) {
            this.insertSequenceNumber = insertSequenceNumber;
            this.entry = entry;
        }

        public int getInsertSequenceNumber() {
            return this.insertSequenceNumber;
        }

        public RevCommit getEntry() {
            return this.entry;
        }
    }
}

