/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

public class FIFORevQueue
extends BlockRevQueue {
    private BlockRevQueue.Block head;
    private BlockRevQueue.Block tail;

    public FIFORevQueue() {
        super(false);
    }

    FIFORevQueue(boolean firstParent) {
        super(firstParent);
    }

    FIFORevQueue(Generator s2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        super(s2);
    }

    @Override
    public void add(RevCommit c2) {
        BlockRevQueue.Block b2 = this.tail;
        if (b2 == null) {
            b2 = this.free.newBlock();
            b2.add(c2);
            this.head = b2;
            this.tail = b2;
            return;
        }
        if (b2.isFull()) {
            this.tail.next = b2 = this.free.newBlock();
            this.tail = b2;
        }
        b2.add(c2);
    }

    public void unpop(RevCommit c2) {
        BlockRevQueue.Block b2 = this.head;
        if (b2 == null) {
            b2 = this.free.newBlock();
            b2.resetToMiddle();
            b2.add(c2);
            this.head = b2;
            this.tail = b2;
            return;
        }
        if (b2.canUnpop()) {
            b2.unpop(c2);
            return;
        }
        b2 = this.free.newBlock();
        b2.resetToEnd();
        b2.unpop(c2);
        b2.next = this.head;
        this.head = b2;
    }

    @Override
    public RevCommit next() {
        BlockRevQueue.Block b2 = this.head;
        if (b2 == null) {
            return null;
        }
        RevCommit c2 = b2.pop();
        if (b2.isEmpty()) {
            this.head = b2.next;
            if (this.head == null) {
                this.tail = null;
            }
            this.free.freeBlock(b2);
        }
        return c2;
    }

    @Override
    public void clear() {
        this.head = null;
        this.tail = null;
        this.free.clear();
    }

    @Override
    boolean everbodyHasFlag(int f2) {
        BlockRevQueue.Block b2 = this.head;
        while (b2 != null) {
            int i2 = b2.headIndex;
            while (i2 < b2.tailIndex) {
                if ((b2.commits[i2].flags & f2) == 0) {
                    return false;
                }
                ++i2;
            }
            b2 = b2.next;
        }
        return true;
    }

    @Override
    boolean anybodyHasFlag(int f2) {
        BlockRevQueue.Block b2 = this.head;
        while (b2 != null) {
            int i2 = b2.headIndex;
            while (i2 < b2.tailIndex) {
                if ((b2.commits[i2].flags & f2) != 0) {
                    return true;
                }
                ++i2;
            }
            b2 = b2.next;
        }
        return false;
    }

    void removeFlag(int f2) {
        int not_f = ~f2;
        BlockRevQueue.Block b2 = this.head;
        while (b2 != null) {
            int i2 = b2.headIndex;
            while (i2 < b2.tailIndex) {
                b2.commits[i2].flags &= not_f;
                ++i2;
            }
            b2 = b2.next;
        }
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        BlockRevQueue.Block q = this.head;
        while (q != null) {
            int i2 = q.headIndex;
            while (i2 < q.tailIndex) {
                FIFORevQueue.describe(s2, q.commits[i2]);
                ++i2;
            }
            q = q.next;
        }
        return s2.toString();
    }
}

