/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.RenameCallback;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.ChangedPathTreeFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class FollowFilter
extends TreeFilter {
    private final ChangedPathTreeFilter path;
    final DiffConfig cfg;
    private RenameCallback renameCallback;

    public static FollowFilter create(String path2, DiffConfig cfg) {
        return new FollowFilter(ChangedPathTreeFilter.create(path2), cfg);
    }

    FollowFilter(ChangedPathTreeFilter path2, DiffConfig cfg) {
        this.path = path2;
        this.cfg = cfg;
    }

    public String getPath() {
        return this.path.getPaths().get(0);
    }

    @Override
    public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.path.include(walker);
    }

    @Override
    public boolean shouldTreeWalk(RevCommit c2, RevWalk rw, TreeFilter.MutableBoolean cpfUsed) {
        return this.path.shouldTreeWalk(c2, rw, cpfUsed);
    }

    @Override
    public boolean shouldBeRecursive() {
        return this.path.shouldBeRecursive();
    }

    @Override
    public Optional<Set<byte[]>> getPathsBestEffort() {
        return this.path.getPathsBestEffort();
    }

    @Override
    public TreeFilter clone() {
        return new FollowFilter(this.path.clone(), this.cfg);
    }

    @Override
    public String toString() {
        return "(FOLLOW(" + this.path.toString() + "))";
    }

    public RenameCallback getRenameCallback() {
        return this.renameCallback;
    }

    public void setRenameCallback(RenameCallback callback2) {
        this.renameCallback = callback2;
    }
}

