/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.AbstractRevQueue;
import org.eclipse.jgit.revwalk.DateRevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

class MergeBaseGenerator
extends Generator {
    private static final int PARSED = 1;
    private static final int IN_PENDING = 2;
    private static final int POPPED = 16;
    private static final int MERGE_BASE = 8;
    private final RevWalk walker;
    private final DateRevQueue pending;
    private int branchMask;
    private int recarryTest;
    private int recarryMask;
    private int mergeBaseAncestor = -1;
    private ArrayDeque<RevCommit> ret = new ArrayDeque();
    private CarryStack stack;
    private static final int CONTINUE = 0;
    private static final int HAVE_ALL = 1;
    private static final int CONTINUE_ON_STACK = 2;

    MergeBaseGenerator(RevWalk w) {
        super(w.isFirstParent());
        this.walker = w;
        this.pending = new DateRevQueue(this.firstParent);
    }

    void init(AbstractRevQueue p) throws IOException {
        try {
            RevCommit c2;
            while ((c2 = p.next()) != null) {
                this.add(c2);
            }
            this.recarryTest = this.branchMask | 0x10;
            this.recarryMask = this.branchMask | 0x10 | 8;
            this.mergeBaseAncestor = this.walker.allocFlag();
            while ((c2 = this._next()) != null) {
                this.ret.add(c2);
            }
        }
        finally {
            this.walker.freeFlag(this.branchMask | this.mergeBaseAncestor);
        }
    }

    private void add(RevCommit c2) {
        int flag = this.walker.allocFlag();
        this.branchMask |= flag;
        if ((c2.flags & this.branchMask) != 0) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().staleRevFlagsOn, c2.name()));
        }
        c2.flags |= flag;
        this.pending.add(c2);
    }

    @Override
    int outputType() {
        return 0;
    }

    private RevCommit _next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c2;
        while (true) {
            boolean mb;
            if ((c2 = this.pending.next()) == null) {
                return null;
            }
            RevCommit[] revCommitArray = c2.getParents();
            int n = revCommitArray.length;
            int n2 = 0;
            while (n2 < n) {
                RevCommit p = revCommitArray[n2];
                if ((p.flags & 2) == 0) {
                    if ((p.flags & 1) == 0) {
                        p.parseHeaders(this.walker);
                    }
                    p.flags |= 2;
                    this.pending.add(p);
                }
                ++n2;
            }
            int carry = c2.flags & this.branchMask;
            boolean bl = mb = carry == this.branchMask;
            if (mb) {
                carry |= 8 | this.mergeBaseAncestor;
            }
            this.carryOntoHistory(c2, carry);
            if ((c2.flags & 8) != 0) {
                if (!this.pending.everbodyHasFlag(8)) continue;
                return null;
            }
            c2.flags |= 0x10;
            if (mb) break;
        }
        c2.flags |= 8;
        return c2;
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        while (!this.ret.isEmpty()) {
            RevCommit commit = this.ret.remove();
            if ((commit.flags & this.mergeBaseAncestor) != 0) continue;
            return commit;
        }
        return null;
    }

    private void carryOntoHistory(RevCommit c2, int carry) {
        this.stack = null;
        while (true) {
            this.carryOntoHistoryInnerLoop(c2, carry);
            if (this.stack == null) break;
            c2 = this.stack.c;
            carry = this.stack.carry;
            this.stack = this.stack.prev;
        }
    }

    private void carryOntoHistoryInnerLoop(RevCommit c2, int carry) {
        RevCommit[] parents;
        while ((parents = c2.getParents()) != null && parents.length != 0) {
            int e2 = parents.length - 1;
            int i2 = 0;
            while (i2 < e2) {
                RevCommit p = parents[i2];
                if (this.carryOntoOne(p, carry) == 0) {
                    this.stack = new CarryStack(this.stack, p, carry);
                }
                ++i2;
            }
            c2 = parents[e2];
            if (this.carryOntoOne(c2, carry) == 0) continue;
        }
    }

    private int carryOntoOne(RevCommit p, int carry) {
        int rc2 = (p.flags & carry) == carry ? 1 : 0;
        p.flags |= carry;
        if ((p.flags & this.recarryMask) == this.recarryTest) {
            p.flags &= 0xFFFFFFEF;
            this.pending.add(p);
            this.stack = new CarryStack(this.stack, p, this.branchMask | 8);
            return 2;
        }
        return rc2;
    }

    private static class CarryStack {
        final CarryStack prev;
        final RevCommit c;
        final int carry;

        CarryStack(CarryStack prev, RevCommit c2, int carry) {
            this.prev = prev;
            this.c = c2;
            this.carry = carry;
        }
    }
}

