/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.DateRevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

class PendingGenerator
extends Generator {
    private static final int PARSED = 1;
    private static final int SEEN = 2;
    private static final int UNINTERESTING = 4;
    static final int OVER_SCAN = 6;
    private static final RevCommit INIT_LAST = new RevCommit(ObjectId.zeroId());
    private final RevWalk walker;
    private final DateRevQueue pending;
    private final RevFilter filter;
    private final int output;
    private RevCommit last = INIT_LAST;
    private int overScan = 6;
    boolean canDispose;

    static {
        PendingGenerator.INIT_LAST.commitTime = Integer.MAX_VALUE;
    }

    PendingGenerator(RevWalk w, DateRevQueue p, RevFilter f2, int out2) {
        super(w.isFirstParent());
        this.walker = w;
        this.pending = p;
        this.filter = f2;
        this.output = out2;
        this.canDispose = true;
    }

    @Override
    int outputType() {
        return this.output | 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        try {
            while (true) {
                boolean produce;
                RevCommit c2;
                block13: {
                    block15: {
                        block14: {
                            if ((c2 = this.pending.next()) == null) {
                                return null;
                            }
                            if ((c2.flags & 4) != 0) {
                                produce = false;
                            } else {
                                if (this.filter.requiresCommitBody()) {
                                    c2.parseBody(this.walker);
                                }
                                produce = this.filter.include(this.walker, c2);
                            }
                            int parentCount = c2.getParentCount();
                            int i2 = 0;
                            while (true) {
                                if (i2 >= parentCount) {
                                    this.walker.carryFlagsImpl(c2);
                                    if ((c2.flags & 4) == 0) break block13;
                                    if (!this.pending.everbodyHasFlag(4)) break block14;
                                    RevCommit n = this.pending.peek();
                                    if (n == null || n.commitTime < this.last.commitTime) break;
                                    this.overScan = 6;
                                    break block15;
                                }
                                RevCommit p = c2.getParent(i2);
                                if (!(this.firstParent && i2 > 0 && (c2.flags & 4) == 0 || (p.flags & 2) != 0)) {
                                    if ((p.flags & 1) == 0) {
                                        p.parseHeaders(this.walker);
                                    }
                                    p.flags |= 2;
                                    this.pending.add(p);
                                }
                                ++i2;
                            }
                            if (--this.overScan == 0) {
                                throw StopWalkException.INSTANCE;
                            }
                            break block15;
                        }
                        this.overScan = 6;
                    }
                    if (!this.canDispose) continue;
                    c2.disposeBody();
                    continue;
                }
                if (produce) {
                    this.last = c2;
                    return this.last;
                }
                if (!this.canDispose) continue;
                c2.disposeBody();
            }
        }
        catch (StopWalkException swe) {
            this.pending.clear();
            return null;
        }
    }
}

