/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RevWalkException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraph;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.AsyncObjectLoaderQueue;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.AbstractRevQueue;
import org.eclipse.jgit.revwalk.AsyncRevObjectQueue;
import org.eclipse.jgit.revwalk.DateRevPriorityQueue;
import org.eclipse.jgit.revwalk.DateRevQueue;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevCommitCG;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.StartGenerator;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.References;

public class RevWalk
implements Iterable<RevCommit>,
AutoCloseable {
    private static final int MB = 0x100000;
    static final int PARSED = 1;
    static final int SEEN = 2;
    static final int UNINTERESTING = 4;
    static final int REWRITE = 8;
    static final int TEMP_MARK = 16;
    static final int TOPO_DELAY = 32;
    static final int TOPO_QUEUED = 64;
    static final int TREE_REV_FILTER_APPLIED = 128;
    static final int RESERVED_FLAGS = 8;
    private static final int APP_FLAGS = -256;
    final ObjectReader reader;
    private final boolean closeReader;
    final MutableObjectId idBuffer;
    ObjectIdOwnerMap<RevObject> objects;
    int freeFlags = -256;
    private int delayFreeFlags;
    private int retainOnReset;
    int carryFlags = 4;
    final ArrayList<RevCommit> roots;
    AbstractRevQueue queue;
    Generator pending;
    private final EnumSet<RevSort> sorting;
    private RevFilter filter;
    private TreeFilter treeFilter;
    private CommitGraph commitGraph;
    private boolean retainBody = true;
    private boolean rewriteParents = true;
    private boolean firstParent;
    boolean shallowCommitsInitialized;

    public RevWalk(Repository repo) {
        this(repo.newObjectReader(), true);
    }

    public RevWalk(ObjectReader or) {
        this(or, false);
    }

    RevWalk(ObjectReader or, boolean closeReader) {
        this.reader = or;
        this.idBuffer = new MutableObjectId();
        this.objects = new ObjectIdOwnerMap();
        this.roots = new ArrayList();
        this.queue = RevWalk.newDateRevQueue(false);
        this.pending = new StartGenerator(this);
        this.sorting = EnumSet.of(RevSort.NONE);
        this.filter = RevFilter.ALL;
        this.treeFilter = TreeFilter.ALL;
        this.closeReader = closeReader;
        this.commitGraph = null;
    }

    static AbstractRevQueue newDateRevQueue(boolean firstParent) {
        if (RevWalk.usePriorityQueue()) {
            return new DateRevPriorityQueue(firstParent);
        }
        return new DateRevQueue(firstParent);
    }

    static DateRevQueue newDateRevQueue(Generator g2) throws IOException {
        if (RevWalk.usePriorityQueue()) {
            return new DateRevPriorityQueue(g2);
        }
        return new DateRevQueue(g2);
    }

    private static boolean usePriorityQueue() {
        return Optional.ofNullable(System.getProperty("REVWALK_USE_PRIORITY_QUEUE")).map(Boolean::parseBoolean).orElse(false);
    }

    public ObjectReader getObjectReader() {
        return this.reader;
    }

    @Override
    public void close() {
        if (this.closeReader) {
            this.reader.close();
        }
    }

    public void markStart(RevCommit c2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if ((c2.flags & 2) != 0) {
            return;
        }
        if ((c2.flags & 1) == 0) {
            c2.parseHeaders(this);
        }
        c2.flags |= 2;
        this.roots.add(c2);
        this.queue.add(c2);
    }

    public void markStart(Collection<RevCommit> list) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        for (RevCommit c2 : list) {
            this.markStart(c2);
        }
    }

    public void markUninteresting(RevCommit c2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        c2.flags |= 4;
        this.carryFlagsImpl(c2);
        this.markStart(c2);
    }

    public boolean isMergedInto(RevCommit base, RevCommit tip) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevFilter oldRF = this.filter;
        TreeFilter oldTF = this.treeFilter;
        try {
            RevCommit mergeBase;
            this.finishDelayedFreeFlags();
            this.reset(~this.freeFlags & 0xFFFFFF00);
            this.filter = RevFilter.MERGE_BASE;
            this.treeFilter = TreeFilter.ALL;
            this.markStart(tip);
            this.markStart(base);
            while ((mergeBase = this.next()) != null) {
                if (!References.isSameObject(mergeBase, base)) continue;
                return true;
            }
            return false;
        }
        finally {
            this.filter = oldRF;
            this.treeFilter = oldTF;
        }
    }

    public List<Ref> getMergedInto(RevCommit commit, Collection<Ref> refs) throws IOException {
        return this.getMergedInto(commit, refs, NullProgressMonitor.INSTANCE);
    }

    public List<Ref> getMergedInto(RevCommit commit, Collection<Ref> refs, ProgressMonitor monitor) throws IOException {
        return this.getMergedInto(commit, refs, GetMergedIntoStrategy.EVALUATE_ALL, monitor);
    }

    public boolean isMergedIntoAny(RevCommit commit, Collection<Ref> refs) throws IOException {
        return this.getMergedInto(commit, refs, GetMergedIntoStrategy.RETURN_ON_FIRST_FOUND, NullProgressMonitor.INSTANCE).size() > 0;
    }

    public boolean isMergedIntoAnyCommit(RevCommit commit, Collection<RevCommit> revs) throws IOException {
        return this.getCommitsMergedInto(commit, revs, GetMergedIntoStrategy.RETURN_ON_FIRST_FOUND, NullProgressMonitor.INSTANCE).size() > 0;
    }

    public boolean isMergedIntoAll(RevCommit commit, Collection<Ref> refs) throws IOException {
        return this.getMergedInto(commit, refs, GetMergedIntoStrategy.RETURN_ON_FIRST_NOT_FOUND, NullProgressMonitor.INSTANCE).size() == refs.size();
    }

    private List<Ref> getMergedInto(RevCommit needle, Collection<Ref> haystacks, Enum returnStrategy, ProgressMonitor monitor) throws IOException {
        HashMap<RevCommit, List> refsByCommit = new HashMap<RevCommit, List>();
        for (Ref r : haystacks) {
            RevObject o = this.peel(this.parseAny(r.getObjectId()));
            if (!(o instanceof RevCommit)) continue;
            refsByCommit.computeIfAbsent((RevCommit)o, c2 -> new ArrayList()).add(r);
        }
        monitor.update(1);
        ArrayList<Ref> result2 = new ArrayList<Ref>();
        for (RevCommit c3 : this.getCommitsMergedInto(needle, refsByCommit.keySet(), returnStrategy, monitor)) {
            result2.addAll((Collection)refsByCommit.get(c3));
        }
        return result2;
    }

    /*
     * Exception decompiling
     */
    private Set<RevCommit> getCommitsMergedInto(RevCommit needle, Collection<RevCommit> haystacks, Enum returnStrategy, ProgressMonitor monitor) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 8[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.pending.next();
    }

    public EnumSet<RevSort> getRevSort() {
        return this.sorting.clone();
    }

    public boolean hasRevSort(RevSort sort2) {
        return this.sorting.contains((Object)sort2);
    }

    public void sort(RevSort s2) {
        this.assertNotStarted();
        this.sorting.clear();
        this.sorting.add(s2);
    }

    public void sort(RevSort s2, boolean use) {
        this.assertNotStarted();
        if (use) {
            this.sorting.add(s2);
        } else {
            this.sorting.remove((Object)s2);
        }
        if (this.sorting.size() > 1) {
            this.sorting.remove((Object)RevSort.NONE);
        } else if (this.sorting.isEmpty()) {
            this.sorting.add(RevSort.NONE);
        }
    }

    @NonNull
    public RevFilter getRevFilter() {
        return this.filter;
    }

    public void setRevFilter(RevFilter newFilter) {
        this.assertNotStarted();
        this.filter = newFilter != null ? newFilter : RevFilter.ALL;
    }

    @NonNull
    public TreeFilter getTreeFilter() {
        return this.treeFilter;
    }

    public void setTreeFilter(TreeFilter newFilter) {
        this.assertNotStarted();
        this.treeFilter = newFilter != null ? newFilter : TreeFilter.ALL;
    }

    public void setRewriteParents(boolean rewrite) {
        this.rewriteParents = rewrite;
    }

    boolean getRewriteParents() {
        return this.rewriteParents;
    }

    public boolean isRetainBody() {
        return this.retainBody;
    }

    public void setRetainBody(boolean retain) {
        this.retainBody = retain;
    }

    public boolean isFirstParent() {
        return this.firstParent;
    }

    public void setFirstParent(boolean enable) {
        this.assertNotStarted();
        this.assertNoCommitsMarkedStart();
        this.firstParent = enable;
        this.queue = RevWalk.newDateRevQueue(this.firstParent);
        this.pending = new StartGenerator(this);
    }

    @NonNull
    public RevBlob lookupBlob(AnyObjectId id) {
        RevBlob c2 = (RevBlob)this.objects.get(id);
        if (c2 == null) {
            c2 = new RevBlob(id);
            this.objects.add(c2);
        }
        return c2;
    }

    @NonNull
    public RevTree lookupTree(AnyObjectId id) {
        RevTree c2 = (RevTree)this.objects.get(id);
        if (c2 == null) {
            c2 = new RevTree(id);
            this.objects.add(c2);
        }
        return c2;
    }

    @NonNull
    public RevCommit lookupCommit(AnyObjectId id) {
        RevCommit c2 = (RevCommit)this.objects.get(id);
        if (c2 == null) {
            c2 = this.createCommit(id);
            this.objects.add(c2);
        }
        return c2;
    }

    @NonNull
    protected RevCommit lookupCommit(AnyObjectId id, int graphPos) {
        RevCommit c2 = (RevCommit)this.objects.get(id);
        if (c2 == null) {
            c2 = this.createCommit(id, graphPos);
            this.objects.add(c2);
        }
        return c2;
    }

    @NonNull
    public RevTag lookupTag(AnyObjectId id) {
        RevTag c2 = (RevTag)this.objects.get(id);
        if (c2 == null) {
            c2 = new RevTag(id);
            this.objects.add(c2);
        }
        return c2;
    }

    @NonNull
    public RevObject lookupAny(AnyObjectId id, int type2) {
        RevObject r = this.objects.get(id);
        if (r == null) {
            switch (type2) {
                case 1: {
                    r = this.createCommit(id);
                    break;
                }
                case 2: {
                    r = new RevTree(id);
                    break;
                }
                case 3: {
                    r = new RevBlob(id);
                    break;
                }
                case 4: {
                    r = new RevTag(id);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidGitType, type2));
                }
            }
            this.objects.add(r);
        }
        return r;
    }

    public RevObject lookupOrNull(AnyObjectId id) {
        return this.objects.get(id);
    }

    @NonNull
    public RevCommit parseCommit(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject c2 = this.peel(this.parseAny(id));
        if (!(c2 instanceof RevCommit)) {
            throw new IncorrectObjectTypeException(id.toObjectId(), "commit");
        }
        return (RevCommit)c2;
    }

    @NonNull
    public RevTree parseTree(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevTree t2;
        RevObject c2 = this.peel(this.parseAny(id));
        if (c2 instanceof RevCommit) {
            t2 = ((RevCommit)c2).getTree();
        } else {
            if (!(c2 instanceof RevTree)) {
                throw new IncorrectObjectTypeException(id.toObjectId(), "tree");
            }
            t2 = (RevTree)c2;
        }
        this.parseHeaders(t2);
        return t2;
    }

    @NonNull
    public RevTag parseTag(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject c2 = this.parseAny(id);
        if (!(c2 instanceof RevTag)) {
            throw new IncorrectObjectTypeException(id.toObjectId(), "tag");
        }
        return (RevTag)c2;
    }

    @NonNull
    public RevObject parseAny(AnyObjectId id) throws MissingObjectException, IOException {
        RevObject r = this.objects.get(id);
        if (r == null) {
            r = this.parseNew(id, this.reader.open(id));
        } else {
            this.parseHeaders(r);
        }
        return r;
    }

    private RevObject parseNew(AnyObjectId id, ObjectLoader ldr) throws LargeObjectException, CorruptObjectException, MissingObjectException, IOException {
        RevObject r;
        int type2 = ldr.getType();
        switch (type2) {
            case 1: {
                RevCommit c2 = this.createCommit(id);
                c2.parseCanonical(this, this.getCachedBytes(c2, ldr));
                r = c2;
                break;
            }
            case 2: {
                r = new RevTree(id);
                r.flags |= 1;
                break;
            }
            case 3: {
                r = new RevBlob(id);
                r.flags |= 1;
                break;
            }
            case 4: {
                RevTag t2 = new RevTag(id);
                t2.parseCanonical(this, this.getCachedBytes(t2, ldr));
                r = t2;
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().badObjectType, type2));
            }
        }
        this.objects.add(r);
        return r;
    }

    byte[] getCachedBytes(RevObject obj) throws LargeObjectException, MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.getCachedBytes(obj, this.reader.open(obj, obj.getType()));
    }

    byte[] getCachedBytes(RevObject obj, ObjectLoader ldr) throws LargeObjectException, MissingObjectException, IOException {
        try {
            return ldr.getCachedBytes(0x500000);
        }
        catch (LargeObjectException tooBig) {
            tooBig.setObjectId(obj);
            throw tooBig;
        }
    }

    @NonNull
    CommitGraph commitGraph() {
        if (this.commitGraph == null) {
            try {
                this.commitGraph = this.reader != null ? this.reader.getCommitGraph().orElse(CommitGraph.EMPTY) : CommitGraph.EMPTY;
            }
            catch (IOException e2) {
                this.commitGraph = CommitGraph.EMPTY;
            }
        }
        return this.commitGraph;
    }

    public <T extends ObjectId> AsyncRevObjectQueue parseAny(Iterable<T> objectIds, boolean reportMissing) {
        ArrayList<ObjectId> need = new ArrayList<ObjectId>();
        ArrayList<RevObject> have = new ArrayList<RevObject>();
        for (ObjectId id : objectIds) {
            RevObject r = this.objects.get(id);
            if (r != null && (r.flags & 1) != 0) {
                have.add(r);
                continue;
            }
            need.add(id);
        }
        final Iterator objItr = have.iterator();
        if (need.isEmpty()) {
            return new AsyncRevObjectQueue(){

                @Override
                public RevObject next() {
                    return objItr.hasNext() ? (RevObject)objItr.next() : null;
                }

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return true;
                }

                @Override
                public void release() {
                }
            };
        }
        final AsyncObjectLoaderQueue lItr = this.reader.open(need, reportMissing);
        return new AsyncRevObjectQueue(){

            @Override
            public RevObject next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
                if (objItr.hasNext()) {
                    return (RevObject)objItr.next();
                }
                if (!lItr.next()) {
                    return null;
                }
                ObjectId id = lItr.getObjectId();
                ObjectLoader ldr = lItr.open();
                RevObject r = RevWalk.this.objects.get(id);
                if (r == null) {
                    r = RevWalk.this.parseNew(id, ldr);
                } else if (r instanceof RevCommit) {
                    byte[] raw = ldr.getCachedBytes();
                    ((RevCommit)r).parseCanonical(RevWalk.this, raw);
                } else if (r instanceof RevTag) {
                    byte[] raw = ldr.getCachedBytes();
                    ((RevTag)r).parseCanonical(RevWalk.this, raw);
                } else {
                    r.flags |= 1;
                }
                return r;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return lItr.cancel(mayInterruptIfRunning);
            }

            @Override
            public void release() {
                lItr.release();
            }
        };
    }

    public void parseHeaders(RevObject obj) throws MissingObjectException, IOException {
        if ((obj.flags & 1) == 0) {
            obj.parseHeaders(this);
        }
    }

    public void parseBody(RevObject obj) throws MissingObjectException, IOException {
        obj.parseBody(this);
    }

    public RevObject peel(RevObject obj) throws MissingObjectException, IOException {
        while (obj instanceof RevTag) {
            this.parseHeaders(obj);
            obj = ((RevTag)obj).getObject();
        }
        this.parseHeaders(obj);
        return obj;
    }

    public RevFlag newFlag(String name) {
        int m4 = this.allocFlag();
        return new RevFlag(this, name, m4);
    }

    int allocFlag() {
        if (this.freeFlags == 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().flagsAlreadyCreated, 24));
        }
        int m4 = Integer.lowestOneBit(this.freeFlags);
        this.freeFlags &= ~m4;
        return m4;
    }

    public void carry(RevFlag flag) {
        if ((this.freeFlags & flag.mask) != 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().flagIsDisposed, flag.name));
        }
        if (flag.walker != this) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().flagNotFromThis, flag.name));
        }
        this.carryFlags |= flag.mask;
    }

    public void carry(Collection<RevFlag> set2) {
        for (RevFlag flag : set2) {
            this.carry(flag);
        }
    }

    public final void retainOnReset(RevFlag flag) {
        if ((this.freeFlags & flag.mask) != 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().flagIsDisposed, flag.name));
        }
        if (flag.walker != this) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().flagNotFromThis, flag.name));
        }
        this.retainOnReset |= flag.mask;
    }

    public final void retainOnReset(Collection<RevFlag> flags) {
        for (RevFlag f2 : flags) {
            this.retainOnReset(f2);
        }
    }

    public void disposeFlag(RevFlag flag) {
        this.freeFlag(flag.mask);
    }

    void freeFlag(int mask) {
        this.retainOnReset &= ~mask;
        if (this.isNotStarted()) {
            this.freeFlags |= mask;
            this.carryFlags &= ~mask;
        } else {
            this.delayFreeFlags |= mask;
        }
    }

    private void finishDelayedFreeFlags() {
        if (this.delayFreeFlags != 0) {
            this.freeFlags |= this.delayFreeFlags;
            this.carryFlags &= ~this.delayFreeFlags;
            this.delayFreeFlags = 0;
        }
    }

    public final void reset() {
        this.reset(0);
    }

    public final void resetRetain(RevFlagSet retainFlags) {
        this.reset(retainFlags.mask);
    }

    public final void resetRetain(RevFlag ... retainFlags) {
        int mask = 0;
        RevFlag[] revFlagArray = retainFlags;
        int n = retainFlags.length;
        int n2 = 0;
        while (n2 < n) {
            RevFlag flag = revFlagArray[n2];
            mask |= flag.mask;
            ++n2;
        }
        this.reset(mask);
    }

    protected void reset(int retainFlags) {
        RevCommit c22;
        this.finishDelayedFreeFlags();
        int clearFlags = ~(retainFlags |= 1 | this.retainOnReset);
        FIFORevQueue q = new FIFORevQueue();
        for (RevCommit c22 : this.roots) {
            if ((c22.flags & clearFlags) == 0) continue;
            c22.flags &= retainFlags;
            c22.reset();
            q.add(c22);
        }
        while ((c22 = q.next()) != null) {
            if (c22.getParents() == null) continue;
            RevCommit[] revCommitArray = c22.getParents();
            int n = revCommitArray.length;
            int n2 = 0;
            while (n2 < n) {
                RevCommit p = revCommitArray[n2];
                if ((p.flags & clearFlags) != 0) {
                    p.flags &= retainFlags;
                    p.reset();
                    q.add(p);
                }
                ++n2;
            }
        }
        this.roots.clear();
        this.queue = RevWalk.newDateRevQueue(this.firstParent);
        this.pending = new StartGenerator(this);
    }

    public void dispose() {
        this.reader.close();
        this.freeFlags = -256;
        this.delayFreeFlags = 0;
        this.retainOnReset = 0;
        this.carryFlags = 4;
        this.firstParent = false;
        this.objects.clear();
        this.roots.clear();
        this.queue = RevWalk.newDateRevQueue(this.firstParent);
        this.pending = new StartGenerator(this);
        this.shallowCommitsInitialized = false;
    }

    @Nullable
    private RevCommit nextForIterator() {
        try {
            return this.next();
        }
        catch (IOException e2) {
            throw new RevWalkException(e2);
        }
    }

    @Override
    public Iterator<RevCommit> iterator() {
        RevCommit first2 = this.nextForIterator();
        return new Iterator<RevCommit>(first2){
            RevCommit next;
            {
                this.next = revCommit;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public RevCommit next() {
                RevCommit r = this.next;
                this.next = RevWalk.this.nextForIterator();
                return r;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected void assertNotStarted() {
        if (this.isNotStarted()) {
            return;
        }
        throw new IllegalStateException(JGitText.get().outputHasAlreadyBeenStarted);
    }

    protected void assertNoCommitsMarkedStart() {
        if (this.roots.isEmpty()) {
            return;
        }
        throw new IllegalStateException(JGitText.get().commitsHaveAlreadyBeenMarkedAsStart);
    }

    private boolean isNotStarted() {
        return this.pending instanceof StartGenerator;
    }

    public ObjectWalk toObjectWalkWithSameObjects() {
        ObjectWalk ow;
        ObjectWalk rw = ow = new ObjectWalk(this.reader);
        rw.objects = this.objects;
        rw.freeFlags = this.freeFlags;
        return ow;
    }

    protected RevCommit createCommit(AnyObjectId id) {
        return this.createCommit(id, this.commitGraph().findGraphPosition(id));
    }

    private RevCommit createCommit(AnyObjectId id, int graphPos) {
        if (graphPos >= 0) {
            return new RevCommitCG(id, graphPos);
        }
        return new RevCommit(id);
    }

    void carryFlagsImpl(RevCommit c2) {
        int carry = c2.flags & this.carryFlags;
        if (carry != 0) {
            RevCommit.carryFlags(c2, carry);
        }
    }

    public void assumeShallow(Collection<? extends ObjectId> ids) {
        for (ObjectId objectId : ids) {
            this.lookupCommit((AnyObjectId)objectId).parents = RevCommit.NO_PARENTS;
        }
    }

    void initializeShallowCommits(RevCommit rc2) throws IOException {
        if (this.shallowCommitsInitialized) {
            throw new IllegalStateException(JGitText.get().shallowCommitsAlreadyInitialized);
        }
        this.shallowCommitsInitialized = true;
        if (this.reader == null) {
            return;
        }
        for (ObjectId id : this.reader.getShallowCommits()) {
            if (id.equals(rc2.getId())) {
                rc2.parents = RevCommit.NO_PARENTS;
                continue;
            }
            this.lookupCommit((AnyObjectId)id).parents = RevCommit.NO_PARENTS;
        }
    }

    private static enum GetMergedIntoStrategy {
        RETURN_ON_FIRST_FOUND,
        RETURN_ON_FIRST_NOT_FOUND,
        EVALUATE_ALL;

    }
}

