/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;

public final class RevWalkUtils {
    private RevWalkUtils() {
    }

    public static int count(RevWalk walk, RevCommit start2, RevCommit end2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return RevWalkUtils.find(walk, start2, end2).size();
    }

    public static List<RevCommit> find(RevWalk walk, RevCommit start2, RevCommit end2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        walk.reset();
        walk.markStart(start2);
        if (end2 != null) {
            walk.markUninteresting(end2);
        }
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        for (RevCommit c2 : walk) {
            commits.add(c2);
        }
        return commits;
    }

    public static List<Ref> findBranchesReachableFrom(RevCommit commit, RevWalk revWalk, Collection<Ref> refs) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return RevWalkUtils.findBranchesReachableFrom(commit, revWalk, refs, NullProgressMonitor.INSTANCE);
    }

    public static List<Ref> findBranchesReachableFrom(RevCommit commit, RevWalk revWalk, Collection<Ref> refs, ProgressMonitor monitor) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        commit = revWalk.parseCommit(commit.getId());
        revWalk.reset();
        ArrayList<Ref> filteredRefs = new ArrayList<Ref>();
        monitor.beginTask(JGitText.get().searchForReachableBranches, refs.size());
        int SKEW = 86400;
        for (Ref ref : refs) {
            RevCommit headCommit;
            RevObject maybehead = revWalk.parseAny(ref.getObjectId());
            if (!(maybehead instanceof RevCommit) || (headCommit = (RevCommit)maybehead).getCommitTime() + 86400 < commit.getCommitTime()) continue;
            filteredRefs.add(ref);
        }
        List<Ref> result2 = revWalk.getMergedInto(commit, filteredRefs, monitor);
        monitor.endTask();
        return result2;
    }
}

