/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

class RewriteGenerator
extends Generator {
    private static final int REWRITE = 8;
    private static final int DUPLICATE = 16;
    private final Generator source;
    private final FIFORevQueue pending;

    RewriteGenerator(Generator s2) {
        super(s2.firstParent);
        this.source = s2;
        this.pending = new FIFORevQueue(s2.firstParent);
    }

    @Override
    void shareFreeList(BlockRevQueue q) {
        this.source.shareFreeList(q);
    }

    @Override
    int outputType() {
        return this.source.outputType() & 0xFFFFFFFB;
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c2 = this.pending.next();
        if (c2 == null && (c2 = this.source.next()) == null) {
            return null;
        }
        this.applyFilterToParents(c2);
        boolean rewrote = false;
        RevCommit[] pList = c2.getParents();
        int nParents = pList.length;
        int i2 = 0;
        while (i2 < nParents) {
            RevCommit oldp = pList[i2];
            RevCommit newp = this.rewrite(oldp);
            if (this.firstParent) {
                c2.parents = newp == null ? RevCommit.NO_PARENTS : new RevCommit[]{newp};
                return c2;
            }
            if (oldp != newp) {
                pList[i2] = newp;
                rewrote = true;
            }
            ++i2;
        }
        if (rewrote) {
            c2.parents = this.cleanup(pList);
        }
        return c2;
    }

    private void applyFilterToParents(RevCommit c2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit[] revCommitArray = c2.getParents();
        int n = revCommitArray.length;
        int n2 = 0;
        while (n2 < n) {
            RevCommit parent = revCommitArray[n2];
            while ((parent.flags & 0x80) == 0) {
                RevCommit n3 = this.source.next();
                if (n3 != null) {
                    this.pending.add(n3);
                    continue;
                }
                return;
            }
            ++n2;
        }
    }

    private RevCommit rewrite(RevCommit p) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        while (p.getParentCount() <= 1) {
            if ((p.flags & 4) != 0) {
                return p;
            }
            if ((p.flags & 8) == 0) {
                return p;
            }
            if (p.getParentCount() == 0) {
                return null;
            }
            this.applyFilterToParents(p.getParent(0));
            p = p.getParent(0);
        }
        return p;
    }

    private RevCommit[] cleanup(RevCommit[] oldList) {
        RevCommit p2;
        int newCnt = 0;
        int o = 0;
        while (o < oldList.length) {
            p2 = oldList[o];
            if (p2 != null) {
                if ((p2.flags & 0x10) != 0) {
                    oldList[o] = null;
                } else {
                    p2.flags |= 0x10;
                    ++newCnt;
                }
            }
            ++o;
        }
        if (newCnt == oldList.length) {
            RevCommit[] revCommitArray = oldList;
            int n = oldList.length;
            int p2 = 0;
            while (p2 < n) {
                RevCommit p3 = revCommitArray[p2];
                p3.flags &= 0xFFFFFFEF;
                ++p2;
            }
            return oldList;
        }
        RevCommit[] newList = new RevCommit[newCnt];
        newCnt = 0;
        RevCommit[] revCommitArray = oldList;
        int n = oldList.length;
        int n2 = 0;
        while (n2 < n) {
            p2 = revCommitArray[n2];
            if (p2 != null) {
                newList[newCnt++] = p2;
                p2.flags &= 0xFFFFFFEF;
            }
            ++n2;
        }
        return newList;
    }
}

