/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

class TopoNonIntermixSortGenerator
extends Generator {
    private static final int TOPO_QUEUED = 64;
    private final FIFORevQueue pending;
    private final int outputType;

    TopoNonIntermixSortGenerator(Generator s2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        super(s2.firstParent);
        RevCommit c2;
        this.pending = new FIFORevQueue(this.firstParent);
        this.outputType = s2.outputType() | 8;
        s2.shareFreeList(this.pending);
        while ((c2 = s2.next()) != null) {
            if ((c2.flags & 0x40) == 0) {
                RevCommit[] revCommitArray = c2.getParents();
                int n = revCommitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RevCommit p = revCommitArray[n2];
                    ++p.inDegree;
                    if (this.firstParent) break;
                    ++n2;
                }
            }
            c2.flags |= 0x40;
            this.pending.add(c2);
        }
    }

    @Override
    int outputType() {
        return this.outputType;
    }

    @Override
    void shareFreeList(BlockRevQueue q) {
        q.shareFreeList(this.pending);
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c2;
        do {
            if ((c2 = this.pending.next()) != null) continue;
            return null;
        } while (c2.inDegree > 0 || (c2.flags & 0x40) == 0);
        RevCommit[] revCommitArray = c2.getParents();
        int n = revCommitArray.length;
        int n2 = 0;
        while (n2 < n) {
            RevCommit p = revCommitArray[n2];
            if (--p.inDegree == 0 && (p.flags & 0x40) != 0) {
                this.pending.unpop(p);
            }
            if (this.firstParent) break;
            ++n2;
        }
        c2.flags &= 0xFFFFFFBF;
        return c2;
    }
}

