/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.filter.PatternMatchRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.revwalk.filter.SubStringRevFilter;
import org.eclipse.jgit.util.RawCharSequence;
import org.eclipse.jgit.util.RawParseUtils;

public class CommitterRevFilter {
    public static RevFilter create(String pattern2) {
        if (pattern2.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        if (SubStringRevFilter.safe(pattern2)) {
            return new SubStringSearch(pattern2);
        }
        return new PatternSearch(pattern2);
    }

    private CommitterRevFilter() {
    }

    static RawCharSequence textFor(RevCommit cmit) {
        byte[] raw = cmit.getRawBuffer();
        int b2 = RawParseUtils.committer(raw, 0);
        if (b2 < 0) {
            return RawCharSequence.EMPTY;
        }
        int e2 = RawParseUtils.nextLF(raw, b2, '>');
        return new RawCharSequence(raw, b2, e2);
    }

    private static class PatternSearch
    extends PatternMatchRevFilter {
        PatternSearch(String patternText) {
            super(patternText, true, true, 2);
        }

        @Override
        protected CharSequence text(RevCommit cmit) {
            return CommitterRevFilter.textFor(cmit);
        }

        @Override
        public RevFilter clone() {
            return new PatternSearch(this.pattern());
        }
    }

    private static class SubStringSearch
    extends SubStringRevFilter {
        SubStringSearch(String patternText) {
            super(patternText);
        }

        @Override
        protected RawCharSequence text(RevCommit cmit) {
            return CommitterRevFilter.textFor(cmit);
        }
    }
}

