/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public abstract class PatternMatchRevFilter
extends RevFilter {
    private final String patternText;
    private final Matcher compiledPattern;

    protected static final String forceToRaw(String patternText) {
        byte[] b2 = Constants.encode(patternText);
        StringBuilder needle = new StringBuilder(b2.length);
        byte[] byArray = b2;
        int n = b2.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            needle.append((char)(element & 0xFF));
            ++n2;
        }
        return needle.toString();
    }

    protected PatternMatchRevFilter(String pattern2, boolean innerString, boolean rawEncoding, int flags) {
        if (((String)pattern2).length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        this.patternText = pattern2;
        if (innerString) {
            if (!((String)pattern2).startsWith("^") && !((String)pattern2).startsWith(".*")) {
                pattern2 = ".*" + (String)pattern2;
            }
            if (!((String)pattern2).endsWith("$") && !((String)pattern2).endsWith(".*")) {
                pattern2 = (String)pattern2 + ".*";
            }
        }
        String p = rawEncoding ? PatternMatchRevFilter.forceToRaw((String)pattern2) : pattern2;
        this.compiledPattern = Pattern.compile(p, flags).matcher("");
    }

    public String pattern() {
        return this.patternText;
    }

    @Override
    public boolean include(RevWalk walker, RevCommit cmit) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.compiledPattern.reset(this.text(cmit)).matches();
    }

    @Override
    public boolean requiresCommitBody() {
        return true;
    }

    protected abstract CharSequence text(RevCommit var1);

    @Override
    public String toString() {
        return super.toString() + "(\"" + this.patternText + "\")";
    }
}

