/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.pack;

import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;

public class PackConfig {
    public static final boolean DEFAULT_REUSE_DELTAS = true;
    public static final boolean DEFAULT_REUSE_OBJECTS = true;
    public static final boolean DEFAULT_PRESERVE_OLD_PACKS = false;
    public static final boolean DEFAULT_PRUNE_PRESERVED = false;
    public static final boolean DEFAULT_DELTA_COMPRESS = true;
    public static final boolean DEFAULT_DELTA_BASE_AS_OFFSET = false;
    public static final int DEFAULT_MAX_DELTA_DEPTH = 50;
    public static final int DEFAULT_DELTA_SEARCH_WINDOW_SIZE = 10;
    private static final int MB = 0x100000;
    public static final int DEFAULT_BIG_FILE_THRESHOLD = 0x3200000;
    public static final boolean DEFAULT_WAIT_PREVENT_RACY_PACK = false;
    public static final long DEFAULT_MINSIZE_PREVENT_RACY_PACK = 0x6400000L;
    public static final long DEFAULT_DELTA_CACHE_SIZE = 0x3200000L;
    public static final int DEFAULT_DELTA_CACHE_LIMIT = 100;
    public static final int DEFAULT_INDEX_VERSION = 2;
    public static final boolean DEFAULT_WRITE_REVERSE_INDEX = false;
    public static final boolean DEFAULT_BUILD_BITMAPS = true;
    public static final boolean DEFAULT_PACK_KEPT_OBJECTS = false;
    public static final int DEFAULT_BITMAP_CONTIGUOUS_COMMIT_COUNT = 100;
    public static final int DEFAULT_BITMAP_RECENT_COMMIT_COUNT = 20000;
    public static final int DEFAULT_BITMAP_RECENT_COMMIT_SPAN = 100;
    public static final int DEFAULT_BITMAP_DISTANT_COMMIT_SPAN = 5000;
    public static final int DEFAULT_BITMAP_EXCESSIVE_BRANCH_COUNT = 100;
    public static final int DEFAULT_BITMAP_EXCESSIVE_BRANCH_TIP_COUNT = Integer.MAX_VALUE;
    public static final int DEFAULT_BITMAP_INACTIVE_BRANCH_AGE_IN_DAYS = 90;
    public static final String[] DEFAULT_BITMAP_EXCLUDED_REFS_PREFIXES = new String[0];
    public static final int DEFAULT_MIN_BYTES_FOR_OBJ_SIZE_INDEX = -1;
    public static final Duration DEFAULT_SEARCH_FOR_REUSE_TIMEOUT = Duration.ofSeconds(Integer.MAX_VALUE);
    private int compressionLevel = -1;
    private boolean reuseDeltas = true;
    private boolean reuseObjects = true;
    private boolean preserveOldPacks = false;
    private boolean prunePreserved = false;
    private boolean deltaBaseAsOffset = false;
    private boolean deltaCompress = true;
    private int maxDeltaDepth = 50;
    private int deltaSearchWindowSize = 10;
    private long deltaSearchMemoryLimit;
    private long deltaCacheSize = 0x3200000L;
    private int deltaCacheLimit = 100;
    private int bigFileThreshold = 0x3200000;
    private boolean waitPreventRacyPack = false;
    private long minSizePreventRacyPack = 0x6400000L;
    private int threads;
    private Executor executor;
    private int indexVersion = 2;
    private boolean writeReverseIndex = false;
    private boolean buildBitmaps = true;
    private boolean packKeptObjects = false;
    private int bitmapContiguousCommitCount = 100;
    private int bitmapRecentCommitCount = 20000;
    private int bitmapRecentCommitSpan = 100;
    private int bitmapDistantCommitSpan = 5000;
    private int bitmapExcessiveBranchCount = 100;
    private int bitmapExcessiveBranchTipCount = Integer.MAX_VALUE;
    private int bitmapInactiveBranchAgeInDays = 90;
    private String[] bitmapExcludedRefsPrefixes = DEFAULT_BITMAP_EXCLUDED_REFS_PREFIXES;
    private Duration searchForReuseTimeout = DEFAULT_SEARCH_FOR_REUSE_TIMEOUT;
    private boolean cutDeltaChains;
    private boolean singlePack;
    private int minBytesForObjSizeIndex = -1;

    public PackConfig() {
    }

    public PackConfig(Repository db) {
        this.fromConfig(db.getConfig());
    }

    public PackConfig(Config cfg) {
        this.fromConfig(cfg);
    }

    public PackConfig(PackConfig cfg) {
        this.compressionLevel = cfg.compressionLevel;
        this.reuseDeltas = cfg.reuseDeltas;
        this.reuseObjects = cfg.reuseObjects;
        this.preserveOldPacks = cfg.preserveOldPacks;
        this.prunePreserved = cfg.prunePreserved;
        this.deltaBaseAsOffset = cfg.deltaBaseAsOffset;
        this.deltaCompress = cfg.deltaCompress;
        this.maxDeltaDepth = cfg.maxDeltaDepth;
        this.deltaSearchWindowSize = cfg.deltaSearchWindowSize;
        this.deltaSearchMemoryLimit = cfg.deltaSearchMemoryLimit;
        this.deltaCacheSize = cfg.deltaCacheSize;
        this.deltaCacheLimit = cfg.deltaCacheLimit;
        this.bigFileThreshold = cfg.bigFileThreshold;
        this.waitPreventRacyPack = cfg.waitPreventRacyPack;
        this.minSizePreventRacyPack = cfg.minSizePreventRacyPack;
        this.threads = cfg.threads;
        this.executor = cfg.executor;
        this.indexVersion = cfg.indexVersion;
        this.writeReverseIndex = cfg.writeReverseIndex;
        this.buildBitmaps = cfg.buildBitmaps;
        this.packKeptObjects = cfg.packKeptObjects;
        this.bitmapContiguousCommitCount = cfg.bitmapContiguousCommitCount;
        this.bitmapRecentCommitCount = cfg.bitmapRecentCommitCount;
        this.bitmapRecentCommitSpan = cfg.bitmapRecentCommitSpan;
        this.bitmapDistantCommitSpan = cfg.bitmapDistantCommitSpan;
        this.bitmapExcessiveBranchCount = cfg.bitmapExcessiveBranchCount;
        this.bitmapInactiveBranchAgeInDays = cfg.bitmapInactiveBranchAgeInDays;
        this.cutDeltaChains = cfg.cutDeltaChains;
        this.singlePack = cfg.singlePack;
        this.searchForReuseTimeout = cfg.searchForReuseTimeout;
        this.minBytesForObjSizeIndex = cfg.minBytesForObjSizeIndex;
    }

    public boolean isReuseDeltas() {
        return this.reuseDeltas;
    }

    public void setReuseDeltas(boolean reuseDeltas) {
        this.reuseDeltas = reuseDeltas;
    }

    public boolean isReuseObjects() {
        return this.reuseObjects;
    }

    public void setReuseObjects(boolean reuseObjects) {
        this.reuseObjects = reuseObjects;
    }

    public boolean isPreserveOldPacks() {
        return this.preserveOldPacks;
    }

    public void setPreserveOldPacks(boolean preserveOldPacks) {
        this.preserveOldPacks = preserveOldPacks;
    }

    public boolean isPrunePreserved() {
        return this.prunePreserved;
    }

    public void setPrunePreserved(boolean prunePreserved) {
        this.prunePreserved = prunePreserved;
    }

    public boolean isDeltaBaseAsOffset() {
        return this.deltaBaseAsOffset;
    }

    public void setDeltaBaseAsOffset(boolean deltaBaseAsOffset) {
        this.deltaBaseAsOffset = deltaBaseAsOffset;
    }

    public boolean isDeltaCompress() {
        return this.deltaCompress;
    }

    public void setDeltaCompress(boolean deltaCompress) {
        this.deltaCompress = deltaCompress;
    }

    public int getMaxDeltaDepth() {
        return this.maxDeltaDepth;
    }

    public void setMaxDeltaDepth(int maxDeltaDepth) {
        this.maxDeltaDepth = maxDeltaDepth;
    }

    public boolean getCutDeltaChains() {
        return this.cutDeltaChains;
    }

    public void setCutDeltaChains(boolean cut) {
        this.cutDeltaChains = cut;
    }

    public boolean getSinglePack() {
        return this.singlePack;
    }

    public void setSinglePack(boolean single2) {
        this.singlePack = single2;
    }

    public int getDeltaSearchWindowSize() {
        return this.deltaSearchWindowSize;
    }

    public void setDeltaSearchWindowSize(int objectCount) {
        if (objectCount <= 2) {
            this.setDeltaCompress(false);
        } else {
            this.deltaSearchWindowSize = objectCount;
        }
    }

    public long getDeltaSearchMemoryLimit() {
        return this.deltaSearchMemoryLimit;
    }

    public void setDeltaSearchMemoryLimit(long memoryLimit) {
        this.deltaSearchMemoryLimit = memoryLimit;
    }

    public long getDeltaCacheSize() {
        return this.deltaCacheSize;
    }

    public void setDeltaCacheSize(long size2) {
        this.deltaCacheSize = size2;
    }

    public int getDeltaCacheLimit() {
        return this.deltaCacheLimit;
    }

    public void setDeltaCacheLimit(int size2) {
        this.deltaCacheLimit = size2;
    }

    public int getBigFileThreshold() {
        return this.bigFileThreshold;
    }

    public void setBigFileThreshold(int bigFileThreshold) {
        this.bigFileThreshold = bigFileThreshold;
    }

    public boolean isWaitPreventRacyPack() {
        return this.waitPreventRacyPack;
    }

    public boolean doWaitPreventRacyPack(long packSize) {
        return this.isWaitPreventRacyPack() && packSize > this.getMinSizePreventRacyPack();
    }

    public void setWaitPreventRacyPack(boolean waitPreventRacyPack) {
        this.waitPreventRacyPack = waitPreventRacyPack;
    }

    public long getMinSizePreventRacyPack() {
        return this.minSizePreventRacyPack;
    }

    public void setMinSizePreventRacyPack(long minSizePreventRacyPack) {
        this.minSizePreventRacyPack = minSizePreventRacyPack;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int level) {
        this.compressionLevel = level;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public int getIndexVersion() {
        return this.indexVersion;
    }

    public void setIndexVersion(int version2) {
        this.indexVersion = version2;
    }

    public boolean isWriteReverseIndex() {
        return this.writeReverseIndex;
    }

    public void setWriteReverseIndex(boolean writeReverseIndex) {
        this.writeReverseIndex = writeReverseIndex;
    }

    public boolean isBuildBitmaps() {
        return this.buildBitmaps;
    }

    public void setBuildBitmaps(boolean buildBitmaps) {
        this.buildBitmaps = buildBitmaps;
    }

    public void setPackKeptObjects(boolean packKeptObjects) {
        this.packKeptObjects = packKeptObjects;
    }

    public boolean isPackKeptObjects() {
        return this.packKeptObjects;
    }

    public int getBitmapContiguousCommitCount() {
        return this.bitmapContiguousCommitCount;
    }

    public void setBitmapContiguousCommitCount(int count2) {
        this.bitmapContiguousCommitCount = count2;
    }

    public int getBitmapRecentCommitCount() {
        return this.bitmapRecentCommitCount;
    }

    public void setBitmapRecentCommitCount(int count2) {
        this.bitmapRecentCommitCount = count2;
    }

    public int getBitmapRecentCommitSpan() {
        return this.bitmapRecentCommitSpan;
    }

    public void setBitmapRecentCommitSpan(int span) {
        this.bitmapRecentCommitSpan = span;
    }

    public int getBitmapDistantCommitSpan() {
        return this.bitmapDistantCommitSpan;
    }

    public void setBitmapDistantCommitSpan(int span) {
        this.bitmapDistantCommitSpan = span;
    }

    public int getBitmapExcessiveBranchCount() {
        return this.bitmapExcessiveBranchCount;
    }

    public void setBitmapExcessiveBranchCount(int count2) {
        this.bitmapExcessiveBranchCount = count2;
    }

    public int getBitmapExcessiveBranchTipCount() {
        return this.bitmapExcessiveBranchTipCount;
    }

    public void setBitmapExcessiveBranchTipCount(int count2) {
        this.bitmapExcessiveBranchTipCount = count2;
    }

    public int getBitmapInactiveBranchAgeInDays() {
        return this.bitmapInactiveBranchAgeInDays;
    }

    public Duration getSearchForReuseTimeout() {
        return this.searchForReuseTimeout;
    }

    public void setBitmapInactiveBranchAgeInDays(int ageInDays) {
        this.bitmapInactiveBranchAgeInDays = ageInDays;
    }

    public String[] getBitmapExcludedRefsPrefixes() {
        return this.bitmapExcludedRefsPrefixes;
    }

    public void setBitmapExcludedRefsPrefixes(String[] excludedRefsPrefixes) {
        this.bitmapExcludedRefsPrefixes = excludedRefsPrefixes;
    }

    public void setSearchForReuseTimeout(Duration timeout2) {
        this.searchForReuseTimeout = timeout2;
    }

    public int getMinBytesForObjSizeIndex() {
        return this.minBytesForObjSizeIndex;
    }

    public void setMinBytesForObjSizeIndex(int minBytesForObjSizeIndex) {
        this.minBytesForObjSizeIndex = minBytesForObjSizeIndex;
    }

    public boolean isWriteObjSizeIndex() {
        return this.minBytesForObjSizeIndex >= 0;
    }

    public void fromConfig(Config rc2) {
        this.setMaxDeltaDepth(rc2.getInt("pack", "depth", this.getMaxDeltaDepth()));
        this.setDeltaSearchWindowSize(rc2.getInt("pack", "window", this.getDeltaSearchWindowSize()));
        this.setDeltaSearchMemoryLimit(rc2.getLong("pack", "windowmemory", this.getDeltaSearchMemoryLimit()));
        this.setDeltaCacheSize(rc2.getLong("pack", "deltacachesize", this.getDeltaCacheSize()));
        this.setDeltaCacheLimit(rc2.getInt("pack", "deltacachelimit", this.getDeltaCacheLimit()));
        this.setCompressionLevel(rc2.getInt("pack", "compression", rc2.getInt("core", "compression", this.getCompressionLevel())));
        this.setIndexVersion(rc2.getInt("pack", "indexversion", this.getIndexVersion()));
        this.setBigFileThreshold(rc2.getInt("core", "bigfilethreshold", this.getBigFileThreshold()));
        this.setThreads(rc2.getInt("pack", "threads", this.getThreads()));
        this.setReuseDeltas(rc2.getBoolean("pack", "reusedeltas", this.isReuseDeltas()));
        this.setReuseObjects(rc2.getBoolean("pack", "reuseobjects", this.isReuseObjects()));
        this.setDeltaCompress(rc2.getBoolean("pack", "deltacompression", this.isDeltaCompress()));
        this.setCutDeltaChains(rc2.getBoolean("pack", "cutdeltachains", this.getCutDeltaChains()));
        this.setSinglePack(rc2.getBoolean("pack", "singlepack", this.getSinglePack()));
        this.setWriteReverseIndex(rc2.getBoolean("pack", "writeReverseIndex", this.isWriteReverseIndex()));
        boolean buildBitmapsFromConfig = rc2.getBoolean("pack", "buildbitmaps", this.isBuildBitmaps());
        this.setBuildBitmaps(buildBitmapsFromConfig);
        this.setPackKeptObjects(rc2.getBoolean("repack", "packkeptobjects", buildBitmapsFromConfig || this.isPackKeptObjects()));
        this.setBitmapContiguousCommitCount(rc2.getInt("pack", "bitmapcontiguouscommitcount", this.getBitmapContiguousCommitCount()));
        this.setBitmapRecentCommitCount(rc2.getInt("pack", "bitmaprecentcommitspan", this.getBitmapRecentCommitCount()));
        this.setBitmapRecentCommitSpan(rc2.getInt("pack", "bitmaprecentcommitspan", this.getBitmapRecentCommitSpan()));
        this.setBitmapDistantCommitSpan(rc2.getInt("pack", "bitmapdistantcommitspan", this.getBitmapDistantCommitSpan()));
        this.setBitmapExcessiveBranchCount(rc2.getInt("pack", "bitmapexcessivebranchcount", this.getBitmapExcessiveBranchCount()));
        this.setBitmapExcessiveBranchTipCount(rc2.getInt("pack", "bitmapexcessivebranchtipcount", this.getBitmapExcessiveBranchTipCount()));
        this.setBitmapInactiveBranchAgeInDays(rc2.getInt("pack", "bitmapinactivebranchageindays", this.getBitmapInactiveBranchAgeInDays()));
        String[] excludedRefsPrefixesArray = rc2.getStringList("pack", null, "bitmapexcludedrefsprefixes");
        if (excludedRefsPrefixesArray.length > 0) {
            this.setBitmapExcludedRefsPrefixes(excludedRefsPrefixesArray);
        }
        this.setSearchForReuseTimeout(Duration.ofSeconds(rc2.getTimeUnit("pack", null, "searchforreusetimeout", this.getSearchForReuseTimeout().getSeconds(), TimeUnit.SECONDS)));
        this.setWaitPreventRacyPack(rc2.getBoolean("pack", "waitpreventracypack", this.isWaitPreventRacyPack()));
        this.setMinSizePreventRacyPack(rc2.getLong("pack", "minsizepreventracypack", this.getMinSizePreventRacyPack()));
        this.setMinBytesForObjSizeIndex(rc2.getInt("pack", "minBytesForObjSizeIndex", -1));
        this.setPreserveOldPacks(rc2.getBoolean("pack", "preserveoldpacks", false));
        this.setPrunePreserved(rc2.getBoolean("pack", "prunepreserved", false));
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder();
        b2.append("maxDeltaDepth=").append(this.getMaxDeltaDepth());
        b2.append(", deltaSearchWindowSize=").append(this.getDeltaSearchWindowSize());
        b2.append(", deltaSearchMemoryLimit=").append(this.getDeltaSearchMemoryLimit());
        b2.append(", deltaCacheSize=").append(this.getDeltaCacheSize());
        b2.append(", deltaCacheLimit=").append(this.getDeltaCacheLimit());
        b2.append(", compressionLevel=").append(this.getCompressionLevel());
        b2.append(", indexVersion=").append(this.getIndexVersion());
        b2.append(", bigFileThreshold=").append(this.getBigFileThreshold());
        b2.append(", threads=").append(this.getThreads());
        b2.append(", reuseDeltas=").append(this.isReuseDeltas());
        b2.append(", reuseObjects=").append(this.isReuseObjects());
        b2.append(", deltaCompress=").append(this.isDeltaCompress());
        b2.append(", writeReverseIndex=").append(this.isWriteReverseIndex());
        b2.append(", buildBitmaps=").append(this.isBuildBitmaps());
        b2.append(", bitmapContiguousCommitCount=").append(this.getBitmapContiguousCommitCount());
        b2.append(", bitmapRecentCommitCount=").append(this.getBitmapRecentCommitCount());
        b2.append(", bitmapRecentCommitSpan=").append(this.getBitmapRecentCommitSpan());
        b2.append(", bitmapDistantCommitSpan=").append(this.getBitmapDistantCommitSpan());
        b2.append(", bitmapExcessiveBranchCount=").append(this.getBitmapExcessiveBranchCount());
        b2.append(", bitmapInactiveBranchAge=").append(this.getBitmapInactiveBranchAgeInDays());
        b2.append(", searchForReuseTimeout").append(this.getSearchForReuseTimeout());
        b2.append(", singlePack=").append(this.getSinglePack());
        b2.append(", minBytesForObjSizeIndex=").append(this.getMinBytesForObjSizeIndex());
        return b2.toString();
    }
}

