/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.transport.AdvertiseRefsHook;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;

public class AdvertiseRefsHookChain
implements AdvertiseRefsHook {
    private final AdvertiseRefsHook[] hooks;
    private final int count;

    public static AdvertiseRefsHook newChain(List<? extends AdvertiseRefsHook> hooks) {
        AdvertiseRefsHook[] newHooks = new AdvertiseRefsHook[hooks.size()];
        int i2 = 0;
        for (AdvertiseRefsHook advertiseRefsHook : hooks) {
            if (advertiseRefsHook == AdvertiseRefsHook.DEFAULT) continue;
            newHooks[i2++] = advertiseRefsHook;
        }
        switch (i2) {
            case 0: {
                return AdvertiseRefsHook.DEFAULT;
            }
            case 1: {
                return newHooks[0];
            }
        }
        return new AdvertiseRefsHookChain(newHooks, i2);
    }

    @Override
    public void advertiseRefs(ReceivePack rp) throws IOException {
        int i2 = 0;
        while (i2 < this.count) {
            this.hooks[i2].advertiseRefs(rp);
            ++i2;
        }
    }

    @Override
    public void advertiseRefs(UploadPack rp) throws ServiceMayNotContinueException {
        int i2 = 0;
        while (i2 < this.count) {
            this.hooks[i2].advertiseRefs(rp);
            ++i2;
        }
    }

    private AdvertiseRefsHookChain(AdvertiseRefsHook[] hooks, int count2) {
        this.hooks = hooks;
        this.count = count2;
    }
}

