/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.transport.AwsRequestSignerV4;
import org.eclipse.jgit.transport.WalkEncryption;
import org.eclipse.jgit.util.Base64;
import org.eclipse.jgit.util.HttpSupport;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class AmazonS3 {
    private static final Set<String> SIGNED_HEADERS = new HashSet<String>();
    private static final String AWS_API_V2 = "2";
    private static final String AWS_API_V4 = "4";
    private static final String AWS_S3_SERVICE_NAME = "s3";
    private static final String HMAC = "HmacSHA1";
    private static final String X_AMZ_ACL = "x-amz-acl";
    private static final String X_AMZ_META = "x-amz-meta-";
    private final String awsApiSignatureVersion;
    private final String publicKey;
    private final SecretKeySpec secretKeySpec;
    private final char[] secretKey;
    private final ProxySelector proxySelector;
    private final String acl;
    final int maxAttempts;
    private final WalkEncryption encryption;
    private final File tmpDir;
    private final String domain;
    private final String protocol;
    private final String region;

    static {
        SIGNED_HEADERS.add("content-type");
        SIGNED_HEADERS.add("content-md5");
        SIGNED_HEADERS.add("date");
    }

    private static boolean isSignedHeader(String name) {
        String nameLC = StringUtils.toLowerCase(name);
        return SIGNED_HEADERS.contains(nameLC) || nameLC.startsWith("x-amz-");
    }

    private static String toCleanString(List<String> list) {
        StringBuilder s2 = new StringBuilder();
        for (String v : list) {
            if (s2.length() > 0) {
                s2.append(',');
            }
            s2.append(v.replace("\n", "").trim());
        }
        return s2.toString();
    }

    private static String remove(Map<String, String> m4, String k2) {
        String r = m4.remove(k2);
        return r != null ? r : "";
    }

    private static String httpNow() {
        String tz = "GMT";
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);
        fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        return fmt.format(new Date()) + " GMT";
    }

    private static MessageDigest newMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException(JGitText.get().JRELacksMD5Implementation, e2);
        }
    }

    public AmazonS3(Properties props) {
        this.awsApiSignatureVersion = props.getProperty("aws.api.signature.version", AWS_API_V2);
        if (this.awsApiSignatureVersion.equals(AWS_API_V4)) {
            this.region = props.getProperty("region");
            if (this.region == null) {
                throw new IllegalArgumentException(JGitText.get().missingAwsRegion);
            }
        } else if (this.awsApiSignatureVersion.equals(AWS_API_V2)) {
            this.region = null;
        } else {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidAwsApiSignatureVersion, this.awsApiSignatureVersion));
        }
        this.protocol = props.getProperty("protocol", "http");
        this.domain = props.getProperty("domain", "s3.amazonaws.com");
        this.publicKey = props.getProperty("accesskey");
        if (this.publicKey == null) {
            throw new IllegalArgumentException(JGitText.get().missingAccesskey);
        }
        String secretKeyStr = props.getProperty("secretkey");
        if (secretKeyStr == null) {
            throw new IllegalArgumentException(JGitText.get().missingSecretkey);
        }
        this.secretKeySpec = new SecretKeySpec(Constants.encodeASCII(secretKeyStr), HMAC);
        this.secretKey = secretKeyStr.toCharArray();
        String pacl = props.getProperty("acl", "PRIVATE");
        if (StringUtils.equalsIgnoreCase("PRIVATE", pacl)) {
            this.acl = "private";
        } else if (StringUtils.equalsIgnoreCase("PUBLIC", pacl)) {
            this.acl = "public-read";
        } else if (StringUtils.equalsIgnoreCase("PUBLIC-READ", pacl)) {
            this.acl = "public-read";
        } else if (StringUtils.equalsIgnoreCase("PUBLIC_READ", pacl)) {
            this.acl = "public-read";
        } else {
            throw new IllegalArgumentException("Invalid acl: " + pacl);
        }
        try {
            this.encryption = WalkEncryption.instance(props);
        }
        catch (GeneralSecurityException e2) {
            throw new IllegalArgumentException(JGitText.get().invalidEncryption, e2);
        }
        this.maxAttempts = Integer.parseInt(props.getProperty("httpclient.retry-max", "3"));
        this.proxySelector = ProxySelector.getDefault();
        String tmp = props.getProperty("tmpdir");
        this.tmpDir = tmp != null && tmp.length() > 0 ? new File(tmp) : null;
    }

    public URLConnection get(String bucket, String key2) throws IOException {
        int curAttempt = 0;
        while (curAttempt < this.maxAttempts) {
            HttpURLConnection c2 = this.open("GET", bucket, key2);
            this.authorize(c2, Collections.emptyMap(), 0L, null);
            switch (HttpSupport.response(c2)) {
                case 200: {
                    this.encryption.validate(c2, X_AMZ_META);
                    return c2;
                }
                case 404: {
                    throw new FileNotFoundException(key2);
                }
                case 500: {
                    break;
                }
                default: {
                    throw this.error(JGitText.get().s3ActionReading, key2, c2);
                }
            }
            ++curAttempt;
        }
        throw this.maxAttempts(JGitText.get().s3ActionReading, key2);
    }

    public InputStream decrypt(URLConnection u) throws IOException {
        return this.encryption.decrypt(u.getInputStream());
    }

    public List<String> list(String bucket, String prefix2) throws IOException {
        if (((String)prefix2).length() > 0 && !((String)prefix2).endsWith("/")) {
            prefix2 = (String)prefix2 + "/";
        }
        ListParser lp = new ListParser(bucket, (String)prefix2);
        do {
            lp.list();
        } while (lp.truncated);
        Comparator<KeyInfo> comparator = Comparator.comparingLong(KeyInfo::getLastModifiedSecs);
        return lp.entries.stream().sorted(comparator.reversed()).map(KeyInfo::getName).collect(Collectors.toList());
    }

    public void delete(String bucket, String key2) throws IOException {
        int curAttempt = 0;
        while (curAttempt < this.maxAttempts) {
            HttpURLConnection c2 = this.open("DELETE", bucket, key2);
            this.authorize(c2, Collections.emptyMap(), 0L, null);
            switch (HttpSupport.response(c2)) {
                case 204: {
                    return;
                }
                case 500: {
                    break;
                }
                default: {
                    throw this.error(JGitText.get().s3ActionDeletion, key2, c2);
                }
            }
            ++curAttempt;
        }
        throw this.maxAttempts(JGitText.get().s3ActionDeletion, key2);
    }

    public void put(String bucket, String key2, byte[] data2) throws IOException {
        if (this.encryption != WalkEncryption.NONE) {
            Throwable throwable = null;
            Object var5_7 = null;
            try (OutputStream os = this.beginPut(bucket, key2, null, null);){
                os.write(data2);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return;
        }
        String md5str = Base64.encodeBytes(AmazonS3.newMD5().digest(data2));
        String bodyHash = this.awsApiSignatureVersion.equals(AWS_API_V4) ? AwsRequestSignerV4.calculateBodyHash(data2) : null;
        String lenstr = String.valueOf(data2.length);
        int curAttempt = 0;
        while (curAttempt < this.maxAttempts) {
            HttpURLConnection c2 = this.open("PUT", bucket, key2);
            c2.setRequestProperty("Content-Length", lenstr);
            c2.setRequestProperty("Content-MD5", md5str);
            c2.setRequestProperty(X_AMZ_ACL, this.acl);
            this.authorize(c2, Collections.emptyMap(), data2.length, bodyHash);
            c2.setDoOutput(true);
            c2.setFixedLengthStreamingMode(data2.length);
            Throwable throwable = null;
            Object var10_16 = null;
            try (OutputStream os = c2.getOutputStream();){
                os.write(data2);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            switch (HttpSupport.response(c2)) {
                case 200: {
                    return;
                }
                case 500: {
                    break;
                }
                default: {
                    throw this.error(JGitText.get().s3ActionWriting, key2, c2);
                }
            }
            ++curAttempt;
        }
        throw this.maxAttempts(JGitText.get().s3ActionWriting, key2);
    }

    public OutputStream beginPut(final String bucket, final String key2, final ProgressMonitor monitor, final String monitorTask) throws IOException {
        final MessageDigest md5 = AmazonS3.newMD5();
        TemporaryBuffer.LocalFile buffer = new TemporaryBuffer.LocalFile(this.tmpDir){

            @Override
            public void close() throws IOException {
                super.close();
                try {
                    AmazonS3.this.putImpl(bucket, key2, md5.digest(), this, monitor, monitorTask);
                }
                finally {
                    this.destroy();
                }
            }
        };
        return this.encryption.encrypt(new DigestOutputStream(buffer, md5));
    }

    void putImpl(String bucket, String key2, byte[] csum, TemporaryBuffer buf, ProgressMonitor monitor, String monitorTask) throws IOException {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        if (monitorTask == null) {
            monitorTask = MessageFormat.format(JGitText.get().progressMonUploading, key2);
        }
        String md5str = Base64.encodeBytes(csum);
        String bodyHash = this.awsApiSignatureVersion.equals(AWS_API_V4) ? AwsRequestSignerV4.calculateBodyHash(buf.toByteArray()) : null;
        long len2 = buf.length();
        int curAttempt = 0;
        while (curAttempt < this.maxAttempts) {
            HttpURLConnection c2 = this.open("PUT", bucket, key2);
            c2.setFixedLengthStreamingMode(len2);
            c2.setRequestProperty("Content-MD5", md5str);
            c2.setRequestProperty(X_AMZ_ACL, this.acl);
            this.encryption.request(c2, X_AMZ_META);
            this.authorize(c2, Collections.emptyMap(), len2, bodyHash);
            c2.setDoOutput(true);
            monitor.beginTask(monitorTask, (int)(len2 / 1024L));
            try {
                Throwable throwable = null;
                Object var14_14 = null;
                try (OutputStream os = c2.getOutputStream();){
                    buf.writeTo(os, monitor);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                monitor.endTask();
            }
            switch (HttpSupport.response(c2)) {
                case 200: {
                    return;
                }
                case 500: {
                    break;
                }
                default: {
                    throw this.error(JGitText.get().s3ActionWriting, key2, c2);
                }
            }
            ++curAttempt;
        }
        throw this.maxAttempts(JGitText.get().s3ActionWriting, key2);
    }

    IOException error(String action, String key2, HttpURLConnection c2) throws IOException {
        IOException err = new IOException(MessageFormat.format(JGitText.get().amazonS3ActionFailed, action, key2, HttpSupport.response(c2), c2.getResponseMessage()));
        if (c2.getErrorStream() == null) {
            return err;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream errorStream = c2.getErrorStream();){
            int n;
            ByteArrayOutputStream b2 = new ByteArrayOutputStream();
            byte[] buf = new byte[2048];
            while ((n = errorStream.read(buf)) >= 0) {
                if (n <= 0) continue;
                b2.write(buf, 0, n);
            }
            buf = b2.toByteArray();
            if (buf.length > 0) {
                err.initCause(new IOException("\n" + new String(buf, StandardCharsets.UTF_8)));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return err;
    }

    IOException maxAttempts(String action, String key2) {
        return new IOException(MessageFormat.format(JGitText.get().amazonS3ActionFailedGivingUp, action, key2, this.maxAttempts));
    }

    private HttpURLConnection open(String method2, String bucket, String key2) throws IOException {
        Map<String, String> noArgs = Collections.emptyMap();
        return this.open(method2, bucket, key2, noArgs);
    }

    HttpURLConnection open(String method2, String bucket, String key2, Map<String, String> args2) throws IOException {
        StringBuilder urlstr = new StringBuilder();
        urlstr.append(this.protocol);
        urlstr.append("://");
        urlstr.append(bucket);
        urlstr.append('.');
        urlstr.append(this.domain);
        urlstr.append('/');
        if (key2.length() > 0) {
            if (this.awsApiSignatureVersion.equals(AWS_API_V2)) {
                HttpSupport.encode(urlstr, key2);
            } else if (this.awsApiSignatureVersion.equals(AWS_API_V4)) {
                urlstr.append(key2);
            }
        }
        if (!args2.isEmpty()) {
            urlstr.append('?');
            Iterator<Map.Entry<String, String>> i2 = args2.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry<String, String> e2 = i2.next();
                urlstr.append(e2.getKey());
                urlstr.append('=');
                HttpSupport.encode(urlstr, e2.getValue());
                if (!i2.hasNext()) continue;
                urlstr.append('&');
            }
        }
        URL url2 = new URL(urlstr.toString());
        Proxy proxy = HttpSupport.proxyFor(this.proxySelector, url2);
        HttpURLConnection c2 = (HttpURLConnection)url2.openConnection(proxy);
        c2.setRequestMethod(method2);
        c2.setRequestProperty("User-Agent", "jgit/1.0");
        c2.setRequestProperty("Date", AmazonS3.httpNow());
        return c2;
    }

    void authorize(HttpURLConnection httpURLConnection, Map<String, String> queryParams2, long contentLength, String bodyHash) throws IOException {
        if (this.awsApiSignatureVersion.equals(AWS_API_V2)) {
            this.authorizeV2(httpURLConnection);
        } else if (this.awsApiSignatureVersion.equals(AWS_API_V4)) {
            AwsRequestSignerV4.sign(httpURLConnection, queryParams2, contentLength, bodyHash, AWS_S3_SERVICE_NAME, this.region, this.publicKey, this.secretKey);
        }
    }

    void authorizeV2(HttpURLConnection c2) throws IOException {
        String sec;
        Map<String, List<String>> reqHdr = c2.getRequestProperties();
        TreeMap<String, String> sigHdr = new TreeMap<String, String>();
        for (Map.Entry<String, List<String>> entry : reqHdr.entrySet()) {
            String hdr = entry.getKey();
            if (!AmazonS3.isSignedHeader(hdr)) continue;
            sigHdr.put(StringUtils.toLowerCase(hdr), AmazonS3.toCleanString(entry.getValue()));
        }
        StringBuilder s2 = new StringBuilder();
        s2.append(c2.getRequestMethod());
        s2.append('\n');
        s2.append(AmazonS3.remove(sigHdr, "content-md5"));
        s2.append('\n');
        s2.append(AmazonS3.remove(sigHdr, "content-type"));
        s2.append('\n');
        s2.append(AmazonS3.remove(sigHdr, "date"));
        s2.append('\n');
        for (Map.Entry entry : sigHdr.entrySet()) {
            s2.append((String)entry.getKey());
            s2.append(':');
            s2.append((String)entry.getValue());
            s2.append('\n');
        }
        String string = c2.getURL().getHost();
        s2.append('/');
        s2.append(string.substring(0, string.length() - this.domain.length() - 1));
        s2.append(c2.getURL().getPath());
        try {
            Mac m4 = Mac.getInstance(HMAC);
            m4.init(this.secretKeySpec);
            sec = Base64.encodeBytes(m4.doFinal(s2.toString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e3) {
            throw new IOException(MessageFormat.format(JGitText.get().noHMACsupport, HMAC, e3.getMessage()));
        }
        catch (InvalidKeyException e4) {
            throw new IOException(MessageFormat.format(JGitText.get().invalidKey, e4.getMessage()));
        }
        c2.setRequestProperty("Authorization", "AWS " + this.publicKey + ":" + sec);
    }

    static Properties properties(File authFile) throws FileNotFoundException, IOException {
        Properties p = new Properties();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream in = new FileInputStream(authFile);){
            p.load(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return p;
    }

    private static final class KeyInfo {
        private final String name;
        private final long lastModifiedSecs;

        public KeyInfo(String aname, long lsecs) {
            this.name = aname;
            this.lastModifiedSecs = lsecs;
        }

        public String getName() {
            return this.name;
        }

        public long getLastModifiedSecs() {
            return this.lastModifiedSecs;
        }
    }

    static interface Keys {
        public static final String AWS_API_SIGNATURE_VERSION = "aws.api.signature.version";
        public static final String ACCESS_KEY = "accesskey";
        public static final String SECRET_KEY = "secretkey";
        public static final String PASSWORD = "password";
        public static final String CRYPTO_ALG = "crypto.algorithm";
        public static final String CRYPTO_VER = "crypto.version";
        public static final String ACL = "acl";
        public static final String PROTOCOL = "protocol";
        public static final String DOMAIN = "domain";
        public static final String REGION = "region";
        public static final String HTTP_RETRY = "httpclient.retry-max";
        public static final String TMP_DIR = "tmpdir";
    }

    private final class ListParser
    extends DefaultHandler {
        final List<KeyInfo> entries = new ArrayList<KeyInfo>();
        private final String bucket;
        private final String prefix;
        boolean truncated;
        private StringBuilder data;
        private String keyName;
        private Instant keyLastModified;

        ListParser(String bn, String p) {
            this.bucket = bn;
            this.prefix = p;
        }

        void list() throws IOException {
            TreeMap<String, String> args2 = new TreeMap<String, String>();
            if (this.prefix.length() > 0) {
                args2.put("prefix", this.prefix);
            }
            if (!this.entries.isEmpty()) {
                args2.put("marker", this.prefix + this.entries.get(this.entries.size() - 1).getName());
            }
            int curAttempt = 0;
            while (curAttempt < AmazonS3.this.maxAttempts) {
                HttpURLConnection c2 = AmazonS3.this.open("GET", this.bucket, "", args2);
                AmazonS3.this.authorize(c2, args2, 0L, null);
                switch (HttpSupport.response(c2)) {
                    case 200: {
                        XMLReader xr;
                        this.truncated = false;
                        this.data = null;
                        this.keyName = null;
                        this.keyLastModified = null;
                        try {
                            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                            saxParserFactory.setNamespaceAware(true);
                            saxParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                            saxParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                            saxParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                            xr = saxParserFactory.newSAXParser().getXMLReader();
                        }
                        catch (ParserConfigurationException | SAXException e2) {
                            throw new IOException(JGitText.get().noXMLParserAvailable, e2);
                        }
                        xr.setContentHandler(this);
                        try {
                            Throwable e2 = null;
                            Object var6_9 = null;
                            try (InputStream in = c2.getInputStream();){
                                xr.parse(new InputSource(in));
                            }
                            catch (Throwable throwable) {
                                if (e2 == null) {
                                    e2 = throwable;
                                } else if (e2 != throwable) {
                                    e2.addSuppressed(throwable);
                                }
                                throw e2;
                            }
                        }
                        catch (SAXException parsingError) {
                            throw new IOException(MessageFormat.format(JGitText.get().errorListing, this.prefix), parsingError);
                        }
                        return;
                    }
                    case 500: {
                        break;
                    }
                    default: {
                        throw AmazonS3.this.error("Listing", this.prefix, c2);
                    }
                }
                ++curAttempt;
            }
            throw AmazonS3.this.maxAttempts("Listing", this.prefix);
        }

        @Override
        public void startElement(String uri2, String name, String qName, Attributes attributes2) throws SAXException {
            if ("Key".equals(name) || "IsTruncated".equals(name) || "LastModified".equals(name)) {
                this.data = new StringBuilder();
            }
            if ("Contents".equals(name)) {
                this.keyName = null;
                this.keyLastModified = null;
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int s2, int n) throws SAXException {
            if (this.data != null) {
                this.data.append(ch, s2, n);
            }
        }

        @Override
        public void characters(char[] ch, int s2, int n) throws SAXException {
            if (this.data != null) {
                this.data.append(ch, s2, n);
            }
        }

        @Override
        public void endElement(String uri2, String name, String qName) throws SAXException {
            if ("Key".equals(name)) {
                this.keyName = this.data.toString().substring(this.prefix.length());
            } else if ("IsTruncated".equals(name)) {
                this.truncated = StringUtils.equalsIgnoreCase("true", this.data.toString());
            } else if ("LastModified".equals(name)) {
                this.keyLastModified = Instant.parse(this.data.toString());
            } else if ("Contents".equals(name)) {
                this.entries.add(new KeyInfo(this.keyName, this.keyLastModified.getEpochSecond()));
            }
            this.data = null;
        }
    }
}

