/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.Hex;
import org.eclipse.jgit.util.HttpSupport;

public final class AwsRequestSignerV4 {
    private static final String ALGORITHM = "HMAC-SHA256";
    private static final String MAC_ALGORITHM = "HmacSHA256";
    private static final String SCHEME = "AWS4";
    private static final String TERMINATOR = "aws4_request";
    private static final String EMPTY_BODY_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    private static final DateTimeFormatter AMZ_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'");
    private static final DateTimeFormatter SCOPE_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd");

    private AwsRequestSignerV4() {
    }

    public static void sign(HttpURLConnection httpURLConnection, Map<String, String> queryParameters2, long contentLength, String bodyHash, String serviceName, String regionName, String awsAccessKey, char[] awsSecretKey) {
        HashMap<String, String> headers2 = new HashMap<String, String>();
        httpURLConnection.getRequestProperties().forEach((headerName, headerValues) -> {
            String string = headers2.put((String)headerName, String.join((CharSequence)",", headerValues));
        });
        if (contentLength > 0L) {
            headers2.put("Content-Length", String.valueOf(contentLength));
        } else {
            bodyHash = EMPTY_BODY_SHA256;
        }
        headers2.put("x-amz-content-sha256", bodyHash);
        OffsetDateTime now = Instant.now().atOffset(ZoneOffset.UTC);
        String amzDate = now.format(AMZ_DATE_FORMAT);
        headers2.put("x-amz-date", amzDate);
        URL endpointUrl = httpURLConnection.getURL();
        int port2 = endpointUrl.getPort();
        String hostHeader = port2 > -1 ? endpointUrl.getHost().concat(":" + port2) : endpointUrl.getHost();
        headers2.put("Host", hostHeader);
        String canonicalizedHeaderNames = AwsRequestSignerV4.getCanonicalizeHeaderNames(headers2);
        String canonicalizedHeaders = AwsRequestSignerV4.getCanonicalizedHeaderString(headers2);
        String canonicalizedQueryParameters = AwsRequestSignerV4.getCanonicalizedQueryString(queryParameters2);
        String httpMethod = httpURLConnection.getRequestMethod();
        String canonicalRequest = httpMethod + "\n" + AwsRequestSignerV4.getCanonicalizedResourcePath(endpointUrl) + "\n" + canonicalizedQueryParameters + "\n" + canonicalizedHeaders + "\n" + canonicalizedHeaderNames + "\n" + bodyHash;
        String scopeDate = now.format(SCOPE_DATE_FORMAT);
        String scope = scopeDate + "/" + regionName + "/" + serviceName + "/aws4_request";
        String stringToSign = "AWS4-HMAC-SHA256\n" + amzDate + "\n" + scope + "\n" + Hex.toHexString(AwsRequestSignerV4.hash(canonicalRequest.getBytes(StandardCharsets.UTF_8)));
        byte[] secretKey = (SCHEME + new String(awsSecretKey)).getBytes(StandardCharsets.UTF_8);
        byte[] dateKey = AwsRequestSignerV4.signStringWithKey(scopeDate, secretKey);
        byte[] regionKey = AwsRequestSignerV4.signStringWithKey(regionName, dateKey);
        byte[] serviceKey = AwsRequestSignerV4.signStringWithKey(serviceName, regionKey);
        byte[] signingKey = AwsRequestSignerV4.signStringWithKey(TERMINATOR, serviceKey);
        byte[] signature = AwsRequestSignerV4.signStringWithKey(stringToSign, signingKey);
        String credentialsAuthorizationHeader = "Credential=" + awsAccessKey + "/" + scope;
        String signedHeadersAuthorizationHeader = "SignedHeaders=" + canonicalizedHeaderNames;
        String signatureAuthorizationHeader = "Signature=" + Hex.toHexString(signature);
        String authorizationHeader = "AWS4-HMAC-SHA256 " + credentialsAuthorizationHeader + ", " + signedHeadersAuthorizationHeader + ", " + signatureAuthorizationHeader;
        headers2.forEach(httpURLConnection::setRequestProperty);
        httpURLConnection.setRequestProperty("Authorization", authorizationHeader);
    }

    public static String calculateBodyHash(byte[] data2) {
        return data2 == null || data2.length < 1 ? EMPTY_BODY_SHA256 : Hex.toHexString(AwsRequestSignerV4.hash(data2));
    }

    private static String getCanonicalizeHeaderNames(Map<String, String> headers2) {
        return headers2.keySet().stream().map(String::toLowerCase).sorted().collect(Collectors.joining(";"));
    }

    private static String getCanonicalizedHeaderString(Map<String, String> headers2) {
        if (headers2 == null || headers2.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        headers2.keySet().stream().sorted(String.CASE_INSENSITIVE_ORDER).forEach(key2 -> {
            String header = key2.toLowerCase().replaceAll("\\s+", " ");
            String value2 = ((String)headers2.get(key2)).replaceAll("\\s+", " ");
            sb.append(header).append(':').append(value2).append('\n');
        });
        return sb.toString();
    }

    private static String getCanonicalizedResourcePath(URL url2) {
        if (url2 == null) {
            return "/";
        }
        String path2 = url2.getPath();
        if (path2 == null || path2.isEmpty()) {
            return "/";
        }
        String encodedPath2 = HttpSupport.urlEncode(path2, true);
        if (encodedPath2.startsWith("/")) {
            return encodedPath2;
        }
        return "/".concat(encodedPath2);
    }

    public static String getCanonicalizedQueryString(Map<String, String> queryParameters2) {
        if (queryParameters2 == null || queryParameters2.isEmpty()) {
            return "";
        }
        return queryParameters2.keySet().stream().sorted().map(key2 -> HttpSupport.urlEncode(key2, false) + "=" + HttpSupport.urlEncode((String)queryParameters2.get(key2), false)).collect(Collectors.joining("&"));
    }

    public static byte[] hash(byte[] data2) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(data2);
            return md.digest();
        }
        catch (Exception e2) {
            throw new RuntimeException(JGitText.get().couldNotHashByteArrayWithSha256, e2);
        }
    }

    private static byte[] signStringWithKey(String stringToSign, byte[] key2) {
        try {
            byte[] data2 = stringToSign.getBytes(StandardCharsets.UTF_8);
            Mac mac = Mac.getInstance(MAC_ALGORITHM);
            mac.init(new SecretKeySpec(key2, MAC_ALGORITHM));
            return mac.doFinal(data2);
        }
        catch (Exception e2) {
            throw new RuntimeException(JGitText.get().couldNotSignStringWithKey, e2);
        }
    }
}

