/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class ChainingCredentialsProvider
extends CredentialsProvider {
    private List<CredentialsProvider> credentialProviders;

    public ChainingCredentialsProvider(CredentialsProvider ... providers) {
        this.credentialProviders = new ArrayList<CredentialsProvider>(Arrays.asList(providers));
    }

    @Override
    public boolean isInteractive() {
        for (CredentialsProvider p : this.credentialProviders) {
            if (!p.isInteractive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supports(CredentialItem ... items2) {
        for (CredentialsProvider p : this.credentialProviders) {
            if (!p.supports(items2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean get(URIish uri2, CredentialItem ... items2) throws UnsupportedCredentialItem {
        for (CredentialsProvider p : this.credentialProviders) {
            if (!p.supports(items2)) continue;
            if (!p.get(uri2, items2)) {
                if (!p.isInteractive()) continue;
                return false;
            }
            if (ChainingCredentialsProvider.isAnyNull(items2)) continue;
            return true;
        }
        return false;
    }
}

