/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.transport.Daemon;
import org.eclipse.jgit.transport.DaemonService;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;

public class DaemonClient {
    private final Daemon daemon;
    private InetAddress peer;
    private InputStream rawIn;
    private OutputStream rawOut;

    DaemonClient(Daemon d2) {
        this.daemon = d2;
    }

    void setRemoteAddress(InetAddress ia) {
        this.peer = ia;
    }

    public Daemon getDaemon() {
        return this.daemon;
    }

    public InetAddress getRemoteAddress() {
        return this.peer;
    }

    public InputStream getInputStream() {
        return this.rawIn;
    }

    public OutputStream getOutputStream() {
        return this.rawOut;
    }

    void execute(Socket sock) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
        DaemonService srv;
        int nul;
        this.rawIn = new BufferedInputStream(sock.getInputStream());
        this.rawOut = new BufferedOutputStream(sock.getOutputStream());
        if (this.daemon.getTimeout() > 0) {
            sock.setSoTimeout(this.daemon.getTimeout() * 1000);
        }
        String cmd = new PacketLineIn(this.rawIn).readStringRaw();
        List<String> extraParameters = null;
        int nulnul = cmd.indexOf("\u0000\u0000");
        if (nulnul != -1) {
            extraParameters = Arrays.asList(cmd.substring(nulnul + 2).split("\u0000"));
        }
        if ((nul = cmd.indexOf(0)) >= 0) {
            cmd = cmd.substring(0, nul);
        }
        if ((srv = this.getDaemon().matchService(cmd)) == null) {
            return;
        }
        sock.setSoTimeout(0);
        srv.execute(this, cmd, extraParameters);
    }
}

