/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public interface FtpChannel {
    public void connect(int var1, TimeUnit var2) throws IOException;

    public void disconnect();

    public boolean isConnected();

    public void cd(String var1) throws IOException;

    public String pwd() throws IOException;

    public Collection<DirEntry> ls(String var1) throws IOException;

    public void rmdir(String var1) throws IOException;

    public void mkdir(String var1) throws IOException;

    public InputStream get(String var1) throws IOException;

    public OutputStream put(String var1) throws IOException;

    public void rm(String var1) throws IOException;

    default public void delete(String path2) throws IOException {
        try {
            this.rm(path2);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (FtpException f2) {
            if (f2.getStatus() == 2) {
                return;
            }
            throw f2;
        }
    }

    public void rename(String var1, String var2) throws IOException;

    public static interface DirEntry {
        public String getFilename();

        public long getModifiedTime();

        public boolean isDirectory();
    }

    public static class FtpException
    extends IOException {
        private static final long serialVersionUID = 7176525179280330876L;
        public static final int OK = 0;
        public static final int EOF = 1;
        public static final int NO_SUCH_FILE = 2;
        public static final int NO_PERMISSION = 3;
        public static final int UNSPECIFIED_FAILURE = 4;
        public static final int PROTOCOL_ERROR = 5;
        public static final int UNSUPPORTED = 8;
        private final int status;

        public FtpException(String message, int status2) {
            super(message);
            this.status = status2;
        }

        public FtpException(String message, int status2, Throwable cause) {
            super(message, cause);
            this.status = status2;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

