/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UserAgent;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConfig {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConfig.class);
    private static final String FTP = "ftp";
    public static final String HTTP = "http";
    public static final String FOLLOW_REDIRECTS_KEY = "followRedirects";
    public static final String MAX_REDIRECTS_KEY = "maxRedirects";
    public static final String POST_BUFFER_KEY = "postBuffer";
    public static final String SSL_VERIFY_KEY = "sslVerify";
    public static final String USER_AGENT = "userAgent";
    public static final String EXTRA_HEADER = "extraHeader";
    public static final String COOKIE_FILE_KEY = "cookieFile";
    public static final String SAVE_COOKIES_KEY = "saveCookies";
    public static final String COOKIE_FILE_CACHE_LIMIT_KEY = "cookieFileCacheLimit";
    private static final int DEFAULT_COOKIE_FILE_CACHE_LIMIT = 10;
    private static final String MAX_REDIRECT_SYSTEM_PROPERTY = "http.maxRedirects";
    private static final int DEFAULT_MAX_REDIRECTS = 5;
    private static final int MAX_REDIRECTS = new Supplier<Integer>(){

        @Override
        public Integer get() {
            String rawValue = SystemReader.getInstance().getProperty(HttpConfig.MAX_REDIRECT_SYSTEM_PROPERTY);
            Integer value2 = 5;
            if (rawValue != null) {
                try {
                    value2 = Integer.parseUnsignedInt(rawValue);
                }
                catch (NumberFormatException e2) {
                    LOG.warn(MessageFormat.format(JGitText.get().invalidSystemProperty, HttpConfig.MAX_REDIRECT_SYSTEM_PROPERTY, rawValue, value2));
                }
            }
            return value2;
        }
    }.get();
    private static final String ENV_HTTP_USER_AGENT = "GIT_HTTP_USER_AGENT";
    private int postBuffer;
    private boolean sslVerify;
    private HttpRedirectMode followRedirects;
    private int maxRedirects;
    private String userAgent;
    private List<String> extraHeaders;
    private String cookieFile;
    private boolean saveCookies;
    private int cookieFileCacheLimit;

    public int getPostBuffer() {
        return this.postBuffer;
    }

    public boolean isSslVerify() {
        return this.sslVerify;
    }

    public HttpRedirectMode getFollowRedirects() {
        return this.followRedirects;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    @NonNull
    public List<String> getExtraHeaders() {
        return this.extraHeaders == null ? Collections.emptyList() : this.extraHeaders;
    }

    public String getCookieFile() {
        return this.cookieFile;
    }

    public boolean getSaveCookies() {
        return this.saveCookies;
    }

    public int getCookieFileCacheLimit() {
        return this.cookieFileCacheLimit;
    }

    public HttpConfig(Config config2, URIish uri2) {
        this.init(config2, uri2);
    }

    public HttpConfig(URIish uri2) {
        StoredConfig userConfig = null;
        try {
            userConfig = SystemReader.getInstance().getUserConfig();
        }
        catch (IOException | ConfigInvalidException e2) {
            LOG.error(e2.getMessage(), e2);
            this.init(new Config(), uri2);
            return;
        }
        this.init(userConfig, uri2);
    }

    private void init(Config config2, URIish uri2) {
        String agent;
        int postBufferSize = config2.getInt(HTTP, POST_BUFFER_KEY, 0x100000);
        boolean sslVerifyFlag = config2.getBoolean(HTTP, SSL_VERIFY_KEY, true);
        HttpRedirectMode followRedirectsMode = config2.getEnum(HTTP, null, FOLLOW_REDIRECTS_KEY, HttpRedirectMode.INITIAL);
        int redirectLimit = config2.getInt(HTTP, MAX_REDIRECTS_KEY, MAX_REDIRECTS);
        if (redirectLimit < 0) {
            redirectLimit = MAX_REDIRECTS;
        }
        if ((agent = config2.getString(HTTP, null, USER_AGENT)) != null) {
            agent = UserAgent.clean(agent);
        }
        this.userAgent = agent;
        String[] headers2 = config2.getStringList(HTTP, null, EXTRA_HEADER);
        int start2 = this.findLastEmpty(headers2) + 1;
        if (start2 > 0) {
            headers2 = Arrays.copyOfRange(headers2, start2, headers2.length);
        }
        this.extraHeaders = Arrays.asList(headers2);
        this.cookieFile = config2.getString(HTTP, null, COOKIE_FILE_KEY);
        this.saveCookies = config2.getBoolean(HTTP, SAVE_COOKIES_KEY, false);
        this.cookieFileCacheLimit = config2.getInt(HTTP, COOKIE_FILE_CACHE_LIMIT_KEY, 10);
        String match2 = this.findMatch(config2.getSubsections(HTTP), uri2);
        if (match2 != null) {
            String urlSpecificCookieFile;
            String[] uriSpecificExtraHeaders;
            String uriSpecificUserAgent;
            postBufferSize = config2.getInt(HTTP, match2, POST_BUFFER_KEY, postBufferSize);
            sslVerifyFlag = config2.getBoolean(HTTP, match2, SSL_VERIFY_KEY, sslVerifyFlag);
            followRedirectsMode = config2.getEnum(HTTP, match2, FOLLOW_REDIRECTS_KEY, followRedirectsMode);
            int newMaxRedirects = config2.getInt(HTTP, match2, MAX_REDIRECTS_KEY, redirectLimit);
            if (newMaxRedirects >= 0) {
                redirectLimit = newMaxRedirects;
            }
            if ((uriSpecificUserAgent = config2.getString(HTTP, match2, USER_AGENT)) != null) {
                this.userAgent = UserAgent.clean(uriSpecificUserAgent);
            }
            if ((uriSpecificExtraHeaders = config2.getStringList(HTTP, match2, EXTRA_HEADER)).length > 0) {
                start2 = this.findLastEmpty(uriSpecificExtraHeaders) + 1;
                if (start2 > 0) {
                    uriSpecificExtraHeaders = Arrays.copyOfRange(uriSpecificExtraHeaders, start2, uriSpecificExtraHeaders.length);
                }
                this.extraHeaders = Arrays.asList(uriSpecificExtraHeaders);
            }
            if ((urlSpecificCookieFile = config2.getString(HTTP, match2, COOKIE_FILE_KEY)) != null) {
                this.cookieFile = urlSpecificCookieFile;
            }
            this.saveCookies = config2.getBoolean(HTTP, match2, SAVE_COOKIES_KEY, this.saveCookies);
        }
        if (!StringUtils.isEmptyOrNull(agent = SystemReader.getInstance().getenv(ENV_HTTP_USER_AGENT))) {
            this.userAgent = UserAgent.clean(agent);
        }
        this.postBuffer = postBufferSize;
        this.sslVerify = sslVerifyFlag;
        this.followRedirects = followRedirectsMode;
        this.maxRedirects = redirectLimit;
    }

    private int findLastEmpty(String[] values2) {
        int i2 = values2.length - 1;
        while (i2 >= 0) {
            if (values2[i2] == null) {
                return i2;
            }
            --i2;
        }
        return -1;
    }

    private String findMatch(Set<String> names2, URIish uri2) {
        boolean hasPath;
        String bestMatch = null;
        int bestMatchLength = -1;
        boolean withUser = false;
        String uPath = uri2.getPath();
        boolean bl = hasPath = !StringUtils.isEmptyOrNull(uPath);
        if (hasPath && (uPath = HttpConfig.normalize(uPath)) == null) {
            return null;
        }
        for (String s2 : names2) {
            try {
                URIish candidate = new URIish(s2);
                if (!this.compare(uri2.getScheme(), candidate.getScheme()) || !this.compare(uri2.getHost(), candidate.getHost()) || this.defaultedPort(uri2.getPort(), uri2.getScheme()) != this.defaultedPort(candidate.getPort(), candidate.getScheme())) continue;
                boolean hasUser = false;
                if (candidate.getUser() != null) {
                    if (!candidate.getUser().equals(uri2.getUser())) continue;
                    hasUser = true;
                }
                String cPath = candidate.getPath();
                int matchLength = -1;
                if (StringUtils.isEmptyOrNull(cPath)) {
                    matchLength = 0;
                } else if (!hasPath || (matchLength = HttpConfig.segmentCompare(uPath, cPath)) < 0) continue;
                if (matchLength <= bestMatchLength && (withUser || !hasUser || matchLength < 0 || matchLength != bestMatchLength)) continue;
                bestMatch = s2;
                bestMatchLength = matchLength;
                withUser = hasUser;
            }
            catch (URISyntaxException e2) {
                LOG.warn(MessageFormat.format(JGitText.get().httpConfigInvalidURL, s2));
            }
        }
        return bestMatch;
    }

    private boolean compare(String a2, String b2) {
        if (a2 == null) {
            return b2 == null;
        }
        return a2.equalsIgnoreCase(b2);
    }

    private int defaultedPort(int port2, String scheme2) {
        if (port2 >= 0) {
            return port2;
        }
        if (FTP.equalsIgnoreCase(scheme2)) {
            return 21;
        }
        if (HTTP.equalsIgnoreCase(scheme2)) {
            return 80;
        }
        return 443;
    }

    static int segmentCompare(String uriPath, String m4) {
        String matchPath = HttpConfig.normalize(m4);
        if (matchPath == null || !uriPath.startsWith(matchPath)) {
            return -1;
        }
        int uLength = uriPath.length();
        int mLength = matchPath.length();
        if (mLength == uLength || matchPath.charAt(mLength - 1) == '/' || mLength < uLength && uriPath.charAt(mLength) == '/') {
            return mLength;
        }
        return -1;
    }

    static String normalize(String path2) {
        int i2 = 0;
        int length = path2.length();
        StringBuilder builder = new StringBuilder(length);
        builder.append('/');
        if (length > 0 && path2.charAt(0) == '/') {
            i2 = 1;
        }
        while (i2 < length) {
            int slash = path2.indexOf(47, i2);
            if (slash < 0) {
                slash = length;
            }
            if (slash != i2 && (slash != i2 + 1 || path2.charAt(i2) != '.')) {
                if (slash == i2 + 2 && path2.charAt(i2) == '.' && path2.charAt(i2 + 1) == '.') {
                    int l = builder.length() - 2;
                    while (l >= 0 && builder.charAt(l) != '/') {
                        --l;
                    }
                    if (l < 0) {
                        LOG.warn(MessageFormat.format(JGitText.get().httpConfigCannotNormalizeURL, path2));
                        return null;
                    }
                    builder.setLength(l + 1);
                } else {
                    builder.append(path2, i2, Math.min(length, slash + 1));
                }
            }
            i2 = slash + 1;
        }
        if (builder.length() > 1 && builder.charAt(builder.length() - 1) == '/' && length > 0 && path2.charAt(length - 1) != '/') {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static enum HttpRedirectMode implements Config.ConfigEnum
    {
        TRUE("true"),
        INITIAL("initial"),
        FALSE("false");

        private final String configValue;

        private HttpRedirectMode(String configValue) {
            this.configValue = configValue;
        }

        @Override
        public String toConfigValue() {
            return this.configValue;
        }

        @Override
        public boolean matchConfigValue(String s2) {
            return this.configValue.equals(s2);
        }
    }
}

