/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.NetRC;
import org.eclipse.jgit.transport.URIish;

public class NetRCCredentialsProvider
extends CredentialsProvider {
    NetRC netrc = new NetRC();

    public static void install() {
        CredentialsProvider.setDefault(new NetRCCredentialsProvider());
    }

    @Override
    public boolean supports(CredentialItem ... items2) {
        CredentialItem[] credentialItemArray = items2;
        int n = items2.length;
        int n2 = 0;
        while (n2 < n) {
            CredentialItem i2 = credentialItemArray[n2];
            if (!(i2 instanceof CredentialItem.Username) && !(i2 instanceof CredentialItem.Password)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean get(URIish uri2, CredentialItem ... items2) throws UnsupportedCredentialItem {
        NetRC.NetRCEntry cc = this.netrc.getEntry(uri2.getHost());
        if (cc == null) {
            return false;
        }
        CredentialItem[] credentialItemArray = items2;
        int n = items2.length;
        int n2 = 0;
        while (n2 < n) {
            CredentialItem i2 = credentialItemArray[n2];
            if (i2 instanceof CredentialItem.Username) {
                ((CredentialItem.Username)i2).setValue(cc.login);
            } else if (i2 instanceof CredentialItem.Password) {
                ((CredentialItem.Password)i2).setValue(cc.password);
            } else if (i2 instanceof CredentialItem.StringType && i2.getPromptText().equals("Password: ")) {
                ((CredentialItem.StringType)i2).setValue(new String(cc.password));
            } else {
                throw new UnsupportedCredentialItem(uri2, i2.getClass().getName() + ":" + i2.getPromptText());
            }
            ++n2;
        }
        return !NetRCCredentialsProvider.isAnyNull(items2);
    }

    @Override
    public boolean isInteractive() {
        return false;
    }
}

