/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.transport.PostReceiveHook;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;

public class PostReceiveHookChain
implements PostReceiveHook {
    private final PostReceiveHook[] hooks;
    private final int count;

    public static PostReceiveHook newChain(List<? extends PostReceiveHook> hooks) {
        PostReceiveHook[] newHooks = new PostReceiveHook[hooks.size()];
        int i2 = 0;
        for (PostReceiveHook postReceiveHook : hooks) {
            if (postReceiveHook == PostReceiveHook.NULL) continue;
            newHooks[i2++] = postReceiveHook;
        }
        switch (i2) {
            case 0: {
                return PostReceiveHook.NULL;
            }
            case 1: {
                return newHooks[0];
            }
        }
        return new PostReceiveHookChain(newHooks, i2);
    }

    @Override
    public void onPostReceive(ReceivePack rp, Collection<ReceiveCommand> commands) {
        int i2 = 0;
        while (i2 < this.count) {
            this.hooks[i2].onPostReceive(rp, commands);
            ++i2;
        }
    }

    private PostReceiveHookChain(PostReceiveHook[] hooks, int count2) {
        this.hooks = hooks;
        this.count = count2;
    }
}

