/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.transport.ReceiveCommand;

public interface ReceiveCommandErrorHandler {
    default public void handleNewIdValidationException(ReceiveCommand cmd, IOException e2) {
        cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT, cmd.getNewId().name());
    }

    default public void handleOldIdValidationException(ReceiveCommand cmd, IOException e2) {
        cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT, cmd.getOldId().name());
    }

    default public void handleFastForwardCheckException(ReceiveCommand cmd, IOException e2) {
        if (e2 instanceof MissingObjectException) {
            cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT, e2.getMessage());
        } else {
            cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON);
        }
    }

    default public void handleBatchRefUpdateException(List<ReceiveCommand> cmds, IOException e2) {
        for (ReceiveCommand cmd : cmds) {
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
            cmd.reject(e2);
        }
    }
}

