/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UrlConfig;

public class RemoteConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SECTION = "remote";
    private static final String KEY_URL = "url";
    private static final String KEY_PUSHURL = "pushurl";
    private static final String KEY_FETCH = "fetch";
    private static final String KEY_PUSH = "push";
    private static final String KEY_UPLOADPACK = "uploadpack";
    private static final String KEY_RECEIVEPACK = "receivepack";
    private static final String KEY_TAGOPT = "tagopt";
    private static final String KEY_MIRROR = "mirror";
    private static final String KEY_TIMEOUT = "timeout";
    private static final boolean DEFAULT_MIRROR = false;
    public static final String DEFAULT_UPLOAD_PACK = "git-upload-pack";
    public static final String DEFAULT_RECEIVE_PACK = "git-receive-pack";
    private String name;
    private List<URIish> uris;
    private List<URIish> pushURIs;
    private List<RefSpec> fetch;
    private List<RefSpec> push;
    private String uploadpack;
    private String receivepack;
    private TagOpt tagopt;
    private boolean mirror;
    private int timeout;

    public static List<RemoteConfig> getAllRemoteConfigs(Config rc2) throws URISyntaxException {
        ArrayList<String> names2 = new ArrayList<String>(rc2.getSubsections(SECTION));
        Collections.sort(names2);
        ArrayList<RemoteConfig> result2 = new ArrayList<RemoteConfig>(names2.size());
        for (String name : names2) {
            result2.add(new RemoteConfig(rc2, name));
        }
        return result2;
    }

    public RemoteConfig(Config rc2, String remoteName) throws URISyntaxException {
        this.name = remoteName;
        String[] vlst = rc2.getStringList(SECTION, this.name, KEY_URL);
        UrlConfig urls2 = new UrlConfig(rc2);
        this.uris = new ArrayList<URIish>(vlst.length);
        String[] stringArray = vlst;
        int n = vlst.length;
        int n2 = 0;
        while (n2 < n) {
            String s2 = stringArray[n2];
            this.uris.add(new URIish(urls2.replace(s2)));
            ++n2;
        }
        String[] plst = rc2.getStringList(SECTION, this.name, KEY_PUSHURL);
        this.pushURIs = new ArrayList<URIish>(plst.length);
        String[] stringArray2 = plst;
        int n3 = plst.length;
        n = 0;
        while (n < n3) {
            String s3 = stringArray2[n];
            this.pushURIs.add(new URIish(s3));
            ++n;
        }
        if (this.pushURIs.isEmpty() && urls2.hasPushReplacements()) {
            stringArray2 = vlst;
            n3 = vlst.length;
            n = 0;
            while (n < n3) {
                String s4 = stringArray2[n];
                String replaced = urls2.replacePush(s4);
                if (!s4.equals(replaced)) {
                    this.pushURIs.add(new URIish(replaced));
                }
                ++n;
            }
        }
        this.fetch = rc2.getRefSpecs(SECTION, this.name, KEY_FETCH);
        this.push = rc2.getRefSpecs(SECTION, this.name, KEY_PUSH);
        String val = rc2.getString(SECTION, this.name, KEY_UPLOADPACK);
        if (val == null) {
            val = DEFAULT_UPLOAD_PACK;
        }
        this.uploadpack = val;
        val = rc2.getString(SECTION, this.name, KEY_RECEIVEPACK);
        if (val == null) {
            val = DEFAULT_RECEIVE_PACK;
        }
        this.receivepack = val;
        try {
            val = rc2.getString(SECTION, this.name, KEY_TAGOPT);
            this.tagopt = TagOpt.fromOption(val);
        }
        catch (IllegalArgumentException e2) {
            this.tagopt = TagOpt.AUTO_FOLLOW;
        }
        this.mirror = rc2.getBoolean(SECTION, this.name, KEY_MIRROR, false);
        this.timeout = rc2.getInt(SECTION, this.name, KEY_TIMEOUT, 0);
    }

    public void update(Config rc2) {
        ArrayList<String> vlst = new ArrayList<String>();
        vlst.clear();
        for (URIish uRIish : this.getURIs()) {
            vlst.add(uRIish.toPrivateString());
        }
        rc2.setStringList(SECTION, this.getName(), KEY_URL, vlst);
        vlst.clear();
        for (URIish uRIish : this.getPushURIs()) {
            vlst.add(uRIish.toPrivateString());
        }
        rc2.setStringList(SECTION, this.getName(), KEY_PUSHURL, vlst);
        vlst.clear();
        for (RefSpec refSpec : this.getFetchRefSpecs()) {
            vlst.add(refSpec.toString());
        }
        rc2.setStringList(SECTION, this.getName(), KEY_FETCH, vlst);
        vlst.clear();
        for (RefSpec refSpec : this.getPushRefSpecs()) {
            vlst.add(refSpec.toString());
        }
        rc2.setStringList(SECTION, this.getName(), KEY_PUSH, vlst);
        this.set(rc2, KEY_UPLOADPACK, this.getUploadPack(), DEFAULT_UPLOAD_PACK);
        this.set(rc2, KEY_RECEIVEPACK, this.getReceivePack(), DEFAULT_RECEIVE_PACK);
        this.set(rc2, KEY_TAGOPT, this.getTagOpt().option(), TagOpt.AUTO_FOLLOW.option());
        this.set(rc2, KEY_MIRROR, this.mirror, false);
        this.set(rc2, KEY_TIMEOUT, this.timeout, 0);
    }

    private void set(Config rc2, String key2, String currentValue, String defaultValue) {
        if (defaultValue.equals(currentValue)) {
            this.unset(rc2, key2);
        } else {
            rc2.setString(SECTION, this.getName(), key2, currentValue);
        }
    }

    private void set(Config rc2, String key2, boolean currentValue, boolean defaultValue) {
        if (defaultValue == currentValue) {
            this.unset(rc2, key2);
        } else {
            rc2.setBoolean(SECTION, this.getName(), key2, currentValue);
        }
    }

    private void set(Config rc2, String key2, int currentValue, int defaultValue) {
        if (defaultValue == currentValue) {
            this.unset(rc2, key2);
        } else {
            rc2.setInt(SECTION, this.getName(), key2, currentValue);
        }
    }

    private void unset(Config rc2, String key2) {
        rc2.unset(SECTION, this.getName(), key2);
    }

    public String getName() {
        return this.name;
    }

    public List<URIish> getURIs() {
        return Collections.unmodifiableList(this.uris);
    }

    public boolean addURI(URIish toAdd) {
        if (this.uris.contains(toAdd)) {
            return false;
        }
        return this.uris.add(toAdd);
    }

    public boolean removeURI(URIish toRemove) {
        return this.uris.remove(toRemove);
    }

    public List<URIish> getPushURIs() {
        return Collections.unmodifiableList(this.pushURIs);
    }

    public boolean addPushURI(URIish toAdd) {
        if (this.pushURIs.contains(toAdd)) {
            return false;
        }
        return this.pushURIs.add(toAdd);
    }

    public boolean removePushURI(URIish toRemove) {
        return this.pushURIs.remove(toRemove);
    }

    public List<RefSpec> getFetchRefSpecs() {
        return Collections.unmodifiableList(this.fetch);
    }

    public boolean addFetchRefSpec(RefSpec s2) {
        if (this.fetch.contains(s2)) {
            return false;
        }
        return this.fetch.add(s2);
    }

    public void setFetchRefSpecs(List<RefSpec> specs) {
        this.fetch.clear();
        this.fetch.addAll(specs);
    }

    public void setPushRefSpecs(List<RefSpec> specs) {
        this.push.clear();
        this.push.addAll(specs);
    }

    public boolean removeFetchRefSpec(RefSpec s2) {
        return this.fetch.remove(s2);
    }

    public List<RefSpec> getPushRefSpecs() {
        return Collections.unmodifiableList(this.push);
    }

    public boolean addPushRefSpec(RefSpec s2) {
        if (this.push.contains(s2)) {
            return false;
        }
        return this.push.add(s2);
    }

    public boolean removePushRefSpec(RefSpec s2) {
        return this.push.remove(s2);
    }

    public String getUploadPack() {
        return this.uploadpack;
    }

    public String getReceivePack() {
        return this.receivepack;
    }

    public TagOpt getTagOpt() {
        return this.tagopt;
    }

    public void setTagOpt(TagOpt option) {
        this.tagopt = option != null ? option : TagOpt.AUTO_FOLLOW;
    }

    public boolean isMirror() {
        return this.mirror;
    }

    public void setMirror(boolean m4) {
        this.mirror = m4;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }
}

