/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BundleFetchConnection;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportBundle;
import org.eclipse.jgit.transport.TransportLocal;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;

class TransportBundleFile
extends Transport
implements TransportBundle {
    static final TransportProtocol PROTO_BUNDLE = new TransportProtocol(){
        private final String[] schemeNames = new String[]{"bundle", "file"};
        private final Set<String> schemeSet = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(this.schemeNames)));

        @Override
        public String getName() {
            return JGitText.get().transportProtoBundleFile;
        }

        @Override
        public Set<String> getSchemes() {
            return this.schemeSet;
        }

        @Override
        public boolean canHandle(URIish uri2, Repository local, String remoteName) {
            return uri2.getPath() != null && uri2.getPort() <= 0 && uri2.getUser() == null && uri2.getPass() == null && uri2.getHost() == null && (uri2.getScheme() == null || this.getSchemes().contains(uri2.getScheme()));
        }

        @Override
        public Transport open(URIish uri2, Repository local, String remoteName) throws NotSupportedException, TransportException {
            if ("bundle".equals(uri2.getScheme())) {
                File path2 = FS.DETECTED.resolve(new File("."), uri2.getPath());
                return new TransportBundleFile(local, uri2, path2);
            }
            return TransportLocal.PROTO_LOCAL.open(uri2, local, remoteName);
        }

        @Override
        public Transport open(URIish uri2) throws NotSupportedException, TransportException {
            if ("bundle".equals(uri2.getScheme())) {
                File path2 = FS.DETECTED.resolve(new File("."), uri2.getPath());
                return new TransportBundleFile(uri2, path2);
            }
            return TransportLocal.PROTO_LOCAL.open(uri2);
        }
    };
    private final File bundle;

    TransportBundleFile(Repository local, URIish uri2, File bundlePath) {
        super(local, uri2);
        this.bundle = bundlePath;
    }

    public TransportBundleFile(URIish uri2, File bundlePath) {
        super(uri2);
        this.bundle = bundlePath;
    }

    @Override
    public FetchConnection openFetch() throws NotSupportedException, TransportException {
        FileInputStream src;
        try {
            src = new FileInputStream(this.bundle);
        }
        catch (FileNotFoundException err) {
            TransportException te = new TransportException(this.uri, JGitText.get().notFound);
            te.initCause(err);
            throw te;
        }
        return new BundleFetchConnection(this, src);
    }

    @Override
    public PushConnection openPush() throws NotSupportedException {
        throw new NotSupportedException(JGitText.get().pushIsNotSupportedForBundleTransport);
    }

    @Override
    public void close() {
    }
}

