/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BasePackFetchConnection;
import org.eclipse.jgit.transport.BasePackPushConnection;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.RemoteSession2;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.TransferConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.QuotedString;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.io.MessageWriter;
import org.eclipse.jgit.util.io.StreamCopyThread;

public class TransportGitSsh
extends SshTransport
implements PackTransport {
    private static final String EXT = "ext";
    static final TransportProtocol PROTO_SSH = new TransportProtocol(){
        private final String[] schemeNames = new String[]{"ssh", "ssh+git", "git+ssh"};
        private final Set<String> schemeSet = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(this.schemeNames)));

        @Override
        public String getName() {
            return JGitText.get().transportProtoSSH;
        }

        @Override
        public Set<String> getSchemes() {
            return this.schemeSet;
        }

        @Override
        public Set<TransportProtocol.URIishField> getRequiredFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.HOST, TransportProtocol.URIishField.PATH));
        }

        @Override
        public Set<TransportProtocol.URIishField> getOptionalFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.USER, TransportProtocol.URIishField.PASS, TransportProtocol.URIishField.PORT));
        }

        @Override
        public int getDefaultPort() {
            return 22;
        }

        @Override
        public boolean canHandle(URIish uri2, Repository local, String remoteName) {
            if (uri2.getScheme() == null) {
                return uri2.getHost() != null && uri2.getPath() != null && uri2.getHost().length() != 0 && uri2.getPath().length() != 0;
            }
            return super.canHandle(uri2, local, remoteName);
        }

        @Override
        public Transport open(URIish uri2, Repository local, String remoteName) throws NotSupportedException {
            return new TransportGitSsh(local, uri2);
        }

        @Override
        public Transport open(URIish uri2) throws NotSupportedException, TransportException {
            return new TransportGitSsh(uri2);
        }
    };

    TransportGitSsh(Repository local, URIish uri2) {
        super(local, uri2);
        this.initSshSessionFactory();
    }

    TransportGitSsh(URIish uri2) {
        super(uri2);
        this.initSshSessionFactory();
    }

    private void initSshSessionFactory() {
        if (TransportGitSsh.useExtSession()) {
            this.setSshSessionFactory(new SshSessionFactory(){

                @Override
                public RemoteSession getSession(URIish uri2, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
                    return new ExtSession();
                }

                @Override
                public String getType() {
                    return TransportGitSsh.EXT;
                }
            });
        }
    }

    @Override
    public FetchConnection openFetch() throws TransportException {
        return new SshFetchConnection();
    }

    @Override
    public FetchConnection openFetch(Collection<RefSpec> refSpecs, String ... additionalPatterns2) throws NotSupportedException, TransportException {
        return new SshFetchConnection(refSpecs, additionalPatterns2);
    }

    @Override
    public PushConnection openPush() throws TransportException {
        return new SshPushConnection();
    }

    String commandFor(String exe) {
        String path2 = this.uri.getPath();
        if (this.uri.getScheme() != null && this.uri.getPath().startsWith("/~")) {
            path2 = this.uri.getPath().substring(1);
        }
        StringBuilder cmd = new StringBuilder();
        cmd.append(exe);
        cmd.append(' ');
        cmd.append(QuotedString.BOURNE.quote(path2));
        return cmd.toString();
    }

    void checkExecFailure(int status2, String exe, String why) throws TransportException {
        if (status2 == 127) {
            IOException cause = null;
            if (why != null && why.length() > 0) {
                cause = new IOException(why);
            }
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().cannotExecute, this.commandFor(exe)), cause);
        }
    }

    NoRemoteRepositoryException cleanNotFound(NoRemoteRepositoryException nf, String why) {
        if (why == null || why.length() == 0) {
            return nf;
        }
        String path2 = this.uri.getPath();
        if (this.uri.getScheme() != null && this.uri.getPath().startsWith("/~")) {
            path2 = this.uri.getPath().substring(1);
        }
        StringBuilder pfx = new StringBuilder();
        pfx.append("fatal: ");
        pfx.append(QuotedString.BOURNE.quote(path2));
        pfx.append(": ");
        if (why.startsWith(pfx.toString())) {
            why = why.substring(pfx.length());
        }
        return new NoRemoteRepositoryException(this.uri, why);
    }

    private static boolean useExtSession() {
        return SystemReader.getInstance().getenv("GIT_SSH") != null;
    }

    private class ExtSession
    implements RemoteSession2 {
        private ExtSession() {
        }

        @Override
        public Process exec(String command2, int timeout2) throws TransportException {
            return this.exec(command2, null, timeout2);
        }

        @Override
        public Process exec(String command2, Map<String, String> environment2, int timeout2) throws TransportException {
            String ssh = SystemReader.getInstance().getenv("GIT_SSH");
            boolean putty = ssh.toLowerCase(Locale.ROOT).contains("plink");
            ArrayList<String> args2 = new ArrayList<String>();
            args2.add(ssh);
            if (putty && !ssh.toLowerCase(Locale.ROOT).contains("tortoiseplink")) {
                args2.add("-batch");
            }
            if (TransportGitSsh.this.getURI().getPort() > 0) {
                args2.add(putty ? "-P" : "-p");
                args2.add(String.valueOf(TransportGitSsh.this.getURI().getPort()));
            }
            if (TransportGitSsh.this.getURI().getUser() != null) {
                args2.add(TransportGitSsh.this.getURI().getUser() + "@" + TransportGitSsh.this.getURI().getHost());
            } else {
                args2.add(TransportGitSsh.this.getURI().getHost());
            }
            args2.add(command2);
            ProcessBuilder pb = this.createProcess(args2, environment2);
            try {
                return pb.start();
            }
            catch (IOException err) {
                throw new TransportException(err.getMessage(), err);
            }
        }

        private ProcessBuilder createProcess(List<String> args2, Map<String, String> environment2) {
            File commonDirectory;
            File directory;
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(args2);
            if (environment2 != null) {
                pb.environment().putAll(environment2);
            }
            File file2 = directory = TransportGitSsh.this.local != null ? TransportGitSsh.this.local.getDirectory() : null;
            if (directory != null) {
                pb.environment().put("GIT_DIR", directory.getPath());
            }
            File file3 = commonDirectory = TransportGitSsh.this.local != null ? TransportGitSsh.this.local.getCommonDirectory() : null;
            if (commonDirectory != null) {
                pb.environment().put("GIT_COMMON_DIR", commonDirectory.getPath());
            }
            return pb;
        }

        @Override
        public void disconnect() {
        }
    }

    class SshFetchConnection
    extends BasePackFetchConnection {
        private final Process process;
        private StreamCopyThread errorThread;

        SshFetchConnection() throws TransportException {
            this(Collections.emptyList(), new String[0]);
        }

        SshFetchConnection(Collection<RefSpec> refSpecs, String ... additionalPatterns2) throws TransportException {
            super(TransportGitSsh.this);
            try {
                RemoteSession session2 = TransportGitSsh.this.getSession();
                TransferConfig.ProtocolVersion gitProtocol = TransportGitSsh.this.protocol;
                if (gitProtocol == null) {
                    gitProtocol = TransferConfig.ProtocolVersion.V2;
                }
                this.process = session2 instanceof RemoteSession2 && TransferConfig.ProtocolVersion.V2.equals((Object)gitProtocol) ? ((RemoteSession2)session2).exec(TransportGitSsh.this.commandFor(TransportGitSsh.this.getOptionUploadPack()), Collections.singletonMap("GIT_PROTOCOL", "version=2"), TransportGitSsh.this.getTimeout()) : session2.exec(TransportGitSsh.this.commandFor(TransportGitSsh.this.getOptionUploadPack()), TransportGitSsh.this.getTimeout());
                MessageWriter msg = new MessageWriter();
                this.setMessageWriter(msg);
                InputStream upErr = this.process.getErrorStream();
                this.errorThread = new StreamCopyThread(upErr, msg.getRawStream());
                this.errorThread.start();
                this.init(this.process.getInputStream(), this.process.getOutputStream());
            }
            catch (TransportException err) {
                this.close();
                throw err;
            }
            catch (Throwable err) {
                this.close();
                throw new TransportException(this.uri, JGitText.get().remoteHungUpUnexpectedly, err);
            }
            try {
                if (!this.readAdvertisedRefs()) {
                    this.lsRefs(refSpecs, additionalPatterns2);
                }
            }
            catch (NoRemoteRepositoryException notFound) {
                String msgs = this.getMessages();
                TransportGitSsh.this.checkExecFailure(this.process.exitValue(), TransportGitSsh.this.getOptionUploadPack(), msgs);
                throw TransportGitSsh.this.cleanNotFound(notFound, msgs);
            }
        }

        @Override
        public void close() {
            block7: {
                this.endOut();
                if (this.process != null) {
                    this.process.destroy();
                }
                if (this.errorThread != null) {
                    try {
                        try {
                            this.errorThread.halt();
                        }
                        catch (InterruptedException interruptedException) {
                            this.errorThread = null;
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        this.errorThread = null;
                        throw throwable;
                    }
                    this.errorThread = null;
                }
            }
            super.close();
        }
    }

    class SshPushConnection
    extends BasePackPushConnection {
        private final Process process;
        private StreamCopyThread errorThread;

        SshPushConnection() throws TransportException {
            super(TransportGitSsh.this);
            try {
                this.process = TransportGitSsh.this.getSession().exec(TransportGitSsh.this.commandFor(TransportGitSsh.this.getOptionReceivePack()), TransportGitSsh.this.getTimeout());
                MessageWriter msg = new MessageWriter();
                this.setMessageWriter(msg);
                InputStream rpErr = this.process.getErrorStream();
                this.errorThread = new StreamCopyThread(rpErr, msg.getRawStream());
                this.errorThread.start();
                this.init(this.process.getInputStream(), this.process.getOutputStream());
            }
            catch (TransportException err) {
                try {
                    this.close();
                }
                catch (Exception rpErr) {
                    // empty catch block
                }
                throw err;
            }
            catch (Throwable err) {
                try {
                    this.close();
                }
                catch (Exception rpErr) {
                    // empty catch block
                }
                throw new TransportException(this.uri, JGitText.get().remoteHungUpUnexpectedly, err);
            }
            try {
                this.readAdvertisedRefs();
            }
            catch (NoRemoteRepositoryException notFound) {
                String msgs = this.getMessages();
                TransportGitSsh.this.checkExecFailure(this.process.exitValue(), TransportGitSsh.this.getOptionReceivePack(), msgs);
                throw TransportGitSsh.this.cleanNotFound(notFound, msgs);
            }
        }

        @Override
        public void close() {
            block7: {
                this.endOut();
                if (this.process != null) {
                    this.process.destroy();
                }
                if (this.errorThread != null) {
                    try {
                        try {
                            this.errorThread.halt();
                        }
                        catch (InterruptedException interruptedException) {
                            this.errorThread = null;
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        this.errorThread = null;
                        throw throwable;
                    }
                    this.errorThread = null;
                }
            }
            super.close();
        }
    }
}

