/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.FtpChannel;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.WalkFetchConnection;
import org.eclipse.jgit.transport.WalkPushConnection;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import org.eclipse.jgit.transport.WalkTransport;

public class TransportSftp
extends SshTransport
implements WalkTransport {
    static final TransportProtocol PROTO_SFTP = new TransportProtocol(){

        @Override
        public String getName() {
            return JGitText.get().transportProtoSFTP;
        }

        @Override
        public Set<String> getSchemes() {
            return Collections.singleton("sftp");
        }

        @Override
        public Set<TransportProtocol.URIishField> getRequiredFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.HOST, TransportProtocol.URIishField.PATH));
        }

        @Override
        public Set<TransportProtocol.URIishField> getOptionalFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.USER, TransportProtocol.URIishField.PASS, TransportProtocol.URIishField.PORT));
        }

        @Override
        public int getDefaultPort() {
            return 22;
        }

        @Override
        public Transport open(URIish uri2, Repository local, String remoteName) throws NotSupportedException {
            return new TransportSftp(local, uri2);
        }
    };

    TransportSftp(Repository local, URIish uri2) {
        super(local, uri2);
    }

    @Override
    public FetchConnection openFetch() throws TransportException {
        SftpObjectDB c2 = new SftpObjectDB(this.uri.getPath());
        WalkFetchConnection r = new WalkFetchConnection(this, c2);
        r.available(c2.readAdvertisedRefs());
        return r;
    }

    @Override
    public PushConnection openPush() throws TransportException {
        SftpObjectDB c2 = new SftpObjectDB(this.uri.getPath());
        WalkPushConnection r = new WalkPushConnection(this, c2);
        r.available(c2.readAdvertisedRefs());
        return r;
    }

    FtpChannel newSftp() throws IOException {
        FtpChannel channel2 = this.getSession().getFtpChannel();
        channel2.connect(this.getTimeout(), TimeUnit.SECONDS);
        return channel2;
    }

    class SftpObjectDB
    extends WalkRemoteObjectDatabase {
        private final String objectsPath;
        private FtpChannel ftp;

        SftpObjectDB(String path2) throws TransportException {
            if (path2.startsWith("/~")) {
                path2 = path2.substring(1);
            }
            if (path2.startsWith("~/")) {
                path2 = path2.substring(2);
            }
            try {
                this.ftp = TransportSftp.this.newSftp();
                this.ftp.cd(path2);
                this.ftp.cd("objects");
                this.objectsPath = this.ftp.pwd();
            }
            catch (FtpChannel.FtpException f2) {
                throw new TransportException(MessageFormat.format(JGitText.get().cannotEnterObjectsPath, path2, f2.getMessage()), f2);
            }
            catch (IOException ioe) {
                this.close();
                throw new TransportException(TransportSftp.this.uri, ioe.getMessage(), ioe);
            }
        }

        SftpObjectDB(SftpObjectDB parent, String p) throws TransportException {
            try {
                this.ftp = TransportSftp.this.newSftp();
                this.ftp.cd(parent.objectsPath);
                this.ftp.cd(p);
                this.objectsPath = this.ftp.pwd();
            }
            catch (FtpChannel.FtpException f2) {
                throw new TransportException(MessageFormat.format(JGitText.get().cannotEnterPathFromParent, p, parent.objectsPath, f2.getMessage()), f2);
            }
            catch (IOException ioe) {
                this.close();
                throw new TransportException(TransportSftp.this.uri, ioe.getMessage(), ioe);
            }
        }

        @Override
        URIish getURI() {
            return TransportSftp.this.uri.setPath(this.objectsPath);
        }

        @Override
        Collection<WalkRemoteObjectDatabase> getAlternates() throws IOException {
            try {
                return this.readAlternates("info/alternates");
            }
            catch (FileNotFoundException err) {
                return null;
            }
        }

        @Override
        WalkRemoteObjectDatabase openAlternate(String location) throws IOException {
            return new SftpObjectDB(this, location);
        }

        @Override
        Collection<String> getPackNames() throws IOException {
            ArrayList<String> packs = new ArrayList<String>();
            try {
                Collection<FtpChannel.DirEntry> list = this.ftp.ls("pack");
                Set files2 = list.stream().map(FtpChannel.DirEntry::getFilename).collect(Collectors.toSet());
                HashMap<String, Long> mtimes = new HashMap<String, Long>();
                for (FtpChannel.DirEntry ent : list) {
                    String in;
                    String n = ent.getFilename();
                    if (!n.startsWith("pack-") || !n.endsWith(".pack") || !files2.contains(in = n.substring(0, n.length() - 5) + ".idx")) continue;
                    mtimes.put(n, ent.getModifiedTime());
                    packs.add(n);
                }
                Collections.sort(packs, (o1, o2) -> ((Long)mtimes.get(o2)).compareTo((Long)mtimes.get(o1)));
            }
            catch (FtpChannel.FtpException f2) {
                throw new TransportException(MessageFormat.format(JGitText.get().cannotListPackPath, this.objectsPath, f2.getMessage()), f2);
            }
            return packs;
        }

        @Override
        WalkRemoteObjectDatabase.FileStream open(String path2) throws IOException {
            try {
                return new WalkRemoteObjectDatabase.FileStream(this.ftp.get(path2));
            }
            catch (FtpChannel.FtpException f2) {
                if (f2.getStatus() == 2) {
                    throw new FileNotFoundException(path2);
                }
                throw new TransportException(MessageFormat.format(JGitText.get().cannotGetObjectsPath, this.objectsPath, path2, f2.getMessage()), f2);
            }
        }

        @Override
        void deleteFile(String path2) throws IOException {
            try {
                this.ftp.delete(path2);
            }
            catch (FtpChannel.FtpException f2) {
                throw new TransportException(MessageFormat.format(JGitText.get().cannotDeleteObjectsPath, this.objectsPath, path2, f2.getMessage()), f2);
            }
            String dir = path2;
            int s2 = dir.lastIndexOf(47);
            while (s2 > 0) {
                try {
                    dir = dir.substring(0, s2);
                    this.ftp.rmdir(dir);
                    s2 = dir.lastIndexOf(47);
                }
                catch (IOException je) {
                    break;
                }
            }
        }

        @Override
        OutputStream writeFile(String path2, ProgressMonitor monitor, String monitorTask) throws IOException {
            IOException err = null;
            try {
                return this.ftp.put(path2);
            }
            catch (FileNotFoundException e2) {
                this.mkdir_p(path2);
            }
            catch (FtpChannel.FtpException je) {
                if (je.getStatus() == 2) {
                    this.mkdir_p(path2);
                }
                err = je;
            }
            if (err == null) {
                try {
                    return this.ftp.put(path2);
                }
                catch (IOException e3) {
                    err = e3;
                }
            }
            throw new TransportException(MessageFormat.format(JGitText.get().cannotWriteObjectsPath, this.objectsPath, path2, err.getMessage()), err);
        }

        @Override
        void writeFile(String path2, byte[] data2) throws IOException {
            String lock = path2 + ".lock";
            try {
                super.writeFile(lock, data2);
                try {
                    this.ftp.rename(lock, path2);
                }
                catch (IOException e2) {
                    throw new TransportException(MessageFormat.format(JGitText.get().cannotWriteObjectsPath, this.objectsPath, path2, e2.getMessage()), e2);
                }
            }
            catch (IOException err) {
                try {
                    this.ftp.rm(lock);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw err;
            }
        }

        private void mkdir_p(String path2) throws IOException {
            int s2 = path2.lastIndexOf(47);
            if (s2 <= 0) {
                return;
            }
            path2 = path2.substring(0, s2);
            IOException err = null;
            try {
                this.ftp.mkdir(path2);
                return;
            }
            catch (FileNotFoundException f2) {
                this.mkdir_p(path2);
            }
            catch (FtpChannel.FtpException je) {
                if (je.getStatus() == 2) {
                    this.mkdir_p(path2);
                }
                err = je;
            }
            if (err == null) {
                try {
                    this.ftp.mkdir(path2);
                    return;
                }
                catch (IOException e2) {
                    err = e2;
                }
            }
            throw new TransportException(MessageFormat.format(JGitText.get().cannotMkdirObjectPath, this.objectsPath, path2, err.getMessage()), err);
        }

        Map<String, Ref> readAdvertisedRefs() throws TransportException {
            TreeMap<String, Ref> avail = new TreeMap<String, Ref>();
            this.readPackedRefs(avail);
            this.readRef(avail, "../HEAD", "HEAD");
            this.readLooseRefs(avail, "../refs", "refs/");
            return avail;
        }

        private void readLooseRefs(TreeMap<String, Ref> avail, String dir, String prefix2) throws TransportException {
            Collection<FtpChannel.DirEntry> list;
            try {
                list = this.ftp.ls(dir);
            }
            catch (IOException e2) {
                throw new TransportException(MessageFormat.format(JGitText.get().cannotListObjectsPath, this.objectsPath, dir, e2.getMessage()), e2);
            }
            for (FtpChannel.DirEntry ent : list) {
                String n = ent.getFilename();
                if (".".equals(n) || "..".equals(n)) continue;
                String nPath = dir + "/" + n;
                if (ent.isDirectory()) {
                    this.readLooseRefs(avail, nPath, prefix2 + n + "/");
                    continue;
                }
                this.readRef(avail, nPath, prefix2 + n);
            }
        }

        private Ref readRef(TreeMap<String, Ref> avail, String path2, String name) throws TransportException {
            String line;
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (BufferedReader br = this.openReader(path2);){
                    line = br.readLine();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException noRef) {
                return null;
            }
            catch (IOException err) {
                throw new TransportException(MessageFormat.format(JGitText.get().cannotReadObjectsPath, this.objectsPath, path2, err.getMessage()), err);
            }
            if (line == null) {
                throw new TransportException(MessageFormat.format(JGitText.get().emptyRef, name));
            }
            if (line.startsWith("ref: ")) {
                String target = line.substring("ref: ".length());
                Ref r = avail.get(target);
                if (r == null) {
                    r = this.readRef(avail, "../" + target, target);
                }
                if (r == null) {
                    r = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, target, null);
                }
                r = new SymbolicRef(name, r);
                avail.put(r.getName(), r);
                return r;
            }
            if (ObjectId.isId(line)) {
                ObjectIdRef.Unpeeled r = new ObjectIdRef.Unpeeled(this.loose(avail.get(name)), name, ObjectId.fromString(line));
                avail.put(r.getName(), r);
                return r;
            }
            throw new TransportException(MessageFormat.format(JGitText.get().badRef, name, line));
        }

        private Ref.Storage loose(Ref r) {
            if (r != null && r.getStorage() == Ref.Storage.PACKED) {
                return Ref.Storage.LOOSE_PACKED;
            }
            return Ref.Storage.LOOSE;
        }

        @Override
        void close() {
            if (this.ftp != null) {
                try {
                    if (this.ftp.isConnected()) {
                        this.ftp.disconnect();
                    }
                }
                finally {
                    this.ftp = null;
                }
            }
        }
    }
}

