/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lib.Config;

public class UrlConfig {
    private static final String KEY_INSTEADOF = "insteadof";
    private static final String KEY_PUSHINSTEADOF = "pushinsteadof";
    private static final String SECTION_URL = "url";
    private final Config config;
    private Map<String, String> insteadOf;
    private Map<String, String> pushInsteadOf;

    public UrlConfig(Config config2) {
        this.config = config2;
    }

    public String replace(String url2) {
        if (this.insteadOf == null) {
            this.insteadOf = this.load(KEY_INSTEADOF);
        }
        return this.replace(url2, this.insteadOf);
    }

    public boolean hasPushReplacements() {
        if (this.pushInsteadOf == null) {
            this.pushInsteadOf = this.load(KEY_PUSHINSTEADOF);
        }
        return !this.pushInsteadOf.isEmpty();
    }

    public String replacePush(String url2) {
        if (this.pushInsteadOf == null) {
            this.pushInsteadOf = this.load(KEY_PUSHINSTEADOF);
        }
        return this.replace(url2, this.pushInsteadOf);
    }

    private Map<String, String> load(String key2) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (String url2 : this.config.getSubsections(SECTION_URL)) {
            String[] stringArray = this.config.getStringList(SECTION_URL, url2, key2);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String prefix2 = stringArray[n2];
                replacements.put(prefix2, url2);
                ++n2;
            }
        }
        return replacements;
    }

    private String replace(String uri2, Map<String, String> replacements) {
        Map.Entry<String, String> match2 = null;
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            if (match2 != null && ((String)match2.getKey()).length() > replacement.getKey().length() || !uri2.startsWith(replacement.getKey())) continue;
            match2 = replacement;
        }
        if (match2 != null) {
            return (String)match2.getValue() + uri2.substring(((String)match2.getKey()).length());
        }
        return uri2;
    }
}

