/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import org.eclipse.jgit.util.StringUtils;

public class UserAgent {
    private static volatile String userAgent = UserAgent.computeUserAgent();

    private static String computeUserAgent() {
        return UserAgent.clean("JGit/" + UserAgent.computeVersion());
    }

    private static String computeVersion() {
        String ver;
        Package pkg = UserAgent.class.getPackage();
        if (pkg != null && !StringUtils.isEmptyOrNull(ver = pkg.getImplementationVersion())) {
            return ver;
        }
        return "unknown";
    }

    static String clean(String s2) {
        s2 = s2.trim();
        StringBuilder b2 = new StringBuilder(s2.length());
        int i2 = 0;
        while (i2 < s2.length()) {
            block4: {
                char c2;
                block3: {
                    c2 = s2.charAt(i2);
                    if (c2 > ' ' && c2 < '\u007f') break block3;
                    if (b2.length() > 0 && b2.charAt(b2.length() - 1) == '.') break block4;
                    c2 = '.';
                }
                b2.append(c2);
            }
            ++i2;
        }
        return b2.length() > 0 ? b2.toString() : null;
    }

    public static String get() {
        return userAgent;
    }

    public static void set(String agent) {
        userAgent = StringUtils.isEmptyOrNull(agent) ? null : UserAgent.clean(agent);
    }

    private UserAgent() {
    }
}

