/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Arrays;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class UsernamePasswordCredentialsProvider
extends CredentialsProvider {
    private String username;
    private char[] password;

    public UsernamePasswordCredentialsProvider(String username, String password) {
        this(username, password.toCharArray());
    }

    public UsernamePasswordCredentialsProvider(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public boolean isInteractive() {
        return false;
    }

    @Override
    public boolean supports(CredentialItem ... items2) {
        CredentialItem[] credentialItemArray = items2;
        int n = items2.length;
        int n2 = 0;
        while (n2 < n) {
            CredentialItem i2 = credentialItemArray[n2];
            if (!(i2 instanceof CredentialItem.InformationalMessage || i2 instanceof CredentialItem.Username || i2 instanceof CredentialItem.Password || i2 instanceof CredentialItem.StringType && i2.getPromptText().equals("Password: "))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean get(URIish uri2, CredentialItem ... items2) throws UnsupportedCredentialItem {
        CredentialItem[] credentialItemArray = items2;
        int n = items2.length;
        int n2 = 0;
        while (n2 < n) {
            CredentialItem i2 = credentialItemArray[n2];
            if (!(i2 instanceof CredentialItem.InformationalMessage)) {
                if (i2 instanceof CredentialItem.Username) {
                    ((CredentialItem.Username)i2).setValue(this.username);
                } else if (i2 instanceof CredentialItem.Password) {
                    ((CredentialItem.Password)i2).setValue(this.password);
                } else if (i2 instanceof CredentialItem.StringType && i2.getPromptText().equals("Password: ")) {
                    ((CredentialItem.StringType)i2).setValue(new String(this.password));
                } else {
                    throw new UnsupportedCredentialItem(uri2, i2.getClass().getName() + ":" + i2.getPromptText());
                }
            }
            ++n2;
        }
        return true;
    }

    public void clear() {
        this.username = null;
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
            this.password = null;
        }
    }
}

