/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport.sshd;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.jgit.transport.sshd.ProxyData;
import org.eclipse.jgit.transport.sshd.ProxyDataFactory;

public class DefaultProxyDataFactory
implements ProxyDataFactory {
    @Override
    public ProxyData get(InetSocketAddress remoteAddress2) {
        try {
            List<Proxy> proxies = ProxySelector.getDefault().select(new URI("socket://" + remoteAddress2.getHostString()));
            ProxyData data2 = this.getData(proxies, Proxy.Type.SOCKS);
            if (data2 == null) {
                proxies = ProxySelector.getDefault().select(new URI(Proxy.Type.HTTP.name(), "//" + remoteAddress2.getHostString(), null));
                data2 = this.getData(proxies, Proxy.Type.HTTP);
            }
            return data2;
        }
        catch (URISyntaxException e2) {
            return null;
        }
    }

    private ProxyData getData(List<Proxy> proxies, Proxy.Type type2) {
        Proxy proxy = proxies.stream().filter(p -> type2 == p.type()).findFirst().orElse(null);
        if (proxy == null) {
            return null;
        }
        SocketAddress address = proxy.address();
        if (!(address instanceof InetSocketAddress)) {
            return null;
        }
        switch (type2) {
            case HTTP: {
                return new ProxyData(proxy);
            }
            case SOCKS: {
                return new ProxyData(proxy);
            }
        }
        return null;
    }
}

