/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport.sshd;

import java.nio.file.Path;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.security.auth.DestroyFailedException;
import org.eclipse.jgit.transport.sshd.KeyCache;

public class JGitKeyCache
implements KeyCache {
    private AtomicReference<Map<Path, KeyPair>> cache = new AtomicReference(new ConcurrentHashMap());

    @Override
    public KeyPair get(Path path2, Function<? super Path, ? extends KeyPair> loader) {
        return this.cache.get().computeIfAbsent(path2, loader);
    }

    @Override
    public void close() {
        Map map2 = this.cache.getAndSet(null);
        if (map2 == null) {
            return;
        }
        for (KeyPair k2 : map2.values()) {
            PrivateKey p = k2.getPrivate();
            try {
                p.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                // empty catch block
            }
        }
        map2.clear();
    }
}

