/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport.sshd;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.forward.ExplicitPortForwardingTracker;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.functors.IOFunction;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.sftp.SftpModuleProperties;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.common.SftpException;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import org.eclipse.jgit.internal.transport.sshd.AuthenticationCanceledException;
import org.eclipse.jgit.internal.transport.sshd.AuthenticationLogger;
import org.eclipse.jgit.internal.transport.sshd.JGitSshClient;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.FtpChannel;
import org.eclipse.jgit.transport.RemoteSession2;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.sshd.SessionCloseListener;
import org.eclipse.jgit.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshdSession
implements RemoteSession2 {
    private static final Logger LOG = LoggerFactory.getLogger(SshdSession.class);
    private static final Pattern SHORT_SSH_FORMAT = Pattern.compile("[-\\w.]+(?:@[-\\w.]+)?(?::\\d+)?");
    private static final int MAX_DEPTH = 10;
    private final CopyOnWriteArrayList<SessionCloseListener> listeners = new CopyOnWriteArrayList();
    private final URIish uri;
    private SshClient client;
    private ClientSession session;

    SshdSession(URIish uri2, Supplier<SshClient> clientFactory) {
        this.uri = uri2;
        this.client = clientFactory.get();
    }

    void connect(Duration timeout2) throws IOException {
        if (!this.client.isStarted()) {
            this.client.start();
        }
        try {
            this.session = this.connect(this.uri, Collections.emptyList(), future -> this.notifyCloseListeners(), timeout2, 10);
        }
        catch (IOException e2) {
            this.disconnect(e2);
            throw e2;
        }
    }

    private ClientSession connect(URIish target, List<URIish> jumps, SshFutureListener<CloseFuture> listener, Duration timeout2, int depth) throws IOException {
        if (--depth < 0) {
            throw new IOException(MessageFormat.format(SshdText.get().proxyJumpAbort, target));
        }
        HostConfigEntry hostConfig = this.getHostConfig(target.getUser(), target.getHost(), target.getPort());
        String host2 = hostConfig.getHostName();
        int port2 = hostConfig.getPort();
        List<URIish> hops = this.determineHops(jumps, hostConfig, target.getHost());
        ClientSession resultSession = null;
        ClientSession proxySession = null;
        ExplicitPortForwardingTracker portForward = null;
        AuthenticationLogger authLog = null;
        try {
            int timeoutInSec;
            if (!hops.isEmpty()) {
                URIish hop = hops.remove(0);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connecting to jump host {}", (Object)hop);
                }
                proxySession = this.connect(hop, hops, null, timeout2, depth);
            }
            AttributeRepository context = null;
            if (proxySession != null) {
                SshdSocketAddress remoteAddress2 = new SshdSocketAddress(host2, port2);
                portForward = proxySession.createLocalPortForwardingTracker(SshdSocketAddress.LOCALHOST_ADDRESS, remoteAddress2);
                context = AttributeRepository.ofKeyValuePair(JGitSshClient.LOCAL_FORWARD_ADDRESS, portForward.getBoundAddress());
            }
            resultSession = this.connect(hostConfig, context, (timeoutInSec = OpenSshConfigFile.timeSpec(hostConfig.getProperty("ConnectTimeout"))) > 0 ? Duration.ofSeconds(timeoutInSec) : timeout2);
            if (proxySession != null) {
                ExplicitPortForwardingTracker tracker = portForward;
                ClientSession pSession = proxySession;
                resultSession.addCloseFutureListener(future -> {
                    IoUtils.closeQuietly((Closeable)tracker);
                    String sessionName = pSession.toString();
                    try {
                        pSession.close();
                    }
                    catch (IOException e2) {
                        LOG.error(MessageFormat.format(SshdText.get().sshProxySessionCloseFailed, sessionName), e2);
                    }
                });
                portForward = null;
                proxySession = null;
            }
            if (listener != null) {
                resultSession.addCloseFutureListener(listener);
            }
            authLog = new AuthenticationLogger(resultSession);
            resultSession.auth().verify(resultSession.getAuthTimeout());
            ClientSession clientSession = resultSession;
            return clientSession;
        }
        catch (IOException e2) {
            this.close(portForward, e2);
            this.close(proxySession, e2);
            this.close(resultSession, e2);
            if (e2 instanceof SshException && ((SshException)e2).getDisconnectCode() == 14) {
                String message = MessageFormat.format(SshdText.get().loginDenied, host2, Integer.toString(port2));
                throw new TransportException(target, this.withAuthLog(message, authLog), e2);
            }
            if (e2 instanceof SshException && e2.getCause() instanceof AuthenticationCanceledException) {
                String message = e2.getCause().getMessage();
                throw new TransportException(target, this.withAuthLog(message, authLog), e2.getCause());
            }
            throw e2;
        }
        finally {
            if (authLog != null) {
                authLog.clear();
            }
        }
    }

    private String withAuthLog(String message, AuthenticationLogger authLog) {
        String log2;
        if (authLog != null && !(log2 = String.join((CharSequence)System.lineSeparator(), authLog.getLog())).isEmpty()) {
            return message + System.lineSeparator() + log2;
        }
        return message;
    }

    private ClientSession connect(HostConfigEntry config2, AttributeRepository context, Duration timeout2) throws IOException {
        ConnectFuture connected = this.client.connect(config2, context, null);
        long timeoutMillis = timeout2.toMillis();
        connected = timeoutMillis <= 0L ? (ConnectFuture)connected.verify() : (ConnectFuture)connected.verify(timeoutMillis);
        return (ClientSession)connected.getSession();
    }

    private void close(Closeable toClose, Throwable error2) {
        if (toClose != null) {
            try {
                toClose.close();
            }
            catch (IOException e2) {
                error2.addSuppressed(e2);
            }
        }
    }

    private HostConfigEntry getHostConfig(String username, String host2, int port2) throws IOException {
        HostConfigEntry entry = this.client.getHostConfigEntryResolver().resolveEffectiveHost(host2, port2, null, username, null, null);
        if (entry == null) {
            if (SshdSocketAddress.isIPv6Address(host2)) {
                return new HostConfigEntry("", host2, port2, username);
            }
            return new HostConfigEntry(host2, host2, port2, username);
        }
        return entry;
    }

    private List<URIish> determineHops(List<URIish> currentHops, HostConfigEntry hostConfig, String host2) throws IOException {
        String jumpHosts;
        if (currentHops.isEmpty() && !StringUtils.isEmptyOrNull(jumpHosts = hostConfig.getProperty("ProxyJump")) && !"none".equals(jumpHosts)) {
            try {
                return this.parseProxyJump(jumpHosts);
            }
            catch (URISyntaxException e2) {
                throw new IOException(MessageFormat.format(SshdText.get().configInvalidProxyJump, host2, jumpHosts), e2);
            }
        }
        return currentHops;
    }

    private List<URIish> parseProxyJump(String proxyJump) throws URISyntaxException {
        String[] hops = proxyJump.split(",");
        ArrayList<URIish> result2 = new ArrayList<URIish>();
        String[] stringArray = hops;
        int n = hops.length;
        int n2 = 0;
        while (n2 < n) {
            URIish to;
            Object hop = stringArray[n2];
            if (SHORT_SSH_FORMAT.matcher((CharSequence)(hop = ((String)hop).trim())).matches()) {
                hop = "ssh://" + (String)hop;
            }
            if (!"ssh".equalsIgnoreCase((to = new URIish((String)hop)).getScheme())) {
                throw new URISyntaxException((String)hop, SshdText.get().configProxyJumpNotSsh);
            }
            if (!StringUtils.isEmptyOrNull(to.getPath())) {
                throw new URISyntaxException((String)hop, SshdText.get().configProxyJumpWithPath);
            }
            result2.add(to);
            ++n2;
        }
        return result2;
    }

    public void addCloseListener(@NonNull SessionCloseListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeCloseListener(@NonNull SessionCloseListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyCloseListeners() {
        for (SessionCloseListener l : this.listeners) {
            try {
                l.sessionClosed(this);
            }
            catch (RuntimeException e2) {
                LOG.warn(SshdText.get().closeListenerFailed, e2);
            }
        }
    }

    @Override
    public Process exec(String commandName, int timeout2) throws IOException {
        return this.exec(commandName, Collections.emptyMap(), timeout2);
    }

    @Override
    public Process exec(String commandName, Map<String, String> environment2, int timeout2) throws IOException {
        ChannelExec exec = this.session.createExecChannel(commandName, null, environment2);
        if (timeout2 <= 0) {
            try {
                exec.open().verify();
            }
            catch (IOException | RuntimeException e2) {
                exec.close(true);
                throw e2;
            }
        }
        try {
            exec.open().verify(TimeUnit.SECONDS.toMillis(timeout2));
        }
        catch (IOException | RuntimeException e3) {
            exec.close(true);
            throw new IOException(MessageFormat.format(SshdText.get().sshCommandTimeout, commandName, timeout2), e3);
        }
        return new SshdExecProcess(exec, commandName);
    }

    @Override
    @NonNull
    public FtpChannel getFtpChannel() {
        return new SshdFtpChannel();
    }

    @Override
    public void disconnect() {
        this.disconnect(null);
    }

    private void disconnect(Throwable reason) {
        try {
            try {
                if (this.session != null) {
                    this.session.close();
                    this.session = null;
                }
            }
            catch (IOException e2) {
                if (reason != null) {
                    reason.addSuppressed(e2);
                } else {
                    LOG.error(SshdText.get().sessionCloseFailed, e2);
                }
                this.client.stop();
                this.client = null;
            }
        }
        finally {
            this.client.stop();
            this.client = null;
        }
    }

    private static class SshdExecProcess
    extends Process {
        private final ChannelExec channel;
        private final String commandName;

        public SshdExecProcess(ChannelExec channel2, String commandName) {
            this.channel = channel2;
            this.commandName = commandName;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.channel.getInvertedIn();
        }

        @Override
        public InputStream getInputStream() {
            return this.channel.getInvertedOut();
        }

        @Override
        public InputStream getErrorStream() {
            return this.channel.getInvertedErr();
        }

        @Override
        public int waitFor() throws InterruptedException {
            if (this.waitFor(-1L, TimeUnit.MILLISECONDS)) {
                return this.exitValue();
            }
            return -1;
        }

        @Override
        public boolean waitFor(long timeout2, TimeUnit unit) throws InterruptedException {
            long millis = timeout2 >= 0L ? unit.toMillis(timeout2) : -1L;
            return this.channel.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), millis).contains((Object)ClientChannelEvent.CLOSED);
        }

        @Override
        public int exitValue() {
            Integer exitCode = this.channel.getExitStatus();
            if (exitCode == null) {
                throw new IllegalThreadStateException(MessageFormat.format(SshdText.get().sshProcessStillRunning, this.commandName));
            }
            return exitCode;
        }

        @Override
        public void destroy() {
            if (this.channel.isOpen()) {
                this.channel.close(false);
            }
        }
    }

    private class SshdFtpChannel
    implements FtpChannel {
        private SftpClient ftp;
        private String cwd = "";

        private SshdFtpChannel() {
        }

        @Override
        public void connect(int timeout2, TimeUnit unit) throws IOException {
            if (timeout2 <= 0) {
                SftpModuleProperties.SFTP_CHANNEL_OPEN_TIMEOUT.set(SshdSession.this.session, Duration.ofMillis(Long.MAX_VALUE));
            } else {
                SftpModuleProperties.SFTP_CHANNEL_OPEN_TIMEOUT.set(SshdSession.this.session, Duration.ofMillis(unit.toMillis(timeout2)));
            }
            this.ftp = SftpClientFactory.instance().createSftpClient(SshdSession.this.session);
            try {
                this.cd(this.cwd);
            }
            catch (IOException e2) {
                this.ftp.close();
            }
        }

        @Override
        public void disconnect() {
            try {
                this.ftp.close();
            }
            catch (IOException e2) {
                LOG.error(SshdText.get().ftpCloseFailed, e2);
            }
        }

        @Override
        public boolean isConnected() {
            return SshdSession.this.session.isAuthenticated() && this.ftp.isOpen();
        }

        private String absolute(String path2) {
            if (path2.isEmpty()) {
                return this.cwd;
            }
            if (path2.charAt(0) != '/') {
                if (this.cwd.charAt(this.cwd.length() - 1) == '/') {
                    return this.cwd + path2;
                }
                return this.cwd + "/" + path2;
            }
            return path2;
        }

        private <T> T map(IOFunction<Void, T> op) throws IOException {
            try {
                return op.apply(null);
            }
            catch (IOException e2) {
                if (e2 instanceof SftpException) {
                    throw new FtpChannel.FtpException(e2.getLocalizedMessage(), ((SftpException)e2).getStatus(), e2);
                }
                throw e2;
            }
        }

        @Override
        public void cd(String path2) throws IOException {
            this.cwd = this.map(x -> this.ftp.canonicalPath(this.absolute(path2)));
            if (this.cwd.isEmpty()) {
                this.cwd = String.valueOf(this.cwd) + "/";
            }
        }

        @Override
        public String pwd() throws IOException {
            return this.cwd;
        }

        @Override
        public Collection<FtpChannel.DirEntry> ls(String path2) throws IOException {
            return this.map(x -> {
                ArrayList<2> result2 = new ArrayList<2>();
                for (final SftpClient.DirEntry remote : this.ftp.readDir(this.absolute(path2))) {
                    result2.add(new FtpChannel.DirEntry(){

                        @Override
                        public String getFilename() {
                            return remote.getFilename();
                        }

                        @Override
                        public long getModifiedTime() {
                            return remote.getAttributes().getModifyTime().toMillis();
                        }

                        @Override
                        public boolean isDirectory() {
                            return remote.getAttributes().isDirectory();
                        }
                    });
                }
                return result2;
            });
        }

        @Override
        public void rmdir(String path2) throws IOException {
            this.map(x -> {
                this.ftp.rmdir(this.absolute(path2));
                return null;
            });
        }

        @Override
        public void mkdir(String path2) throws IOException {
            this.map(x -> {
                this.ftp.mkdir(this.absolute(path2));
                return null;
            });
        }

        @Override
        public InputStream get(String path2) throws IOException {
            return this.map(x -> this.ftp.read(this.absolute(path2)));
        }

        @Override
        public OutputStream put(String path2) throws IOException {
            return this.map(x -> this.ftp.write(this.absolute(path2)));
        }

        @Override
        public void rm(String path2) throws IOException {
            this.map(x -> {
                this.ftp.remove(this.absolute(path2));
                return null;
            });
        }

        @Override
        public void rename(String from2, String to) throws IOException {
            this.map(x -> {
                block2: {
                    String src = this.absolute(from2);
                    String dest = this.absolute(to);
                    try {
                        this.ftp.rename(src, dest, SftpClient.CopyMode.Atomic, SftpClient.CopyMode.Overwrite);
                    }
                    catch (UnsupportedOperationException e2) {
                        if (src.equals(dest)) break block2;
                        this.delete(dest);
                        this.ftp.rename(src, dest);
                    }
                }
                return null;
            });
        }
    }
}

