/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport.sshd;

import java.io.File;
import java.nio.file.Path;
import java.security.KeyPair;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshConfigStore;
import org.eclipse.jgit.transport.sshd.KeyCache;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;
import org.eclipse.jgit.transport.sshd.ProxyDataFactory;
import org.eclipse.jgit.transport.sshd.ServerKeyDatabase;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.eclipse.jgit.transport.sshd.agent.ConnectorFactory;
import org.eclipse.jgit.util.StringUtils;

public final class SshdSessionFactoryBuilder {
    private final State state = new State();

    public SshdSessionFactoryBuilder setProxyDataFactory(ProxyDataFactory proxyDataFactory) {
        this.state.proxyDataFactory = proxyDataFactory;
        return this;
    }

    public SshdSessionFactoryBuilder setHomeDirectory(File homeDirectory) {
        this.state.homeDirectory = homeDirectory;
        return this;
    }

    public SshdSessionFactoryBuilder setSshDirectory(File sshDirectory) {
        this.state.sshDirectory = sshDirectory;
        return this;
    }

    public SshdSessionFactoryBuilder setPreferredAuthentications(String authentications) {
        this.state.preferredAuthentications = authentications;
        return this;
    }

    public SshdSessionFactoryBuilder setConfigFile(Function<File, File> supplier) {
        this.state.configFileFinder = supplier;
        return this;
    }

    public SshdSessionFactoryBuilder setConfigStoreFactory(ConfigStoreFactory factory2) {
        this.state.configFactory = factory2;
        return this;
    }

    public SshdSessionFactoryBuilder setDefaultKnownHostsFiles(Function<File, List<Path>> supplier) {
        this.state.knownHostsFileFinder = supplier;
        return this;
    }

    public SshdSessionFactoryBuilder setDefaultIdentities(Function<File, List<Path>> supplier) {
        this.state.defaultKeyFileFinder = supplier;
        return this;
    }

    public SshdSessionFactoryBuilder setDefaultKeysProvider(Function<File, Iterable<KeyPair>> provider2) {
        this.state.defaultKeysProvider = provider2;
        return this;
    }

    public SshdSessionFactoryBuilder setKeyPasswordProvider(Function<CredentialsProvider, KeyPasswordProvider> factory2) {
        this.state.passphraseProviderFactory = factory2;
        return this;
    }

    public SshdSessionFactoryBuilder setServerKeyDatabase(BiFunction<File, File, ServerKeyDatabase> factory2) {
        this.state.serverKeyDatabaseCreator = factory2;
        return this;
    }

    public SshdSessionFactoryBuilder setConnectorFactory(ConnectorFactory factory2) {
        this.state.connectorFactory = factory2;
        this.state.connectorFactorySet = true;
        return this;
    }

    public SshdSessionFactoryBuilder withDefaultConnectorFactory() {
        this.state.connectorFactory = null;
        this.state.connectorFactorySet = false;
        return this;
    }

    public SshdSessionFactory build(KeyCache cache2) {
        return this.state.copy().build(cache2);
    }

    @FunctionalInterface
    public static interface ConfigStoreFactory {
        public SshConfigStore create(@NonNull File var1, File var2, String var3);
    }

    private static class State {
        ProxyDataFactory proxyDataFactory;
        File homeDirectory;
        File sshDirectory;
        String preferredAuthentications;
        Function<File, File> configFileFinder;
        ConfigStoreFactory configFactory;
        Function<CredentialsProvider, KeyPasswordProvider> passphraseProviderFactory;
        Function<File, List<Path>> knownHostsFileFinder;
        Function<File, List<Path>> defaultKeyFileFinder;
        Function<File, Iterable<KeyPair>> defaultKeysProvider;
        BiFunction<File, File, ServerKeyDatabase> serverKeyDatabaseCreator;
        ConnectorFactory connectorFactory;
        boolean connectorFactorySet;

        private State() {
        }

        State copy() {
            State c2 = new State();
            c2.proxyDataFactory = this.proxyDataFactory;
            c2.homeDirectory = this.homeDirectory;
            c2.sshDirectory = this.sshDirectory;
            c2.preferredAuthentications = this.preferredAuthentications;
            c2.configFileFinder = this.configFileFinder;
            c2.configFactory = this.configFactory;
            c2.passphraseProviderFactory = this.passphraseProviderFactory;
            c2.knownHostsFileFinder = this.knownHostsFileFinder;
            c2.defaultKeyFileFinder = this.defaultKeyFileFinder;
            c2.defaultKeysProvider = this.defaultKeysProvider;
            c2.serverKeyDatabaseCreator = this.serverKeyDatabaseCreator;
            c2.connectorFactory = this.connectorFactory;
            c2.connectorFactorySet = this.connectorFactorySet;
            return c2;
        }

        SshdSessionFactory build(KeyCache cache2) {
            SessionFactory factory2 = new SessionFactory(cache2, this.proxyDataFactory);
            factory2.setHomeDirectory(this.homeDirectory);
            factory2.setSshDirectory(this.sshDirectory);
            return factory2;
        }

        private class SessionFactory
        extends SshdSessionFactory {
            public SessionFactory(KeyCache cache2, ProxyDataFactory proxyDataFactory) {
                super(cache2, proxyDataFactory);
            }

            @Override
            protected File getSshConfig(File sshDir) {
                if (State.this.configFileFinder != null) {
                    return State.this.configFileFinder.apply(sshDir);
                }
                return super.getSshConfig(sshDir);
            }

            @Override
            protected List<Path> getDefaultKnownHostsFiles(File sshDir) {
                if (State.this.knownHostsFileFinder != null) {
                    List<Path> result2 = State.this.knownHostsFileFinder.apply(sshDir);
                    return result2 == null ? Collections.emptyList() : result2;
                }
                return super.getDefaultKnownHostsFiles(sshDir);
            }

            @Override
            protected List<Path> getDefaultIdentities(File sshDir) {
                if (State.this.defaultKeyFileFinder != null) {
                    List<Path> result2 = State.this.defaultKeyFileFinder.apply(sshDir);
                    return result2 == null ? Collections.emptyList() : result2;
                }
                return super.getDefaultIdentities(sshDir);
            }

            @Override
            protected String getDefaultPreferredAuthentications() {
                if (!StringUtils.isEmptyOrNull(State.this.preferredAuthentications)) {
                    return State.this.preferredAuthentications;
                }
                return super.getDefaultPreferredAuthentications();
            }

            @Override
            protected Iterable<KeyPair> getDefaultKeys(File sshDir) {
                if (State.this.defaultKeysProvider != null) {
                    Iterable<KeyPair> result2 = State.this.defaultKeysProvider.apply(sshDir);
                    return result2 == null ? Collections.emptyList() : result2;
                }
                return super.getDefaultKeys(sshDir);
            }

            @Override
            protected KeyPasswordProvider createKeyPasswordProvider(CredentialsProvider provider2) {
                KeyPasswordProvider result2;
                if (State.this.passphraseProviderFactory != null && (result2 = State.this.passphraseProviderFactory.apply(provider2)) != null) {
                    return result2;
                }
                return super.createKeyPasswordProvider(provider2);
            }

            @Override
            protected ServerKeyDatabase createServerKeyDatabase(File homeDir, File sshDir) {
                ServerKeyDatabase result2;
                if (State.this.serverKeyDatabaseCreator != null && (result2 = State.this.serverKeyDatabaseCreator.apply(homeDir, sshDir)) != null) {
                    return result2;
                }
                return super.createServerKeyDatabase(homeDir, sshDir);
            }

            @Override
            protected SshConfigStore createSshConfigStore(File homeDir, File configFile, String localUserName) {
                if (State.this.configFactory != null) {
                    return State.this.configFactory.create(homeDir, configFile, localUserName);
                }
                return super.createSshConfigStore(homeDir, configFile, localUserName);
            }

            @Override
            protected ConnectorFactory getConnectorFactory() {
                if (State.this.connectorFactorySet) {
                    return State.this.connectorFactory;
                }
                return super.getConnectorFactory();
            }
        }
    }
}

