/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport.sshd.agent;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Objects;
import org.apache.sshd.agent.SshAgentConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.sshd.agent.Connector;

public abstract class AbstractConnector
implements Connector {
    private static final int MIN_REPLY_LENGTH = 8192;
    protected static final int DEFAULT_MAX_REPLY_LENGTH = 262144;
    private final int maxReplyLength;

    protected AbstractConnector() {
        this(262144);
    }

    protected AbstractConnector(int maxReplyLength) {
        if (maxReplyLength < 8192) {
            throw new IllegalArgumentException("Maximum payload length too small");
        }
        this.maxReplyLength = maxReplyLength;
    }

    protected int getMaximumMessageLength() {
        return this.maxReplyLength;
    }

    protected void prepareMessage(byte command2, byte[] message) throws IllegalArgumentException {
        Objects.requireNonNull(message);
        if (message.length < 5) {
            throw new IllegalArgumentException("Message buffer for " + SshAgentConstants.getCommandMessageName(command2) + " must have at least 5 bytes; have only " + message.length);
        }
        BufferUtils.putUInt(message.length - 4, message);
        message[4] = command2;
    }

    protected int toLength(byte command2, byte[] length) throws IOException {
        long l = BufferUtils.getUInt(length);
        if (l <= 0L || l > (long)(this.maxReplyLength - 4)) {
            throw new SshException(MessageFormat.format(SshdText.get().sshAgentReplyLengthError, Long.toString(l), SshAgentConstants.getCommandMessageName(command2)));
        }
        return (int)l;
    }
}

