/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.attributes.AttributesNode;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.Paths;

public abstract class AbstractTreeIterator {
    protected static final int DEFAULT_PATH_SIZE = 128;
    protected static final byte[] zeroid = new byte[20];
    public final AbstractTreeIterator parent;
    AbstractTreeIterator matches;
    protected AttributesNode attributesNode;
    int matchShift;
    protected int mode;
    protected byte[] path;
    protected final int pathOffset;
    protected int pathLen;

    protected AbstractTreeIterator() {
        this.parent = null;
        this.path = new byte[128];
        this.pathOffset = 0;
    }

    protected AbstractTreeIterator(String prefix2) {
        this.parent = null;
        if (prefix2 != null && prefix2.length() > 0) {
            ByteBuffer b2 = StandardCharsets.UTF_8.encode(CharBuffer.wrap(prefix2));
            this.pathLen = b2.limit();
            this.path = new byte[Math.max(128, this.pathLen + 1)];
            b2.get(this.path, 0, this.pathLen);
            if (this.path[this.pathLen - 1] != 47) {
                this.path[this.pathLen++] = 47;
            }
            this.pathOffset = this.pathLen;
        } else {
            this.path = new byte[128];
            this.pathOffset = 0;
        }
    }

    protected AbstractTreeIterator(byte[] prefix2) {
        this.parent = null;
        if (prefix2 != null && prefix2.length > 0) {
            this.pathLen = prefix2.length;
            this.path = new byte[Math.max(128, this.pathLen + 1)];
            System.arraycopy(prefix2, 0, this.path, 0, this.pathLen);
            if (this.path[this.pathLen - 1] != 47) {
                this.path[this.pathLen++] = 47;
            }
            this.pathOffset = this.pathLen;
        } else {
            this.path = new byte[128];
            this.pathOffset = 0;
        }
    }

    protected AbstractTreeIterator(AbstractTreeIterator p) {
        this.parent = p;
        this.path = p.path;
        this.pathOffset = p.pathLen + 1;
        if (this.pathOffset > this.path.length) {
            this.growPath(p.pathLen);
        }
        this.path[this.pathOffset - 1] = 47;
    }

    protected AbstractTreeIterator(AbstractTreeIterator p, byte[] childPath, int childPathOffset) {
        this.parent = p;
        this.path = childPath;
        this.pathOffset = childPathOffset;
    }

    protected void growPath(int len2) {
        this.setPathCapacity(this.path.length << 1, len2);
    }

    protected void ensurePathCapacity(int capacity, int len2) {
        int current;
        if (this.path.length >= capacity) {
            return;
        }
        byte[] o = this.path;
        int newCapacity = current = o.length;
        while (newCapacity < capacity && newCapacity > 0) {
            newCapacity <<= 1;
        }
        this.setPathCapacity(newCapacity, len2);
    }

    private void setPathCapacity(int capacity, int len2) {
        byte[] o = this.path;
        byte[] n = new byte[capacity];
        System.arraycopy(o, 0, n, 0, len2);
        AbstractTreeIterator p = this;
        while (p != null && p.path == o) {
            p.path = n;
            p = p.parent;
        }
    }

    public int pathCompare(AbstractTreeIterator p) {
        return this.pathCompare(p, p.mode);
    }

    int pathCompare(AbstractTreeIterator p, int pMode) {
        int cPos = AbstractTreeIterator.alreadyMatch(this, p);
        return this.pathCompare(p.path, cPos, p.pathLen, pMode, cPos);
    }

    public boolean findFile(String name) throws CorruptObjectException {
        return this.findFile(Constants.encode(name));
    }

    public boolean findFile(byte[] name) throws CorruptObjectException {
        while (!this.eof()) {
            int cmp = this.pathCompare(name, 0, name.length, 0, this.pathOffset);
            if (cmp == 0) {
                return true;
            }
            if (cmp > 0) {
                return false;
            }
            this.next(1);
        }
        return false;
    }

    public int pathCompare(byte[] buf, int pos, int end2, int pathMode) {
        return this.pathCompare(buf, pos, end2, pathMode, 0);
    }

    private int pathCompare(byte[] b2, int bPos, int bEnd, int bMode, int aPos) {
        return Paths.compare(this.path, aPos, this.pathLen, this.mode, b2, bPos, bEnd, bMode);
    }

    private static int alreadyMatch(AbstractTreeIterator a2, AbstractTreeIterator b2) {
        while (true) {
            AbstractTreeIterator ap = a2.parent;
            AbstractTreeIterator bp = b2.parent;
            if (ap == null || bp == null) {
                return 0;
            }
            if (ap.matches == bp.matches) {
                return a2.pathOffset;
            }
            a2 = ap;
            b2 = bp;
        }
    }

    public boolean idEqual(AbstractTreeIterator otherIterator) {
        return ObjectId.equals(this.idBuffer(), this.idOffset(), otherIterator.idBuffer(), otherIterator.idOffset());
    }

    public abstract boolean hasId();

    public ObjectId getEntryObjectId() {
        return ObjectId.fromRaw(this.idBuffer(), this.idOffset());
    }

    public void getEntryObjectId(MutableObjectId out2) {
        out2.fromRaw(this.idBuffer(), this.idOffset());
    }

    public FileMode getEntryFileMode() {
        return FileMode.fromBits(this.mode);
    }

    public int getEntryRawMode() {
        return this.mode;
    }

    public String getEntryPathString() {
        return TreeWalk.pathOf(this);
    }

    public byte[] getEntryPathBuffer() {
        return this.path;
    }

    public int getEntryPathLength() {
        return this.pathLen;
    }

    public int getEntryPathHashCode() {
        int hash = 0;
        int i2 = Math.max(0, this.pathLen - 16);
        while (i2 < this.pathLen) {
            byte c2 = this.path[i2];
            if (c2 != 32) {
                hash = (hash >>> 2) + (c2 << 24);
            }
            ++i2;
        }
        return hash;
    }

    public abstract byte[] idBuffer();

    public abstract int idOffset();

    public abstract AbstractTreeIterator createSubtreeIterator(ObjectReader var1) throws IncorrectObjectTypeException, IOException;

    public EmptyTreeIterator createEmptyTreeIterator() {
        return new EmptyTreeIterator(this);
    }

    public AbstractTreeIterator createSubtreeIterator(ObjectReader reader2, MutableObjectId idBuffer) throws IncorrectObjectTypeException, IOException {
        return this.createSubtreeIterator(reader2);
    }

    public void reset() throws CorruptObjectException {
        while (!this.first()) {
            this.back(1);
        }
    }

    public abstract boolean first();

    public abstract boolean eof();

    public abstract void next(int var1) throws CorruptObjectException;

    public abstract void back(int var1) throws CorruptObjectException;

    public void skip() throws CorruptObjectException {
        this.next(1);
    }

    public void stopWalk() {
    }

    protected boolean needsStopWalk() {
        return false;
    }

    public int getNameLength() {
        return this.pathLen - this.pathOffset;
    }

    public int getNameOffset() {
        return this.pathOffset;
    }

    public void getName(byte[] buffer, int offset) {
        System.arraycopy(this.path, this.pathOffset, buffer, offset, this.pathLen - this.pathOffset);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getEntryPathString() + "]";
    }

    public boolean isWorkTree() {
        return false;
    }
}

