/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.time.Instant;
import java.util.Comparator;

class InstantComparator
implements Comparator<Instant> {
    InstantComparator() {
    }

    @Override
    public int compare(Instant a2, Instant b2) {
        return this.compare(a2, b2, false);
    }

    public int compare(Instant a2, Instant b2, boolean forceSecondsOnly) {
        long bSeconds;
        long aSeconds = a2.getEpochSecond();
        int result2 = Long.compare(aSeconds, bSeconds = b2.getEpochSecond());
        if (result2 != 0) {
            return result2;
        }
        int aSubSecond = a2.getNano();
        int bSubSecond = b2.getNano();
        if (forceSecondsOnly || aSubSecond == 0 || bSubSecond == 0) {
            return 0;
        }
        if (aSubSecond != bSubSecond) {
            int aSubMillis = aSubSecond % 1000000;
            int bSubMillis = bSubSecond % 1000000;
            if (aSubMillis == 0) {
                bSubSecond -= bSubMillis;
            } else if (bSubMillis == 0) {
                aSubSecond -= aSubMillis;
            } else {
                int aSubMicros = aSubSecond % 1000;
                int bSubMicros = bSubSecond % 1000;
                if (aSubMicros == 0) {
                    bSubSecond -= bSubMicros;
                } else if (bSubMicros == 0) {
                    aSubSecond -= aSubMicros;
                }
            }
        }
        return Integer.compare(aSubSecond, bSubSecond);
    }
}

