/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.IOException;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;

public class NameConflictTreeWalk
extends TreeWalk {
    private static final int TREE_MODE = FileMode.TREE.getBits();
    private boolean allTreesNamesMatchFastMinRef;
    private AbstractTreeIterator dfConflict;

    public NameConflictTreeWalk(Repository repo) {
        super(repo);
    }

    public NameConflictTreeWalk(@Nullable Repository repo, ObjectReader or) {
        super(repo, or);
    }

    public NameConflictTreeWalk(ObjectReader or) {
        super(or);
    }

    @Override
    AbstractTreeIterator min() throws CorruptObjectException {
        AbstractTreeIterator minRef;
        block4: {
            block0: while (true) {
                minRef = this.fastMin();
                if (this.allTreesNamesMatchFastMinRef) {
                    return minRef;
                }
                if (!NameConflictTreeWalk.isTree(minRef)) break block4;
                if (!this.skipEntry(minRef)) break;
                AbstractTreeIterator[] abstractTreeIteratorArray = this.trees;
                int n = this.trees.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block0;
                    AbstractTreeIterator t2 = abstractTreeIteratorArray[n2];
                    if (t2.matches == minRef) {
                        t2.next(1);
                        t2.matches = null;
                    }
                    ++n2;
                }
                break;
            }
            return minRef;
        }
        return this.combineDF(minRef);
    }

    private AbstractTreeIterator fastMin() {
        int i2 = this.getFirstNonEofTreeIndex();
        if (i2 == -1) {
            this.allTreesNamesMatchFastMinRef = true;
            return this.trees[this.trees.length - 1];
        }
        AbstractTreeIterator minRef = this.trees[i2];
        this.allTreesNamesMatchFastMinRef = i2 == 0;
        boolean hasConflict = false;
        minRef.matches = minRef;
        while (++i2 < this.trees.length) {
            AbstractTreeIterator t2 = this.trees[i2];
            if (t2.eof()) {
                this.allTreesNamesMatchFastMinRef = false;
                continue;
            }
            int cmp = t2.pathCompare(minRef);
            if (cmp < 0) {
                if (this.allTreesNamesMatchFastMinRef && NameConflictTreeWalk.isTree(minRef) && !NameConflictTreeWalk.isTree(t2) && NameConflictTreeWalk.nameEqual(minRef, t2)) {
                    t2.matches = minRef;
                    hasConflict = true;
                    continue;
                }
                this.allTreesNamesMatchFastMinRef = false;
                t2.matches = t2;
                minRef = t2;
                continue;
            }
            if (cmp == 0) {
                t2.matches = minRef;
                continue;
            }
            if (this.allTreesNamesMatchFastMinRef && NameConflictTreeWalk.isTree(t2) && !NameConflictTreeWalk.isTree(minRef) && !this.isGitlink(minRef) && NameConflictTreeWalk.nameEqual(t2, minRef)) {
                int k2 = 0;
                while (k2 < i2) {
                    AbstractTreeIterator p = this.trees[k2];
                    if (p.matches == minRef) {
                        p.matches = t2;
                    }
                    ++k2;
                }
                t2.matches = t2;
                minRef = t2;
                hasConflict = true;
                continue;
            }
            this.allTreesNamesMatchFastMinRef = false;
        }
        if (hasConflict && this.allTreesNamesMatchFastMinRef && this.dfConflict == null) {
            this.dfConflict = minRef;
        }
        return minRef;
    }

    private int getFirstNonEofTreeIndex() {
        int i2 = 0;
        while (i2 < this.trees.length) {
            if (!this.trees[i2].eof()) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    private static boolean nameEqual(AbstractTreeIterator a2, AbstractTreeIterator b2) {
        return a2.pathCompare(b2, TREE_MODE) == 0;
    }

    private boolean isGitlink(AbstractTreeIterator p) {
        return FileMode.GITLINK.equals(p.mode);
    }

    private static boolean isTree(AbstractTreeIterator p) {
        return FileMode.TREE.equals(p.mode);
    }

    private boolean skipEntry(AbstractTreeIterator minRef) throws CorruptObjectException {
        AbstractTreeIterator[] abstractTreeIteratorArray = this.trees;
        int n = this.trees.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTreeIterator t2 = abstractTreeIteratorArray[n2];
            if (t2.matches != minRef && !t2.first()) {
                int cmp;
                int stepsBack = 0;
                do {
                    ++stepsBack;
                    t2.back(1);
                    cmp = t2.pathCompare(minRef, 0);
                    if (cmp != 0) continue;
                    t2.next(stepsBack);
                    return true;
                } while (cmp >= 0 && !t2.first());
                t2.next(stepsBack);
            }
            ++n2;
        }
        return false;
    }

    private AbstractTreeIterator combineDF(AbstractTreeIterator minRef) throws CorruptObjectException {
        AbstractTreeIterator t2;
        AbstractTreeIterator treeMatch = null;
        AbstractTreeIterator[] abstractTreeIteratorArray = this.trees;
        int n = this.trees.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                t2 = abstractTreeIteratorArray[n2];
                if (t2.matches != minRef && !t2.eof()) {
                    int cmp;
                    while ((cmp = t2.pathCompare(minRef, TREE_MODE)) < 0) {
                        ++t2.matchShift;
                        t2.next(1);
                        if (!t2.eof()) continue;
                        t2.back(t2.matchShift);
                        t2.matchShift = 0;
                        break block12;
                    }
                    if (cmp == 0) {
                        t2.matches = minRef;
                        treeMatch = t2;
                    } else if (t2.matchShift != 0) {
                        t2.back(t2.matchShift);
                        t2.matchShift = 0;
                    }
                }
            }
            ++n2;
        }
        abstractTreeIteratorArray = this.trees;
        n = this.trees.length;
        n2 = 0;
        while (n2 < n) {
            t2 = abstractTreeIteratorArray[n2];
            if (!t2.eof() && t2.matches != null && t2.matches != minRef && !NameConflictTreeWalk.nameEqual(t2, t2.matches)) {
                t2.matches = null;
            }
            ++n2;
        }
        if (treeMatch != null) {
            abstractTreeIteratorArray = this.trees;
            n = this.trees.length;
            n2 = 0;
            while (n2 < n) {
                t2 = abstractTreeIteratorArray[n2];
                if (t2.matches == minRef) {
                    t2.matches = treeMatch;
                }
                ++n2;
            }
            if (this.dfConflict == null && !this.isGitlink(minRef)) {
                this.dfConflict = treeMatch;
            }
            return treeMatch;
        }
        return minRef;
    }

    @Override
    void popEntriesEqual() throws CorruptObjectException {
        AbstractTreeIterator ch = this.currentHead;
        AbstractTreeIterator[] abstractTreeIteratorArray = this.trees;
        int n = this.trees.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTreeIterator t2 = abstractTreeIteratorArray[n2];
            if (t2.matches == ch) {
                if (t2.matchShift == 0) {
                    t2.next(1);
                } else {
                    t2.back(t2.matchShift);
                    t2.matchShift = 0;
                }
                t2.matches = null;
            }
            ++n2;
        }
        if (ch == this.dfConflict) {
            this.dfConflict = null;
        }
    }

    @Override
    void skipEntriesEqual() throws CorruptObjectException {
        AbstractTreeIterator ch = this.currentHead;
        AbstractTreeIterator[] abstractTreeIteratorArray = this.trees;
        int n = this.trees.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTreeIterator t2 = abstractTreeIteratorArray[n2];
            if (t2.matches == ch) {
                if (t2.matchShift == 0) {
                    t2.skip();
                } else {
                    t2.back(t2.matchShift);
                    t2.matchShift = 0;
                }
                t2.matches = null;
            }
            ++n2;
        }
        if (ch == this.dfConflict) {
            this.dfConflict = null;
        }
    }

    @Override
    void stopWalk() throws IOException {
        if (!this.needsStopWalk()) {
            return;
        }
        while (true) {
            AbstractTreeIterator t2;
            if ((t2 = this.min()).eof()) {
                if (this.depth > 0) {
                    this.exitSubtree();
                    this.popEntriesEqual();
                    continue;
                }
                return;
            }
            this.currentHead = t2;
            this.skipEntriesEqual();
        }
    }

    private boolean needsStopWalk() {
        AbstractTreeIterator[] abstractTreeIteratorArray = this.trees;
        int n = this.trees.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTreeIterator t2 = abstractTreeIteratorArray[n2];
            if (t2.needsStopWalk()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isDirectoryFileConflict() {
        return this.dfConflict != null;
    }
}

