/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.api.errors.FilterFailedException;
import org.eclipse.jgit.attributes.AttributesNode;
import org.eclipse.jgit.attributes.FilterCommand;
import org.eclipse.jgit.attributes.FilterCommandRegistry;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.InstantComparator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.Holder;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.Paths;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.io.ByteBufferInputStream;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;
import org.eclipse.jgit.util.sha1.SHA1;

public abstract class WorkingTreeIterator
extends AbstractTreeIterator {
    private static final int MAX_EXCEPTION_TEXT_SIZE = 10240;
    protected static final Entry[] EOF = new Entry[0];
    static final int BUFFER_SIZE = 2048;
    private static final long MAXIMUM_FILE_SIZE_TO_READ_FULLY = 65536L;
    private final IteratorState state;
    private byte[] contentId;
    private int contentIdFromPtr;
    private Entry[] entries;
    private int entryCnt;
    private int ptr;
    private IgnoreNode ignoreNode;
    private Holder<String> cleanFilterCommandHolder;
    private Holder<CoreConfig.EolStreamType> eolStreamTypeHolder;
    protected Repository repository;
    private long canonLen = -1L;
    private int contentIdOffset;
    private final InstantComparator timestampComparator = new InstantComparator();
    private static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] hblob = Constants.encodedTypeString(3);
    private static final Comparator<Entry> ENTRY_CMP = (a2, b2) -> Paths.compare(a2.encodedName, 0, a2.encodedNameLen, a2.getMode().getBits(), b2.encodedName, 0, b2.encodedNameLen, b2.getMode().getBits());

    protected WorkingTreeIterator(WorkingTreeOptions options2) {
        this.state = new IteratorState(options2);
    }

    protected WorkingTreeIterator(String prefix2, WorkingTreeOptions options2) {
        super(prefix2);
        this.state = new IteratorState(options2);
    }

    protected WorkingTreeIterator(WorkingTreeIterator p) {
        super(p);
        this.state = p.state;
        this.repository = p.repository;
    }

    protected void initRootIterator(Repository repo) {
        this.repository = repo;
        Entry entry = this.ignoreNode instanceof PerDirectoryIgnoreNode ? ((PerDirectoryIgnoreNode)this.ignoreNode).entry : null;
        this.ignoreNode = new RootIgnoreNode(entry, repo);
    }

    public void setDirCacheIterator(TreeWalk walk, int treeId) {
        this.state.walk = walk;
        this.state.dirCacheTree = treeId;
    }

    protected DirCacheIterator getDirCacheIterator() {
        if (this.state.dirCacheTree >= 0 && this.state.walk != null) {
            return this.state.walk.getTree(this.state.dirCacheTree, DirCacheIterator.class);
        }
        return null;
    }

    public void setWalkIgnoredDirectories(boolean includeIgnored) {
        this.state.walkIgnored = includeIgnored;
    }

    public boolean walksIgnoredDirectories() {
        return this.state.walkIgnored;
    }

    @Override
    public boolean hasId() {
        if (this.contentIdFromPtr == this.ptr) {
            return true;
        }
        return (this.mode & 0xF000) == 32768;
    }

    @Override
    public byte[] idBuffer() {
        if (this.contentIdFromPtr == this.ptr) {
            return this.contentId;
        }
        if (this.state.walk != null) {
            DirCacheIterator i2 = this.state.walk.getTree(this.state.dirCacheTree, DirCacheIterator.class);
            if (i2 != null) {
                DirCacheEntry ent = i2.getDirCacheEntry();
                if (ent != null && this.compareMetadata(ent) == MetadataDiff.EQUAL && (ent.getFileMode().getBits() & 0xF000) != 57344) {
                    this.contentIdOffset = i2.idOffset();
                    this.contentIdFromPtr = this.ptr;
                    this.contentId = i2.idBuffer();
                    return this.contentId;
                }
                this.contentIdOffset = 0;
            } else {
                this.contentIdOffset = 0;
            }
        }
        switch (this.mode & 0xF000) {
            case 32768: 
            case 40960: {
                this.contentIdFromPtr = this.ptr;
                this.contentId = this.idBufferBlob(this.entries[this.ptr]);
                return this.contentId;
            }
            case 57344: {
                this.contentIdFromPtr = this.ptr;
                this.contentId = this.idSubmodule(this.entries[this.ptr]);
                return this.contentId;
            }
        }
        return zeroid;
    }

    @Override
    public boolean isWorkTree() {
        return true;
    }

    protected byte[] idSubmodule(Entry e2) {
        File directory;
        if (this.repository == null) {
            return zeroid;
        }
        try {
            directory = this.repository.getWorkTree();
        }
        catch (NoWorkTreeException nwte) {
            return zeroid;
        }
        return this.idSubmodule(directory, e2);
    }

    protected byte[] idSubmodule(File directory, Entry e2) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Repository submoduleRepo = SubmoduleWalk.getSubmoduleRepository(directory, e2.getName(), this.repository != null ? this.repository.getFS() : FS.DETECTED);){
                if (submoduleRepo == null) {
                    return zeroid;
                }
                ObjectId head2 = submoduleRepo.resolve("HEAD");
                if (head2 == null) {
                    return zeroid;
                }
                byte[] id = new byte[20];
                head2.copyRawTo(id, 0);
                return id;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            return zeroid;
        }
    }

    private byte[] idBufferBlob(Entry e2) {
        byte[] byArray;
        InputStream is = e2.openInputStream();
        if (is == null) {
            return zeroid;
        }
        try {
            this.state.initializeReadBuffer();
            long len2 = e2.getLength();
            InputStream filteredIs = this.possiblyFilteredInputStream(e2, is, len2);
            byArray = this.computeHash(filteredIs, this.canonLen);
        }
        catch (Throwable throwable) {
            try {
                WorkingTreeIterator.safeClose(is);
                throw throwable;
            }
            catch (IOException err) {
                return zeroid;
            }
        }
        WorkingTreeIterator.safeClose(is);
        return byArray;
    }

    private long possiblyFilteredLength(Entry e2, long len2) throws IOException {
        if (this.getCleanFilterCommand() == null && this.getEolStreamType(TreeWalk.OperationType.CHECKIN_OP) == CoreConfig.EolStreamType.DIRECT) {
            return len2;
        }
        if (len2 <= 65536L) {
            InputStream is = e2.openInputStream();
            try {
                ByteBuffer filteredData = IO.readWholeStream(this.filterClean(is), (int)len2);
                long l = filteredData.remaining();
                return l;
            }
            finally {
                WorkingTreeIterator.safeClose(is);
            }
        }
        if (this.getCleanFilterCommand() == null && WorkingTreeIterator.isBinary(e2)) {
            return len2;
        }
        InputStream is = this.filterClean(e2.openInputStream());
        try {
            long l = WorkingTreeIterator.computeLength(is);
            return l;
        }
        finally {
            WorkingTreeIterator.safeClose(is);
        }
    }

    private InputStream possiblyFilteredInputStream(Entry e2, InputStream is, long len2) throws IOException {
        if (this.getCleanFilterCommand() == null && this.getEolStreamType(TreeWalk.OperationType.CHECKIN_OP) == CoreConfig.EolStreamType.DIRECT) {
            this.canonLen = len2;
            return is;
        }
        if (len2 <= 65536L) {
            ByteBuffer filteredData = IO.readWholeStream(this.filterClean(is), (int)len2);
            this.canonLen = filteredData.remaining();
            return new ByteBufferInputStream(filteredData);
        }
        if (this.getCleanFilterCommand() == null && WorkingTreeIterator.isBinary(e2)) {
            this.canonLen = len2;
            return is;
        }
        InputStream lenIs = this.filterClean(e2.openInputStream());
        try {
            this.canonLen = WorkingTreeIterator.computeLength(lenIs);
        }
        finally {
            WorkingTreeIterator.safeClose(lenIs);
        }
        return this.filterClean(is);
    }

    private static void safeClose(InputStream in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isBinary(Entry entry) throws IOException {
        InputStream in = entry.openInputStream();
        try {
            boolean bl = RawText.isBinary(in);
            return bl;
        }
        finally {
            WorkingTreeIterator.safeClose(in);
        }
    }

    private InputStream filterClean(InputStream in) throws IOException {
        in = EolStreamTypeUtil.wrapInputStream(in, this.getEolStreamType(TreeWalk.OperationType.CHECKIN_OP));
        String filterCommand = this.getCleanFilterCommand();
        if (filterCommand != null) {
            FS.ExecutionResult result2;
            if (FilterCommandRegistry.isRegistered(filterCommand)) {
                TemporaryBuffer.LocalFile buffer = new TemporaryBuffer.LocalFile(null);
                FilterCommand command2 = FilterCommandRegistry.createFilterCommand(filterCommand, this.repository, in, buffer);
                while (command2.run() != -1) {
                }
                return buffer.openInputStreamWithAutoDestroy();
            }
            FS fs = this.repository.getFS();
            ProcessBuilder filterProcessBuilder = fs.runInShell(filterCommand, new String[0]);
            filterProcessBuilder.directory(this.repository.getWorkTree());
            filterProcessBuilder.environment().put("GIT_DIR", this.repository.getDirectory().getAbsolutePath());
            filterProcessBuilder.environment().put("GIT_COMMON_DIR", this.repository.getCommonDirectory().getAbsolutePath());
            try {
                result2 = fs.execute(filterProcessBuilder, in);
            }
            catch (IOException | InterruptedException e2) {
                throw new IOException(new FilterFailedException(e2, filterCommand, this.getEntryPathString()));
            }
            int rc2 = result2.getRc();
            if (rc2 != 0) {
                throw new IOException(new FilterFailedException(rc2, filterCommand, this.getEntryPathString(), result2.getStdout().toByteArray(10240), result2.getStderr().toString(10240)));
            }
            return result2.getStdout().openInputStreamWithAutoDestroy();
        }
        return in;
    }

    public WorkingTreeOptions getOptions() {
        return this.state.options;
    }

    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public int idOffset() {
        return this.contentIdOffset;
    }

    @Override
    public void reset() {
        if (!this.first()) {
            this.ptr = 0;
            if (!this.eof()) {
                this.parseEntry();
            }
        }
    }

    @Override
    public boolean first() {
        return this.ptr == 0;
    }

    @Override
    public boolean eof() {
        return this.ptr == this.entryCnt;
    }

    @Override
    public void next(int delta) throws CorruptObjectException {
        this.ptr += delta;
        if (!this.eof()) {
            this.parseEntry();
        }
    }

    @Override
    public void back(int delta) throws CorruptObjectException {
        this.ptr -= delta;
        this.parseEntry();
    }

    private void parseEntry() {
        Entry e2 = this.entries[this.ptr];
        this.mode = e2.getMode().getBits();
        int nameLen = e2.encodedNameLen;
        this.ensurePathCapacity(this.pathOffset + nameLen, this.pathOffset);
        System.arraycopy(e2.encodedName, 0, this.path, this.pathOffset, nameLen);
        this.pathLen = this.pathOffset + nameLen;
        this.canonLen = -1L;
        this.cleanFilterCommandHolder = null;
        this.eolStreamTypeHolder = null;
    }

    public long getEntryLength() {
        return this.current().getLength();
    }

    public long getEntryContentLength() throws IOException {
        if (this.canonLen == -1L) {
            long rawLen = this.getEntryLength();
            this.canonLen = rawLen == 0L ? 0L : this.possiblyFilteredLength(this.current(), this.current().getLength());
        }
        return this.canonLen;
    }

    public Instant getEntryLastModifiedInstant() {
        return this.current().getLastModifiedInstant();
    }

    public InputStream openEntryStream() throws IOException {
        InputStream rawis = this.current().openInputStream();
        if (this.getCleanFilterCommand() == null && this.getEolStreamType(TreeWalk.OperationType.CHECKIN_OP) == CoreConfig.EolStreamType.DIRECT) {
            return rawis;
        }
        return this.filterClean(rawis);
    }

    public boolean isEntryIgnored() throws IOException {
        return this.isEntryIgnored(this.pathLen);
    }

    protected boolean isEntryIgnored(int pLen) throws IOException {
        return this.isEntryIgnored(pLen, this.mode);
    }

    private boolean isEntryIgnored(int pLen, int fileMode) throws IOException {
        Boolean ignored;
        int pOff = this.pathOffset > 0 ? this.pathOffset - 1 : this.pathOffset;
        String pathRel = TreeWalk.pathOf(this.path, pOff, pLen);
        String parentRel = WorkingTreeIterator.getParentPath(pathRel);
        if (this.isDirectoryIgnored(parentRel)) {
            return true;
        }
        IgnoreNode rules = this.getIgnoreNode();
        Boolean bl = ignored = rules != null ? rules.checkIgnored(pathRel, FileMode.TREE.equals(fileMode)) : null;
        if (ignored != null) {
            return ignored;
        }
        return this.parent instanceof WorkingTreeIterator && ((WorkingTreeIterator)this.parent).isEntryIgnored(pLen, fileMode);
    }

    private IgnoreNode getIgnoreNode() throws IOException {
        if (this.ignoreNode instanceof PerDirectoryIgnoreNode) {
            this.ignoreNode = ((PerDirectoryIgnoreNode)this.ignoreNode).load();
        }
        return this.ignoreNode;
    }

    public AttributesNode getEntryAttributesNode() throws IOException {
        if (this.attributesNode instanceof PerDirectoryAttributesNode) {
            this.attributesNode = ((PerDirectoryAttributesNode)this.attributesNode).load();
        }
        return this.attributesNode;
    }

    protected void init(Entry[] list) {
        this.entries = list;
        CharsetEncoder nameEncoder = this.state.nameEncoder;
        int i2 = 0;
        int o = 0;
        while (i2 < this.entries.length) {
            String name;
            Entry e2 = this.entries[i2];
            if (!(e2 == null || ".".equals(name = e2.getName()) || "..".equals(name) || ".git".equals(name))) {
                if (".gitignore".equals(name)) {
                    this.ignoreNode = new PerDirectoryIgnoreNode(TreeWalk.pathOf(this.path, 0, this.pathOffset) + ".gitignore", e2);
                }
                if (".gitattributes".equals(name)) {
                    this.attributesNode = new PerDirectoryAttributesNode(e2);
                }
                if (i2 != o) {
                    this.entries[o] = e2;
                }
                e2.encodeName(nameEncoder);
                ++o;
            }
            ++i2;
        }
        this.entryCnt = o;
        Arrays.sort(this.entries, 0, this.entryCnt, ENTRY_CMP);
        this.contentIdFromPtr = -1;
        this.ptr = 0;
        if (!this.eof()) {
            this.parseEntry();
        } else if (this.pathLen == 0) {
            this.pathLen = this.pathOffset;
        }
    }

    protected Entry current() {
        return this.entries[this.ptr];
    }

    public boolean isModeDifferent(int rawMode) {
        int modeDiff = this.getEntryRawMode() ^ rawMode;
        if (modeDiff == 0) {
            return false;
        }
        if (this.getOptions().getSymLinks() == CoreConfig.SymLinks.FALSE && FileMode.SYMLINK.equals(rawMode)) {
            return false;
        }
        if (!this.state.options.isFileMode()) {
            modeDiff &= ~FileMode.EXECUTABLE_FILE.getBits();
        }
        return modeDiff != 0;
    }

    public MetadataDiff compareMetadata(DirCacheEntry entry) {
        Instant fileLastModified;
        if (entry.isAssumeValid()) {
            return MetadataDiff.EQUAL;
        }
        if (entry.isUpdateNeeded()) {
            return MetadataDiff.DIFFER_BY_METADATA;
        }
        if (this.isModeDifferent(entry.getRawMode())) {
            return MetadataDiff.DIFFER_BY_METADATA;
        }
        int type2 = this.mode & 0xF000;
        if (type2 == 16384 || type2 == 57344) {
            return MetadataDiff.EQUAL;
        }
        if (!entry.isSmudged() && entry.getLength() != (int)this.getEntryLength()) {
            return MetadataDiff.DIFFER_BY_METADATA;
        }
        Instant cacheLastModified = entry.getLastModifiedInstant();
        if (this.timestampComparator.compare(cacheLastModified, fileLastModified = this.getEntryLastModifiedInstant(), this.getOptions().getCheckStat() == CoreConfig.CheckStat.MINIMAL) != 0) {
            return MetadataDiff.DIFFER_BY_TIMESTAMP;
        }
        if (entry.isSmudged()) {
            return MetadataDiff.SMUDGED;
        }
        return MetadataDiff.EQUAL;
    }

    public boolean isModified(DirCacheEntry entry, boolean forceContentCheck, ObjectReader reader2) throws IOException {
        if (entry == null) {
            return !FileMode.MISSING.equals(this.getEntryFileMode());
        }
        MetadataDiff diff = this.compareMetadata(entry);
        switch (diff) {
            case DIFFER_BY_TIMESTAMP: {
                if (forceContentCheck) {
                    return this.contentCheck(entry, reader2);
                }
                return true;
            }
            case SMUDGED: {
                return this.contentCheck(entry, reader2);
            }
            case EQUAL: {
                if (this.mode == FileMode.SYMLINK.getBits()) {
                    return this.contentCheck(entry, reader2);
                }
                return false;
            }
            case DIFFER_BY_METADATA: {
                if (this.mode == FileMode.TREE.getBits() && entry.getFileMode().equals(FileMode.GITLINK)) {
                    byte[] idBuffer = this.idBuffer();
                    int idOffset = this.idOffset();
                    if (entry.getObjectId().compareTo(idBuffer, idOffset) == 0) {
                        return true;
                    }
                    if (ObjectId.zeroId().compareTo(idBuffer, idOffset) == 0) {
                        Path p = this.repository.getWorkTree().toPath().resolve(entry.getPathString());
                        return FileUtils.hasFiles(p);
                    }
                    return false;
                }
                if (this.mode == FileMode.SYMLINK.getBits()) {
                    return this.contentCheck(entry, reader2);
                }
                return true;
            }
        }
        throw new IllegalStateException(MessageFormat.format(JGitText.get().unexpectedCompareResult, diff.name()));
    }

    public FileMode getIndexFileMode(DirCacheIterator indexIter) {
        FileMode wtMode = this.getEntryFileMode();
        if (indexIter == null) {
            return wtMode;
        }
        FileMode iMode = indexIter.getEntryFileMode();
        if (iMode == FileMode.SYMLINK && this.getOptions().getSymLinks() == CoreConfig.SymLinks.FALSE && (wtMode == FileMode.REGULAR_FILE || wtMode == FileMode.EXECUTABLE_FILE)) {
            return iMode;
        }
        if (this.getOptions().isFileMode() && iMode != FileMode.GITLINK && iMode != FileMode.TREE) {
            return wtMode;
        }
        if (!this.getOptions().isFileMode()) {
            if (FileMode.REGULAR_FILE == wtMode && FileMode.EXECUTABLE_FILE == iMode) {
                return iMode;
            }
            if (FileMode.EXECUTABLE_FILE == wtMode && FileMode.REGULAR_FILE == iMode) {
                return iMode;
            }
        }
        if (FileMode.GITLINK == iMode && FileMode.TREE == wtMode && !this.getOptions().isDirNoGitLinks()) {
            return iMode;
        }
        if (FileMode.TREE == iMode && FileMode.GITLINK == wtMode) {
            return iMode;
        }
        return wtMode;
    }

    private boolean contentCheck(DirCacheEntry entry, ObjectReader reader2) throws IOException {
        if (this.getEntryObjectId().equals(entry.getObjectId())) {
            entry.setLength((int)this.getEntryLength());
            return false;
        }
        if (this.mode == FileMode.SYMLINK.getBits()) {
            return !new File(this.readSymlinkTarget(this.current())).equals(new File(WorkingTreeIterator.readContentAsNormalizedString(entry, reader2)));
        }
        return true;
    }

    private static String readContentAsNormalizedString(DirCacheEntry entry, ObjectReader reader2) throws MissingObjectException, IOException {
        ObjectLoader open = reader2.open(entry.getObjectId());
        byte[] cachedBytes = open.getCachedBytes();
        return FS.detect().normalize(RawParseUtils.decode(cachedBytes));
    }

    protected String readSymlinkTarget(Entry entry) throws IOException {
        if (!entry.getMode().equals(FileMode.SYMLINK)) {
            throw new NotLinkException(entry.getName());
        }
        long length = entry.getLength();
        byte[] content2 = new byte[(int)length];
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream is = entry.openInputStream();){
            int bytesRead = IO.readFully(is, content2, 0);
            return FS.detect().normalize(RawParseUtils.decode(content2, 0, bytesRead));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static long computeLength(InputStream in) throws IOException {
        long n;
        long length = 0L;
        while ((n = in.skip(0x100000L)) > 0L) {
            length += n;
        }
        return length;
    }

    private byte[] computeHash(InputStream in, long length) throws IOException {
        int r;
        SHA1 contentDigest = SHA1.newInstance();
        byte[] contentReadBuffer = this.state.contentReadBuffer;
        contentDigest.update(hblob);
        contentDigest.update((byte)32);
        long sz = length;
        if (sz == 0L) {
            contentDigest.update((byte)48);
        } else {
            int bufn;
            int p = bufn = contentReadBuffer.length;
            do {
                contentReadBuffer[--p] = digits[(int)(sz % 10L)];
            } while ((sz /= 10L) > 0L);
            contentDigest.update(contentReadBuffer, p, bufn - p);
        }
        contentDigest.update((byte)0);
        while ((r = in.read(contentReadBuffer)) > 0) {
            contentDigest.update(contentReadBuffer, 0, r);
            sz += (long)r;
        }
        if (sz != length) {
            return zeroid;
        }
        return contentDigest.digest();
    }

    public String getCleanFilterCommand() throws IOException {
        if (this.cleanFilterCommandHolder == null) {
            String cmd = null;
            if (this.state.walk != null) {
                cmd = this.state.walk.getFilterCommand("clean");
            }
            this.cleanFilterCommandHolder = new Holder<Object>(cmd);
        }
        return this.cleanFilterCommandHolder.get();
    }

    public CoreConfig.EolStreamType getEolStreamType() throws IOException {
        return this.getEolStreamType(null);
    }

    private CoreConfig.EolStreamType getEolStreamType(TreeWalk.OperationType opType) throws IOException {
        if (this.eolStreamTypeHolder == null) {
            CoreConfig.EolStreamType type2 = null;
            if (this.state.walk != null) {
                TreeWalk.OperationType operationType;
                type2 = this.state.walk.getEolStreamType(opType);
                TreeWalk.OperationType operationType2 = operationType = opType != null ? opType : this.state.walk.getOperationType();
                if (TreeWalk.OperationType.CHECKIN_OP.equals((Object)operationType) && CoreConfig.EolStreamType.AUTO_LF.equals((Object)type2) && this.hasCrLfInIndex(this.getDirCacheIterator())) {
                    type2 = CoreConfig.EolStreamType.DIRECT;
                }
            } else {
                switch (this.getOptions().getAutoCRLF()) {
                    case FALSE: {
                        type2 = CoreConfig.EolStreamType.DIRECT;
                        break;
                    }
                    case TRUE: 
                    case INPUT: {
                        type2 = CoreConfig.EolStreamType.AUTO_LF;
                    }
                }
            }
            this.eolStreamTypeHolder = new Holder<CoreConfig.EolStreamType>(type2);
        }
        return this.eolStreamTypeHolder.get();
    }

    /*
     * Exception decompiling
     */
    private boolean hasCrLfInIndex(DirCacheIterator dirCache) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isDirectoryIgnored(String pathRel) throws IOException {
        int pOff = this.pathOffset > 0 ? this.pathOffset - 1 : this.pathOffset;
        String base = TreeWalk.pathOf(this.path, 0, pOff);
        String pathAbs = WorkingTreeIterator.concatPath(base, pathRel);
        return this.isDirectoryIgnored(pathRel, pathAbs);
    }

    private boolean isDirectoryIgnored(String pathRel, String pathAbs) throws IOException {
        assert (pathRel.length() == 0 || pathRel.charAt(0) != '/' && pathRel.charAt(pathRel.length() - 1) != '/');
        assert (pathAbs.length() == 0 || pathAbs.charAt(0) != '/' && pathAbs.charAt(pathAbs.length() - 1) != '/');
        assert (pathAbs.endsWith(pathRel));
        Boolean ignored = this.state.directoryToIgnored.get(pathAbs);
        if (ignored != null) {
            return ignored;
        }
        String parentRel = WorkingTreeIterator.getParentPath(pathRel);
        if (parentRel != null && this.isDirectoryIgnored(parentRel)) {
            this.state.directoryToIgnored.put(pathAbs, Boolean.TRUE);
            return true;
        }
        IgnoreNode node = this.getIgnoreNode();
        String p = pathRel;
        while (node != null && !"".equals(p)) {
            ignored = node.checkIgnored(p, true);
            if (ignored != null) {
                this.state.directoryToIgnored.put(pathAbs, ignored);
                return ignored;
            }
            p = WorkingTreeIterator.getParentPath(p);
        }
        if (!(this.parent instanceof WorkingTreeIterator)) {
            this.state.directoryToIgnored.put(pathAbs, Boolean.FALSE);
            return false;
        }
        WorkingTreeIterator wtParent = (WorkingTreeIterator)this.parent;
        String parentRelPath = WorkingTreeIterator.concatPath(TreeWalk.pathOf(this.path, wtParent.pathOffset, this.pathOffset - 1), pathRel);
        assert (WorkingTreeIterator.concatPath(TreeWalk.pathOf(wtParent.path, 0, Math.max(0, wtParent.pathOffset - 1)), parentRelPath).equals(pathAbs));
        return wtParent.isDirectoryIgnored(parentRelPath, pathAbs);
    }

    private static String getParentPath(String path2) {
        int slashIndex = path2.lastIndexOf(47, path2.length() - 2);
        if (slashIndex > 0) {
            return path2.substring(path2.charAt(0) == '/' ? 1 : 0, slashIndex);
        }
        return path2.length() > 0 ? "" : null;
    }

    private static String concatPath(String p1, String p2) {
        return p1 + (p1.length() > 0 && p2.length() > 0 ? "/" : "") + p2;
    }

    public static abstract class Entry {
        byte[] encodedName;
        int encodedNameLen;

        void encodeName(CharsetEncoder enc) {
            ByteBuffer b2;
            try {
                b2 = enc.encode(CharBuffer.wrap(this.getName()));
            }
            catch (CharacterCodingException e2) {
                throw new RuntimeException(MessageFormat.format(JGitText.get().unencodeableFile, this.getName()), e2);
            }
            this.encodedNameLen = b2.limit();
            if (b2.hasArray() && b2.arrayOffset() == 0) {
                this.encodedName = b2.array();
            } else {
                this.encodedName = new byte[this.encodedNameLen];
                b2.get(this.encodedName);
            }
        }

        public String toString() {
            return this.getMode().toString() + " " + this.getName();
        }

        public abstract FileMode getMode();

        public abstract long getLength();

        public abstract Instant getLastModifiedInstant();

        public abstract String getName();

        public abstract InputStream openInputStream() throws IOException;
    }

    private static class IgnoreNodeWithParent
    extends IgnoreNode {
        private final IgnoreNode parent;

        IgnoreNodeWithParent(IgnoreNode parent) {
            this.parent = parent;
        }

        @Override
        public Boolean checkIgnored(String path2, boolean isDirectory) {
            Boolean result2 = super.checkIgnored(path2, isDirectory);
            if (result2 == null && this.parent != null) {
                return this.parent.checkIgnored(path2, isDirectory);
            }
            return result2;
        }
    }

    private static final class IteratorState {
        final WorkingTreeOptions options;
        final CharsetEncoder nameEncoder;
        byte[] contentReadBuffer;
        TreeWalk walk;
        int dirCacheTree = -1;
        boolean walkIgnored = false;
        final Map<String, Boolean> directoryToIgnored = new HashMap<String, Boolean>();

        IteratorState(WorkingTreeOptions options2) {
            this.options = options2;
            this.nameEncoder = StandardCharsets.UTF_8.newEncoder();
        }

        void initializeReadBuffer() {
            if (this.contentReadBuffer == null) {
                this.contentReadBuffer = new byte[2048];
            }
        }
    }

    public static enum MetadataDiff {
        EQUAL,
        DIFFER_BY_METADATA,
        SMUDGED,
        DIFFER_BY_TIMESTAMP;

    }

    private static class PerDirectoryAttributesNode
    extends AttributesNode {
        final Entry entry;

        PerDirectoryAttributesNode(Entry entry) {
            super(Collections.emptyList());
            this.entry = entry;
        }

        AttributesNode load() throws IOException {
            AttributesNode r = new AttributesNode();
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream in = this.entry.openInputStream();){
                r.parse(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return r.getRules().isEmpty() ? null : r;
        }
    }

    private static class PerDirectoryIgnoreNode
    extends IgnoreNode {
        protected final Entry entry;
        private final String name;

        PerDirectoryIgnoreNode(String name, Entry entry) {
            super(Collections.emptyList());
            this.name = name;
            this.entry = entry;
        }

        IgnoreNode load() throws IOException {
            return this.load(null);
        }

        IgnoreNode load(IgnoreNode parent) throws IOException {
            IgnoreNodeWithParent r = new IgnoreNodeWithParent(parent);
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream in = this.entry.openInputStream();){
                r.parse(this.name, in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return r.getRules().isEmpty() && parent == null ? null : r;
        }
    }

    private static class RootIgnoreNode
    extends PerDirectoryIgnoreNode {
        final Repository repository;

        RootIgnoreNode(Entry entry, Repository repository) {
            super(entry != null ? entry.getName() : null, entry);
            this.repository = repository;
        }

        @Override
        IgnoreNode load(IgnoreNode parent) throws IOException {
            IgnoreNode r;
            IgnoreNodeWithParent parentNode;
            IgnoreNode coreExclude = new IgnoreNodeWithParent(parent);
            FS fs = this.repository.getFS();
            Path path2 = this.repository.getConfig().getPath("core", null, "excludesfile", fs, null, null);
            if (path2 != null) {
                if (Files.exists(path2, new LinkOption[0])) {
                    RootIgnoreNode.loadRulesFromFile(coreExclude, path2.toFile());
                }
            } else {
                RootIgnoreNode.loadRulesFromDefaultFile(coreExclude, fs);
            }
            if (coreExclude.getRules().isEmpty()) {
                coreExclude = parent;
            }
            IgnoreNodeWithParent infoExclude = new IgnoreNodeWithParent(coreExclude);
            File exclude2 = fs.resolve(this.repository.getCommonDirectory(), "info/exclude");
            if (fs.exists(exclude2)) {
                RootIgnoreNode.loadRulesFromFile(infoExclude, exclude2);
            }
            if (infoExclude.getRules().isEmpty()) {
                infoExclude = null;
            }
            IgnoreNodeWithParent ignoreNodeWithParent = parentNode = infoExclude != null ? infoExclude : coreExclude;
            if (this.entry != null) {
                r = super.load(parentNode);
                if (r == null) {
                    return null;
                }
            } else {
                return parentNode;
            }
            return r.getRules().isEmpty() ? parentNode : r;
        }

        private static void loadRulesFromFile(IgnoreNode r, File exclude2) throws FileNotFoundException, IOException {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileInputStream in = new FileInputStream(exclude2);){
                r.parse(exclude2.getAbsolutePath(), in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private static void loadRulesFromDefaultFile(IgnoreNode r, FS fileSystem) throws FileNotFoundException, IOException {
            Path cfgPath;
            Path cfg = SystemReader.getInstance().getXdgConfigDirectory(fileSystem);
            if (cfg != null && Files.exists(cfgPath = cfg.resolve("git").resolve("ignore"), new LinkOption[0])) {
                RootIgnoreNode.loadRulesFromFile(r, cfgPath.toFile());
            }
        }
    }
}

