/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public abstract class AndTreeFilter
extends TreeFilter {
    public static TreeFilter create(TreeFilter a2, TreeFilter b2) {
        if (a2 == ALL) {
            return b2;
        }
        if (b2 == ALL) {
            return a2;
        }
        return new Binary(a2, b2);
    }

    public static TreeFilter create(TreeFilter[] list) {
        if (list.length == 2) {
            return AndTreeFilter.create(list[0], list[1]);
        }
        if (list.length < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        TreeFilter[] subfilters = new TreeFilter[list.length];
        System.arraycopy(list, 0, subfilters, 0, list.length);
        return new List(subfilters);
    }

    public static TreeFilter create(Collection<TreeFilter> list) {
        if (list.size() < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        TreeFilter[] subfilters = new TreeFilter[list.size()];
        list.toArray(subfilters);
        if (subfilters.length == 2) {
            return AndTreeFilter.create(subfilters[0], subfilters[1]);
        }
        return new List(subfilters);
    }

    private static class Binary
    extends AndTreeFilter {
        private final TreeFilter a;
        private final TreeFilter b;

        Binary(TreeFilter one, TreeFilter two) {
            this.a = one;
            this.b = two;
        }

        @Override
        public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.matchFilter(walker) <= 0;
        }

        @Override
        public boolean shouldTreeWalk(RevCommit c2, RevWalk rw, TreeFilter.MutableBoolean cpfUsed) {
            return this.a.shouldTreeWalk(c2, rw, cpfUsed) && this.b.shouldTreeWalk(c2, rw, cpfUsed);
        }

        @Override
        public int matchFilter(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            int ra = this.a.matchFilter(walker);
            if (ra == 1) {
                return 1;
            }
            int rb = this.b.matchFilter(walker);
            if (rb == 1) {
                return 1;
            }
            if (ra == -1 || rb == -1) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean shouldBeRecursive() {
            return this.a.shouldBeRecursive() || this.b.shouldBeRecursive();
        }

        @Override
        public TreeFilter clone() {
            return new Binary(this.a.clone(), this.b.clone());
        }

        @Override
        public String toString() {
            return "(" + this.a.toString() + " AND " + this.b.toString() + ")";
        }
    }

    private static class List
    extends AndTreeFilter {
        private final TreeFilter[] subfilters;

        List(TreeFilter[] list) {
            this.subfilters = list;
        }

        @Override
        public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.matchFilter(walker) <= 0;
        }

        @Override
        public int matchFilter(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            int m4 = 0;
            TreeFilter[] treeFilterArray = this.subfilters;
            int n = this.subfilters.length;
            int n2 = 0;
            while (n2 < n) {
                TreeFilter f2 = treeFilterArray[n2];
                int r = f2.matchFilter(walker);
                if (r == 1) {
                    return 1;
                }
                if (r == -1) {
                    m4 = -1;
                }
                ++n2;
            }
            return m4;
        }

        @Override
        public boolean shouldBeRecursive() {
            TreeFilter[] treeFilterArray = this.subfilters;
            int n = this.subfilters.length;
            int n2 = 0;
            while (n2 < n) {
                TreeFilter f2 = treeFilterArray[n2];
                if (f2.shouldBeRecursive()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public boolean shouldTreeWalk(RevCommit c2, RevWalk rw, TreeFilter.MutableBoolean cpfUsed) {
            return Arrays.stream(this.subfilters).allMatch(t2 -> t2.shouldTreeWalk(c2, rw, cpfUsed));
        }

        @Override
        public TreeFilter clone() {
            TreeFilter[] s2 = new TreeFilter[this.subfilters.length];
            int i2 = 0;
            while (i2 < s2.length) {
                s2[i2] = this.subfilters[i2].clone();
                ++i2;
            }
            return new List(s2);
        }

        @Override
        public String toString() {
            StringBuilder r = new StringBuilder();
            r.append("(");
            int i2 = 0;
            while (i2 < this.subfilters.length) {
                if (i2 > 0) {
                    r.append(" AND ");
                }
                r.append(this.subfilters[i2].toString());
                ++i2;
            }
            r.append(")");
            return r.toString();
        }
    }
}

