/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class IndexDiffFilter
extends TreeFilter {
    private final int dirCache;
    private final int workingTree;
    private final boolean honorIgnores;
    private final Set<String> ignoredPaths = new HashSet<String>();
    private final ArrayDeque<String> untrackedParentFolders = new ArrayDeque();
    private final ArrayDeque<String> untrackedFolders = new ArrayDeque();

    public IndexDiffFilter(int dirCacheIndex, int workingTreeIndex) {
        this(dirCacheIndex, workingTreeIndex, true);
    }

    public IndexDiffFilter(int dirCacheIndex, int workingTreeIndex, boolean honorIgnores) {
        this.dirCache = dirCacheIndex;
        this.workingTree = workingTreeIndex;
        this.honorIgnores = honorIgnores;
    }

    @Override
    public boolean include(TreeWalk tw) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        int i2;
        DirCacheEntry dce;
        int cnt = tw.getTreeCount();
        int wm = tw.getRawMode(this.workingTree);
        WorkingTreeIterator wi = this.workingTree(tw);
        String path2 = tw.getPathString();
        DirCacheIterator di = tw.getTree(this.dirCache, DirCacheIterator.class);
        if (di != null && (dce = di.getDirCacheEntry()) != null) {
            if (dce.isAssumeValid()) {
                return false;
            }
            if (dce.getStage() != 0) {
                return true;
            }
        }
        if (!tw.isPostOrderTraversal()) {
            if (!(!FileMode.TREE.equals(wm) || this.honorIgnores && wi.isEntryIgnored())) {
                this.copyUntrackedFolders(path2);
                this.untrackedParentFolders.addFirst(path2);
            }
            int i3 = 0;
            while (i3 < cnt) {
                int rmode = tw.getRawMode(i3);
                if (i3 != this.workingTree && rmode != 0 && FileMode.TREE.equals(rmode)) {
                    this.untrackedParentFolders.clear();
                    break;
                }
                ++i3;
            }
        }
        if (wm == 0) {
            return true;
        }
        int dm = tw.getRawMode(this.dirCache);
        if (dm == 0) {
            if (this.honorIgnores && wi.isEntryIgnored()) {
                this.ignoredPaths.add(wi.getEntryPathString());
                i2 = 0;
                while (i2 < cnt) {
                    if (i2 != this.dirCache && i2 != this.workingTree && tw.getRawMode(i2) != 0) break;
                    ++i2;
                }
                return i2 != cnt;
            }
            return true;
        }
        if (tw.isSubtree()) {
            return true;
        }
        i2 = 0;
        while (i2 < cnt) {
            if (!(i2 == this.dirCache || i2 == this.workingTree || tw.getRawMode(i2) == dm && tw.idEqual(i2, this.dirCache))) {
                return true;
            }
            ++i2;
        }
        return wi.isModified(di == null ? null : di.getDirCacheEntry(), true, tw.getObjectReader());
    }

    private void copyUntrackedFolders(String currentPath) {
        String pathToBeSaved = null;
        while (!this.untrackedParentFolders.isEmpty() && !currentPath.startsWith(this.untrackedParentFolders.getFirst() + "/")) {
            pathToBeSaved = this.untrackedParentFolders.removeFirst();
        }
        if (pathToBeSaved != null) {
            while (!this.untrackedFolders.isEmpty() && this.untrackedFolders.getLast().startsWith(pathToBeSaved + "/")) {
                this.untrackedFolders.removeLast();
            }
            this.untrackedFolders.addLast(pathToBeSaved);
        }
    }

    private WorkingTreeIterator workingTree(TreeWalk tw) {
        return tw.getTree(this.workingTree, WorkingTreeIterator.class);
    }

    @Override
    public boolean shouldBeRecursive() {
        return true;
    }

    @Override
    public TreeFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return "INDEX_DIFF_FILTER";
    }

    public Set<String> getIgnoredPaths() {
        return this.ignoredPaths;
    }

    public List<String> getUntrackedFolders() {
        ArrayList<String> ret = new ArrayList<String>(this.untrackedFolders);
        if (!this.untrackedParentFolders.isEmpty()) {
            String toBeAdded = this.untrackedParentFolders.getLast();
            while (!ret.isEmpty() && ret.get(ret.size() - 1).startsWith(toBeAdded)) {
                ret.remove(ret.size() - 1);
            }
            ret.add(toBeAdded);
        }
        return ret;
    }
}

