/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class PathFilter
extends TreeFilter {
    final String pathStr;
    final byte[] pathRaw;

    public static PathFilter create(String path2) {
        while (path2.endsWith("/")) {
            path2 = path2.substring(0, path2.length() - 1);
        }
        if (path2.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().emptyPathNotPermitted);
        }
        return new PathFilter(path2);
    }

    private PathFilter(String s2) {
        this.pathStr = s2;
        this.pathRaw = Constants.encode(this.pathStr);
    }

    public String getPath() {
        return this.pathStr;
    }

    @Override
    public boolean include(TreeWalk walker) {
        return this.matchFilter(walker) <= 0;
    }

    @Override
    public int matchFilter(TreeWalk walker) {
        return walker.isPathMatch(this.pathRaw, this.pathRaw.length);
    }

    @Override
    public boolean shouldBeRecursive() {
        byte[] byArray = this.pathRaw;
        int n = this.pathRaw.length;
        int n2 = 0;
        while (n2 < n) {
            byte b2 = byArray[n2];
            if (b2 == 47) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Optional<Set<byte[]>> getPathsBestEffort() {
        Set<byte[]> s2 = Collections.singleton(this.pathRaw);
        return Optional.of(s2);
    }

    @Override
    public PathFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return "PATH(\"" + this.pathStr + "\")";
    }

    public boolean isDone(TreeWalk walker) {
        return this.pathRaw.length == walker.getPathLength();
    }
}

