/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jgit.internal.JGitText;

public class Base64 {
    private static final byte EQUALS_SIGN = 61;
    private static final byte EQUALS_SIGN_DEC = -1;
    private static final byte WHITE_SPACE_DEC = -2;
    private static final byte INVALID_DEC = -3;
    private static final byte[] ENC = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DEC = new byte[128];

    static {
        Arrays.fill(DEC, (byte)-3);
        int i2 = 0;
        while (i2 < 64) {
            Base64.DEC[Base64.ENC[i2]] = (byte)i2;
            ++i2;
        }
        Base64.DEC[61] = -1;
        Base64.DEC[9] = -2;
        Base64.DEC[10] = -2;
        Base64.DEC[13] = -2;
        Base64.DEC[32] = -2;
    }

    private Base64() {
    }

    private static void encode3to4(byte[] source2, int srcOffset, int numSigBytes, byte[] destination, int destOffset) {
        int inBuff = 0;
        switch (numSigBytes) {
            case 3: {
                inBuff |= source2[srcOffset + 2] << 24 >>> 24;
            }
            case 2: {
                inBuff |= source2[srcOffset + 1] << 24 >>> 16;
            }
            case 1: {
                inBuff |= source2[srcOffset] << 24 >>> 8;
            }
        }
        switch (numSigBytes) {
            case 3: {
                destination[destOffset] = ENC[inBuff >>> 18];
                destination[destOffset + 1] = ENC[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = ENC[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = ENC[inBuff & 0x3F];
                break;
            }
            case 2: {
                destination[destOffset] = ENC[inBuff >>> 18];
                destination[destOffset + 1] = ENC[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = ENC[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = 61;
                break;
            }
            case 1: {
                destination[destOffset] = ENC[inBuff >>> 18];
                destination[destOffset + 1] = ENC[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = 61;
                destination[destOffset + 3] = 61;
            }
        }
    }

    public static String encodeBytes(byte[] source2) {
        return Base64.encodeBytes(source2, 0, source2.length);
    }

    public static String encodeBytes(byte[] source2, int off, int len2) {
        int len43 = len2 * 4 / 3;
        byte[] outBuff = new byte[len43 + (len2 % 3 > 0 ? 4 : 0)];
        int d2 = 0;
        int e2 = 0;
        int len22 = len2 - 2;
        while (d2 < len22) {
            Base64.encode3to4(source2, d2 + off, 3, outBuff, e2);
            d2 += 3;
            e2 += 4;
        }
        if (d2 < len2) {
            Base64.encode3to4(source2, d2 + off, len2 - d2, outBuff, e2);
            e2 += 4;
        }
        return new String(outBuff, 0, e2, StandardCharsets.UTF_8);
    }

    private static int decode4to3(byte[] source2, int srcOffset, byte[] destination, int destOffset) {
        if (source2[srcOffset + 2] == 61) {
            int outBuff = (DEC[source2[srcOffset]] & 0xFF) << 18 | (DEC[source2[srcOffset + 1]] & 0xFF) << 12;
            destination[destOffset] = (byte)(outBuff >>> 16);
            return 1;
        }
        if (source2[srcOffset + 3] == 61) {
            int outBuff = (DEC[source2[srcOffset]] & 0xFF) << 18 | (DEC[source2[srcOffset + 1]] & 0xFF) << 12 | (DEC[source2[srcOffset + 2]] & 0xFF) << 6;
            destination[destOffset] = (byte)(outBuff >>> 16);
            destination[destOffset + 1] = (byte)(outBuff >>> 8);
            return 2;
        }
        int outBuff = (DEC[source2[srcOffset]] & 0xFF) << 18 | (DEC[source2[srcOffset + 1]] & 0xFF) << 12 | (DEC[source2[srcOffset + 2]] & 0xFF) << 6 | DEC[source2[srcOffset + 3]] & 0xFF;
        destination[destOffset] = (byte)(outBuff >> 16);
        destination[destOffset + 1] = (byte)(outBuff >> 8);
        destination[destOffset + 2] = (byte)outBuff;
        return 3;
    }

    public static byte[] decode(byte[] source2, int off, int len2) {
        byte[] outBuff = new byte[len2 * 3 / 4];
        int outBuffPosn = 0;
        byte[] b4 = new byte[4];
        int b4Posn = 0;
        int i2 = off;
        while (i2 < off + len2) {
            byte sbiCrop = (byte)(source2[i2] & 0x7F);
            byte sbiDecode = DEC[sbiCrop];
            if (-1 <= sbiDecode) {
                b4[b4Posn++] = sbiCrop;
                if (b4Posn > 3) {
                    outBuffPosn += Base64.decode4to3(b4, 0, outBuff, outBuffPosn);
                    b4Posn = 0;
                    if (sbiCrop == 61) {
                        break;
                    }
                }
            } else if (sbiDecode != -2) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().badBase64InputCharacterAt, i2, source2[i2] & 0xFF));
            }
            ++i2;
        }
        if (outBuff.length == outBuffPosn) {
            return outBuff;
        }
        byte[] out2 = new byte[outBuffPosn];
        System.arraycopy(outBuff, 0, out2, 0, outBuffPosn);
        return out2;
    }

    public static byte[] decode(String s2) {
        byte[] bytes = s2.getBytes(StandardCharsets.UTF_8);
        return Base64.decode(bytes, 0, bytes.length);
    }
}

